/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.chooser.impl;

import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import com.tssap.util.ui.reuse.chooser.IDisplayableChooser;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;

public class ObjectSelectionChooser
implements IDisplayableChooser {
    private String title;
    private String message;
    private String[] selectables;
    private ILabelProvider labelProvider;

    public ObjectSelectionChooser(String title, String message, String[] selectables) {
        this.setTitle(title);
        this.setMessage(message);
        this.setSelectables(selectables);
    }

    public ObjectSelectionChooser(String title, String message, String[] selectables, ILabelProvider labelProvider) {
        this(title, message, selectables);
        this.setLabelProvider(labelProvider);
    }

    public String getSelection(String currentText, Shell parentShell) {
        String ret = null;
        ObjectSelectionDialog dialog = new ObjectSelectionDialog(parentShell, this.getTitle(), this.getMessage());
        dialog.setSingleSelection(true);
        dialog.setBlockOnOpen(true);
        dialog.setLabelProvider(this.getLabelProvider());
        List<String> selList = Arrays.asList(this.getSelectables());
        if (selList.contains(currentText)) {
            dialog.setInitialSelections(new String[]{currentText});
        } else if (this.getSelectables().length >= 1) {
            dialog.setInitialSelections(new String[]{this.getSelectables()[0]});
        }
        Object[] objs = dialog.openDialog(this.getSelectables());
        if (objs != null && objs.length >= 1 && objs[0] instanceof String) {
            ret = (String)objs[0];
        }
        return ret;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String[] getSelectables() {
        return this.selectables;
    }

    public void setSelectables(String[] selectables) {
        this.selectables = selectables;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }
}

