/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.chooser.impl;

import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.chooser.IDarkChooser;
import com.tssap.util.ui.reuse.chooser.IDisplayableChooser;
import com.tssap.util.ui.reuse.chooser.IDropDownSelector;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DropDownSelector
extends GenericComponent
implements IDropDownSelector,
FocusListener {
    private static final String DEFAULT_SELECTOR_DESCRIPTION = "";
    private static final boolean DEFAULT_DESCR_POSITION_LEFT = true;
    private static final boolean DEFAULT_READ_ONLY = false;
    private static final String[] DEFAULT_HISTORY = new String[0];
    private static final int DEFAULT_ITEMS_MAX_LENGTH = 10;
    private static final String DEFAULT_SELECTION = "";
    private static final String DEFAULT_BUTTON_TEXT = "Choose";
    private static final boolean DEFAULT_HAS_PUSHBUTTON = true;
    private static final String DEFAULT_TEXT = "";
    private static final boolean DEFAULT_IS_GRAB_HORIZONTAL = true;
    public static final int NUM_GRID_COLS = 4;
    private Control myControl;
    private Combo combo;
    private Text textField;
    private Button pushB;
    private Label descriptionLabel;
    private String initialDescription;
    private boolean initialDescrPositionLeft;
    private String[] initialHistory;
    private int initialItemsMaxLength;
    private String initialButtonText;
    private Image initialButtonImage;
    private String initialButtonTooltip;
    private IChooser initialPushButtonChooser;
    private boolean initialSelectionToHistory = false;
    private boolean initialHasPushButton;
    private String initialText;
    private boolean isGrabHorizontal;
    private boolean isTextFieldReadOnly = false;
    private String[] emptyHistoryData = new String[0];
    private SelectionListener pSl;

    public DropDownSelector(int itemsMaxLength) {
        this();
        this.setInitialItemsMaxLength(itemsMaxLength);
    }

    public DropDownSelector() {
        this.init();
    }

    private void init() {
        this.setSelectorDescription("");
        this.setDescriptionPositionLeft(true);
        this.setReadOnly(false);
        this.setHistory(DEFAULT_HISTORY);
        this.setInitialItemsMaxLength(10);
        this.setButtonText(DEFAULT_BUTTON_TEXT);
        this.setHasPushButton(true);
        this.setText("");
        this.setIsGrabHorizontal(true);
    }

    public Control getControl() {
        return this.myControl;
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.setMargin(0, 0);
        userArea.setSpacing(0, 0);
        if (!this.getSelectorDescription().equals("")) {
            this.positionDescription(userArea);
        }
        if (this.getItemsMaxLength() == 0) {
            this.textField = this.createTextField(userArea);
            this.setText(this.getInitialText());
            this.textField.addModifyListener((ModifyListener)new ModifyAdapter());
        } else {
            this.combo = this.createComboBox(userArea);
            this.combo.addModifyListener((ModifyListener)new ModifyAdapter());
        }
        if (this.isHasPushButton()) {
            this.pushB = this.getButtonImage() != null && this.getButtonText() != null ? this.createImageTextPushButton(userArea) : (this.getButtonImage() != null ? this.createImagePushButton(userArea) : this.createTextPushButton(userArea));
            this.pushB.setEnabled(!this.isReadOnly());
            this.pSl = new PushButtonSelectionListener();
            this.pushB.addSelectionListener(this.pSl);
        } else {
            userArea.addPlaceholder(userArea.createGridLayoutData(2, 2, false, false, 1, 1));
        }
        if (this.getInitialHistory() == null || this.getInitialHistory().length == 0) {
            this.setEmptyHistory();
        }
        if (this.getInitialHistory() != null && this.getInitialHistory().length != 0) {
            this.setHistory(this.getInitialHistory());
        }
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    public int getUserGridNumOfColumns() {
        return 4;
    }

    private void positionDescription(IGridLayoutPane userArea) {
        if (this.isDescriptorPositionLeft()) {
            this.descriptionLabel = userArea.addTextLabel(this.getSelectorDescription(), userArea.createGridLayoutData(1, 2, 2, 1));
        } else {
            userArea.addTextLabel(this.getSelectorDescription(), userArea.createGridLayoutData(1, 2, this.getUserGridNumOfColumns(), 1));
        }
    }

    private Combo createComboBox(IGridLayoutPane userArea) {
        Combo combo = userArea.addComboBox(this.getHistory(), this.getText(), this.isReadOnly(), userArea.createGridLayoutData(4, 2, this.isGrabHorizontal(), false, 1, 1));
        combo.addFocusListener((FocusListener)this);
        return combo;
    }

    private Text createTextField(IGridLayoutPane userArea) {
        this.textField = userArea.addTextField(this.isReadOnly(), userArea.createGridLayoutData(4, 2, this.isGrabHorizontal(), false, 1, 1));
        if (!this.isTextFieldReadOnly()) {
            this.textField.setEnabled(!this.isReadOnly());
            this.textField.setEditable(!this.isReadOnly());
        }
        return this.textField;
    }

    private Button createImagePushButton(IGridLayoutPane userArea) {
        Button pushB = userArea.addPushButton(this.getButtonImage(), this.getButtonTooltip(), userArea.createGridLayoutData(2, 2, false, false, 1, 1));
        return pushB;
    }

    private Button createTextPushButton(IGridLayoutPane userArea) {
        Button pushB = userArea.addPushButton(this.getButtonText(), this.getButtonTooltip(), userArea.createGridLayoutData(2, 2, false, false, 1, 1));
        return pushB;
    }

    private Button createImageTextPushButton(IGridLayoutPane userArea) {
        Button pushB = userArea.addPushButton(this.getButtonImage(), this.getButtonText(), userArea.createGridLayoutData(2, 2, false, false, 1, 1));
        return pushB;
    }

    private void buttonPressed(SelectionEvent e) {
        String selection = null;
        if (this.combo != null) {
            if (this.getChooser() instanceof IDisplayableChooser) {
                selection = ((IDisplayableChooser)this.getChooser()).getSelection(this.combo.getText(), this.combo.getShell());
            } else if (this.getChooser() instanceof IDarkChooser) {
                selection = ((IDarkChooser)this.getChooser()).getSelection(this.combo.getText());
            }
            if (selection != null) {
                this.combo.setText(selection);
            }
        } else {
            if (this.getChooser() instanceof IDisplayableChooser) {
                selection = ((IDisplayableChooser)this.getChooser()).getSelection(this.textField.getText(), this.textField.getShell());
            } else if (this.getChooser() instanceof IDarkChooser) {
                selection = ((IDarkChooser)this.getChooser()).getSelection(this.textField.getText());
            }
            if (selection != null) {
                this.textField.setText(selection);
            }
        }
        if (this.isSelectionToHistory() && selection != null) {
            this.addHistoryEntry(selection);
        }
    }

    public String[] getHistory() {
        String[] ret = this.getInitialHistory();
        if (this.getCombo() != null) {
            ret = this.combo.getItems();
        }
        return ret;
    }

    public void setHistory(String[] items) {
        this.setInitialHistory(items);
        if (this.getCombo() != null && items.length != 0) {
            this.combo.removeAll();
            int countMax = Math.min(items.length, this.getItemsMaxLength());
            int i = countMax - 1;
            while (i >= 0) {
                this.addToHistory(items[i]);
                --i;
            }
        }
    }

    private void setEmptyHistory() {
        this.setHistory(new String[0]);
    }

    public void addSelectionToHistory() {
        this.addToHistory(this.combo.getText());
    }

    public void addHistoryEntry(String entry) {
        this.addToHistory(entry);
    }

    private void addToHistory(String newItem) {
        int index = this.combo.indexOf(newItem);
        if (index == 0 && this.combo.getText() != newItem) {
            this.combo.select(0);
        } else if (index > 0) {
            this.combo.remove(index);
            this.combo.add(newItem, 0);
            this.combo.select(0);
        } else {
            this.combo.add(newItem, 0);
            if (this.combo.getItemCount() > this.getItemsMaxLength()) {
                this.combo.remove(this.combo.getItemCount() - 1);
            }
            this.combo.select(0);
        }
    }

    private IChooser getChooser() {
        return this.getPushButtonChooser();
    }

    private Combo getCombo() {
        return this.combo;
    }

    private void setChooser(IChooser pushButtonChooser) {
        this.setPushButtonChooser(pushButtonChooser);
    }

    private void setCombo(Combo combo) {
        this.combo = combo;
    }

    public int getHistoryLength() {
        int ret = 0;
        if (this.getHistory() != null) {
            ret = this.getHistory().length;
        }
        return ret;
    }

    public void setItemsMaxLength(int itemsMaxLength) {
        if (itemsMaxLength < 0) {
            throw new IllegalArgumentException("ItemLength has to be positve.");
        }
        this.setInitialItemsMaxLength(itemsMaxLength);
        if (this.combo != null) {
            int count = this.combo.getItemCount() - itemsMaxLength;
            int i = 0;
            while (i < count) {
                this.combo.remove(this.combo.getItemCount() - 1);
                ++i;
            }
        }
    }

    public boolean isReadOnly() {
        return !this.isEditable();
    }

    public void setTextFieldReadOnly(boolean readOnly) {
        this.isTextFieldReadOnly = readOnly;
        this.updateEditableBehavior();
    }

    public void setReadOnly(boolean readOnly) {
        this.setEditable(!readOnly);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    private Button getPushButton() {
        return this.pushB;
    }

    private boolean isHasPushButton() {
        return this.getInitialHasPushButton();
    }

    private Text getTextField() {
        return this.textField;
    }

    private void setTextField(Text textField) {
        this.textField = textField;
    }

    public Image getButtonImage() {
        return this.getInitialButtonImage();
    }

    public String getButtonText() {
        return this.getInitialButtonText();
    }

    public String getButtonTooltip() {
        return this.getInitialButtonTooltip();
    }

    public String getText() {
        String ret = this.getInitialText();
        if (!this.isComposable()) {
            if (this.getTextField() != null) {
                ret = this.getTextField().getText();
            } else if (this.getCombo() != null) {
                ret = this.getCombo().getText();
            }
        }
        return ret;
    }

    public int getItemsMaxLength() {
        return this.getInitialItemsMaxLength();
    }

    public IChooser getPushButtonChooser() {
        return this.getInitialPushButtonChooser();
    }

    public String getSelectorDescription() {
        return this.getInitialSelectorDescription();
    }

    public boolean hasPushButton() {
        return this.getInitialHasPushButton();
    }

    public boolean isSelectionToHistory() {
        return this.isInitialSelectionToHistory();
    }

    public void setButtonImage(Image buttonImage) {
        this.setInitialButtonImage(buttonImage);
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("buttonImage");
        }
    }

    public void setButtonText(String buttonText) {
        this.setInitialButtonText(buttonText);
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("buttonText");
        }
    }

    public void setButtonTooltip(String buttonTooltip) {
        this.setInitialButtonTooltip(buttonTooltip);
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("buttonTooltip");
        }
    }

    public void setHasPushButton(boolean hasPushButton) {
        this.setInitialHasPushButton(hasPushButton);
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("hasPushButton");
        }
    }

    public void setPushButtonChooser(IChooser pushButtonChooser) {
        this.setInitialPushButtonChooser(pushButtonChooser);
    }

    public void setSelectionToHistory(boolean selectionToHistory) {
        this.setInitialSelectionToHistory(selectionToHistory);
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("selectionToHistory");
        }
    }

    public void setSelectorDescription(String description) {
        this.setInitialSelectorDescription(description);
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("description");
        }
    }

    public boolean isDescriptorPositionLeft() {
        return this.isInitialDescrPositionLeft();
    }

    public void setDescriptionPositionLeft(boolean left) {
        if (this.isComposable()) {
            this.setInitialDescrPositionLeft(left);
        } else {
            this.throwFeatureNotModifyableException("description position left");
        }
    }

    public void setText(String text) {
        if (this.getCombo() != null) {
            this.getCombo().setText(text);
        }
        if (this.getTextField() != null) {
            this.getTextField().setText(text);
        }
        this.setInitialText(text);
    }

    private void setInitialButtonImage(Image buttonImage) {
        this.initialButtonImage = buttonImage;
    }

    private void setInitialButtonText(String buttonText) {
        this.initialButtonText = buttonText;
    }

    private void setInitialButtonTooltip(String buttonTooltip) {
        this.initialButtonTooltip = buttonTooltip;
    }

    private void setInitialHasPushButton(boolean hasPushButton) {
        this.initialHasPushButton = hasPushButton;
    }

    private void setInitialHistory(String[] history) {
        this.initialHistory = history;
    }

    private void setInitialItemsMaxLength(int itemsMaxLength) {
        this.initialItemsMaxLength = itemsMaxLength;
    }

    private void setInitialPushButtonChooser(IChooser pushButtonChooser) {
        this.initialPushButtonChooser = pushButtonChooser;
    }

    private void setInitialSelectionToHistory(boolean selectionToHistory) {
        this.initialSelectionToHistory = selectionToHistory;
    }

    private void setInitialSelectorDescription(String description) {
        this.initialDescription = description;
    }

    private Image getInitialButtonImage() {
        return this.initialButtonImage;
    }

    private String getInitialButtonText() {
        return this.initialButtonText;
    }

    private String getInitialButtonTooltip() {
        return this.initialButtonTooltip;
    }

    private boolean getInitialHasPushButton() {
        return this.initialHasPushButton;
    }

    private String[] getInitialHistory() {
        return this.initialHistory;
    }

    private int getInitialItemsMaxLength() {
        return this.initialItemsMaxLength;
    }

    private IChooser getInitialPushButtonChooser() {
        return this.initialPushButtonChooser;
    }

    private boolean isInitialSelectionToHistory() {
        return this.initialSelectionToHistory;
    }

    private String getInitialSelectorDescription() {
        return this.initialDescription;
    }

    private boolean isInitialDescrPositionLeft() {
        return this.initialDescrPositionLeft;
    }

    private String getInitialText() {
        return this.initialText;
    }

    private void setInitialDescrPositionLeft(boolean initialDescrPositionLeft) {
        this.initialDescrPositionLeft = initialDescrPositionLeft;
    }

    private void setInitialText(String initialText) {
        this.initialText = initialText;
    }

    public boolean isGrabHorizontal() {
        return this.isGrabHorizontal;
    }

    public void setIsGrabHorizontal(boolean isGrabHorizontal) {
        this.isGrabHorizontal = isGrabHorizontal;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getDescriptionLabel() != null) {
            this.getDescriptionLabel().setEnabled(enabled);
        }
        if (this.getTextField() != null) {
            if (this.isReadOnly()) {
                this.getTextField().setEnabled(false);
                this.getTextField().setEditable(false);
            } else if (!this.isTextFieldReadOnly()) {
                this.getTextField().setEnabled(enabled);
                this.getTextField().setEditable(enabled);
            }
        }
        if (this.getCombo() != null) {
            if (this.isReadOnly()) {
                this.getCombo().setEnabled(false);
            } else {
                this.getCombo().setEnabled(enabled);
            }
        }
        if (this.getPushButton() != null) {
            if (this.isReadOnly()) {
                this.getPushButton().setEnabled(false);
            } else {
                this.getPushButton().setEnabled(enabled);
            }
        }
    }

    private Label getDescriptionLabel() {
        return this.descriptionLabel;
    }

    private boolean isTextFieldReadOnly() {
        return this.isTextFieldReadOnly | this.isReadOnly();
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.getTextField() != null) {
            this.getTextField().setEditable(editable && !this.isTextFieldReadOnly());
        }
        if (this.getPushButton() != null) {
            this.getPushButton().setEnabled(editable);
        }
        if (this.getCombo() != null) {
            this.getCombo().setEnabled(editable);
        }
    }

    private class ModifyAdapter
    implements ModifyListener {
        private ModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            DropDownSelector.super.fireModifyText(e);
        }
    }

    private class PushButtonSelectionListener
    extends SelectionAdapter {
        private PushButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DropDownSelector.this.buttonPressed(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

