/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse.checkbox;

import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.HandleDropDownSelectors;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.checkbox.CheckboxComponentEventData;
import com.tssap.util.ui.reuse.checkbox.ICheckboxComponent;
import com.tssap.util.ui.reuse.chooser.IDropDownSelector;
import com.tssap.util.ui.reuse.chooser.ITextChooser;
import com.tssap.util.ui.reuse.chooser.impl.DropDownSelector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Button;

public class CheckboxComponent
extends HandleDropDownSelectors
implements ICheckboxComponent,
IReuseable {
    private static final boolean DEFAULT_SELECTOR_HAS_PUSH_BUTTON = true;
    private boolean initialChecked;
    private String initialCboxLabel;
    private ITextChooser initialTextChooser;
    private ITextChooser[] initialTextChoosers;
    private Button checkboxButton;
    private IDropDownSelector[] dropDownSelectors;
    private boolean selectorHasPushButton = true;

    public CheckboxComponent(String initialTitle, boolean initialChecked, ITextChooser[] initialTextChoosers, String initialCboxLabel) {
        this.setTitle(initialTitle);
        this.setChecked(initialChecked);
        this.setTextChoosers(initialTextChoosers);
        this.setCheckboxLabel(initialCboxLabel);
    }

    public void initContainer(IGridLayoutPane userArea) {
        this.setDropDownSelectors(new DropDownSelector[this.getTextChoosers().length]);
        this.positionComponents(userArea);
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    public int getUserGridNumOfColumns() {
        return 4;
    }

    private void positionComponents(IGridLayoutPane grdpane) {
        this.checkboxButton = grdpane.addCheckBox(this.initialCboxLabel, this.isChecked(), grdpane.createGridLayoutData(1, 2, 4, 1));
        this.checkboxButton.setSelection(this.initialChecked);
        this.checkboxButton.addSelectionListener((SelectionListener)new CheckboxSelectionListener());
        int j = 0;
        while (j < this.getTextChoosers().length) {
            String dropDownSelectorLabel;
            ITextChooser textChooser = this.getTextChoosers()[j];
            if (textChooser.getTextEntry() != null) {
                textChooser.getTextEntry();
            }
            if ((dropDownSelectorLabel = textChooser.getTextLabel()) == null) {
                dropDownSelectorLabel = "";
            }
            DropDownSelector dropDownSelector = new DropDownSelector(0);
            dropDownSelector.setIsGrabHorizontal(true);
            dropDownSelector.setSelectorDescription(dropDownSelectorLabel);
            dropDownSelector.setDescriptionPositionLeft(true);
            dropDownSelector.setEditable(false);
            dropDownSelector.setHistory(new String[0]);
            dropDownSelector.setButtonText(textChooser.getButtonText());
            dropDownSelector.setButtonImage(textChooser.getButtonImage());
            dropDownSelector.setHasPushButton(this.isSelectorHasPushButton());
            dropDownSelector.setPushButtonChooser(this.initialTextChoosers[j].getChooser());
            dropDownSelector.addModifyListener(new ModifyAdapter(j));
            this.setDropDownSelector(dropDownSelector, j);
            dropDownSelector.setEditable(this.getCheckboxButton().getSelection() && this.isEditable());
            dropDownSelector.createPartControl(grdpane);
            ++j;
        }
    }

    public void refresh() {
        ITextChooser[] textChoosers = this.getTextChoosers();
        this.setTextChoosers(textChoosers);
        Button checkButton = this.getCheckboxButton();
        checkButton.setSelection(this.getInitialChecked());
        int i = 0;
        while (i < textChoosers.length) {
            ITextChooser textChooser = textChoosers[i];
            IDropDownSelector dropDownSelector = this.getDropDownSelector(i);
            dropDownSelector.setEditable(this.getInitialChecked() && this.isEditable());
            if (dropDownSelector.getText() == null && textChooser.getTextEntry() != null) {
                dropDownSelector.setText(textChooser.getTextEntry());
            }
            this.setDropDownSelector(dropDownSelector, i);
            ++i;
        }
    }

    public ITextChooser[] getTextChoosers() {
        return this.getInitialTextChoosers();
    }

    private ITextChooser[] getInitialTextChoosers() {
        return this.initialTextChoosers;
    }

    public boolean isChecked() {
        return this.initialChecked;
    }

    public String getCheckboxLabel() {
        return this.getInitialCheckboxLabel();
    }

    private String getInitialCheckboxLabel() {
        return this.initialCboxLabel;
    }

    public void setChecked(boolean initialChecked) {
        this.setInitialChecked(initialChecked);
        if (this.getCheckboxButton() != null) {
            this.getCheckboxButton().setSelection(initialChecked);
            int i = 0;
            while (i < this.getDropDownSelectors().length) {
                this.getDropDownSelectors()[i].setEditable(this.isChecked() && this.isEditable());
                ++i;
            }
        }
    }

    private void setInitialChecked(boolean initialChecked) {
        this.initialChecked = initialChecked;
    }

    public void setCheckboxLabel(String initialCboxLabel) {
        this.setInitialCheckboxLabel(initialCboxLabel);
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("initialCboxLabel");
        }
    }

    private void setInitialCheckboxLabel(String initialCboxLabel) {
        this.initialCboxLabel = initialCboxLabel;
    }

    private void checkboxSelected(SelectionEvent e) {
        this.setInitialChecked(this.getCheckboxButton().getSelection());
        int i = 0;
        while (i < this.getDropDownSelectors().length) {
            this.getDropDownSelectors()[i].setEditable(this.isChecked() && this.isEditable());
            ++i;
        }
    }

    public ITextChooser getTextChooser(int index) {
        return this.getTextChoosers()[index];
    }

    private ITextChooser getInitialTextChooser(int index) {
        return this.initialTextChoosers[index];
    }

    public void setTextChooser(ITextChooser initialTextChooser, int index) {
        this.setInitialTextChooser(initialTextChooser, index);
        IDropDownSelector dds = this.getDropDownSelector(index);
        if (dds != null) {
            dds.setPushButtonChooser(initialTextChooser);
        }
    }

    private void setInitialTextChooser(ITextChooser initialTextChooser, int index) {
        if (this.getDropDownSelector(index) != null && initialTextChooser.getTextEntry() != null) {
            this.getDropDownSelector(index).setText(initialTextChooser.getTextEntry());
        }
    }

    public void setTextChoosers(ITextChooser[] initialTextChoosers) {
        block5: {
            block3: {
                block4: {
                    if (this.getInitialTextChoosers() == null) break block3;
                    int tChooserLength = 0;
                    tChooserLength = this.getInitialTextChoosers().length;
                    this.setInitialTextChoosers(initialTextChoosers);
                    if (this.initialTextChoosers.length != tChooserLength) break block4;
                    if (this.isComposable()) break block5;
                    int i = 0;
                    while (i < initialTextChoosers.length) {
                        this.setTextChooser(initialTextChoosers[i], i);
                        ++i;
                    }
                    break block5;
                }
                this.throwFeatureNotModifyableException("initialTextChoosers");
                break block5;
            }
            this.setInitialTextChoosers(initialTextChoosers);
            if (!this.isComposable()) {
                int i = 0;
                while (i < initialTextChoosers.length) {
                    this.setTextChooser(initialTextChoosers[i], i);
                    ++i;
                }
            }
        }
    }

    private void setInitialTextChoosers(ITextChooser[] initialTextChoosers) {
        this.initialTextChoosers = initialTextChoosers;
    }

    public boolean getChecked() {
        return this.getInitialChecked();
    }

    private boolean getInitialChecked() {
        return this.initialChecked;
    }

    private TypedEvent improveEvent(TypedEvent e, int index) {
        TypedEvent ret = e;
        e.data = new CheckboxComponentEventData(index, this.getTextChooser(index));
        return ret;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getCheckboxButton() != null) {
            this.getCheckboxButton().setEnabled(enabled);
        }
    }

    private Button getCheckboxButton() {
        return this.checkboxButton;
    }

    private boolean isSelectorHasPushButton() {
        return this.selectorHasPushButton;
    }

    public void setSelectorHasPushButton(boolean selectorHasPushButton) {
        this.setInitialSelectorHasPushButton(selectorHasPushButton);
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("selectorHasPushButton");
        }
    }

    public void setInitialSelectorHasPushButton(boolean selectorHasPushButton) {
        this.selectorHasPushButton = selectorHasPushButton;
    }

    protected void updateEditableBehavior() {
        IDropDownSelector[] dropDownSelectors;
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.getCheckboxButton() != null) {
            this.getCheckboxButton().setEnabled(editable);
        }
        if ((dropDownSelectors = this.getDropDownSelectors()) != null) {
            int i = 0;
            while (i < dropDownSelectors.length) {
                if (dropDownSelectors[i] != null) {
                    dropDownSelectors[i].setEditable(editable && this.isChecked());
                }
                ++i;
            }
        }
    }

    private class ModifyAdapter
    implements ModifyListener {
        private int index = -1;

        public ModifyAdapter(int index) {
            this.setIndex(index);
        }

        public void modifyText(ModifyEvent e) {
            String newText = CheckboxComponent.super.getDropDownSelector(this.getIndex()).getText();
            CheckboxComponent.this.improveEvent((TypedEvent)e, this.getIndex());
            CheckboxComponent.this.getTextChooser(this.getIndex()).setTextEntry(newText);
            CheckboxComponent.super.fireModifyText(e);
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    private class CheckboxSelectionListener
    extends SelectionAdapter {
        private CheckboxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            CheckboxComponent.this.checkboxSelected(e);
            CheckboxComponent.super.fireWidgetSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
            CheckboxComponent.super.fireWidgetDefaultSelected(e);
        }
    }
}

