/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse;

import com.tssap.util.ui.ObjectEditorFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TreeEditorComponent
extends GenericComponent
implements ISelectionChangedListener {
    private static final int SPLITTER_WEIGHTH = 4;
    private static final String DEFAULT_TITLE = "";
    private static final int GRID_COL_NUM = 2;
    private static final boolean GRID_EQUAL_COLSIZE = false;
    private boolean secureRemove = true;
    private TreeViewer treeViewer;
    private IStructuredContentProvider myContentProvider = new ViewContentProvider();
    private ILabelProvider myLabelProvider = new LabelProvider();
    private IGridLayoutPane rightGridPane;
    private ISimplePane rightSidePane;
    private IObjectEditorComponent currentObjectEditorComponent;
    private Composite rightSideContainer;

    public TreeEditorComponent() {
    }

    public TreeEditorComponent(String title) {
        super(title);
    }

    public void initContainer(IGridLayoutPane userArea) {
        this.currentObjectEditorComponent = new EmptyEditorComponent();
        ISashPane splitterPane = userArea.addHorizontalSashPane(userArea.createGridLayoutData(4, 4, true, true));
        IGridLayoutPane listGlp = splitterPane.addGridLayoutPane(2);
        TreeViewer treeViewer = listGlp.addTreeViewer(false, listGlp.createGridLayoutData(4, 4, true, true, 2, 1));
        this.setTreeViewer(treeViewer);
        userArea.createGridLayoutData(4, 4, true, true);
        this.rightGridPane = splitterPane.addGridLayoutPane("Module Type", 1);
        this.rightSidePane = this.rightGridPane.addSimplePane();
        this.rightSideContainer = this.rightSidePane.getComposite();
        treeViewer.setContentProvider((IContentProvider)this.myContentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)this.myLabelProvider);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        treeViewer.setInput((Object)DEFAULT_TITLE);
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void setTreeViewer(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().getTree().setEnabled(enabled);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IObjectEditorComponent newComponent;
        System.out.println("SelChanged" + event);
        this.currentObjectEditorComponent = newComponent = ObjectEditorFactory.getObjectEditorComponent(event.getSelection());
        Control[] children = this.rightSideContainer.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.currentObjectEditorComponent.createPartControl(this.rightSideContainer);
        Point size = this.rightSideContainer.getSize();
        ++size.x;
        this.rightSideContainer.setSize(size);
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    public IStructuredContentProvider getTreeContentProvider() {
        return this.myContentProvider;
    }

    public ILabelProvider getTreeLabelProvider() {
        return this.myLabelProvider;
    }

    public void setTreeContentProvider(IStructuredContentProvider myContentProvider) {
        this.myContentProvider = myContentProvider;
    }

    public void setTreeLabelProvider(ILabelProvider myLabelProvider) {
        this.myLabelProvider = myLabelProvider;
    }

    class EmptyEditorComponent
    implements IObjectEditorComponent {
        EmptyEditorComponent() {
        }

        public Control createPartControl(Composite parent) {
            return null;
        }

        public void dispose() {
        }

        public Object getData() {
            return null;
        }

        public boolean isDataAutoRefreshing() {
            return true;
        }

        public void refreshDataFromUI() {
        }

        public void refreshUIFromData() {
        }

        public void setData(Object data) {
        }

        public Control createPartControl(IGridLayoutPane glp) {
            return null;
        }

        public boolean isEnabled() {
            return false;
        }

        public void setEnabled(boolean enabled) {
        }

        public String okToLeave() {
            return null;
        }

        public IModifiedCallback getModifiedCallback() {
            return null;
        }

        public void setModifiedCallback(IModifiedCallback callback) {
        }

        public void setEditable(boolean editable) {
        }

        public boolean isEditable() {
            return false;
        }
    }

    class TreeParent
    extends TreeObject {
        private ArrayList children = new ArrayList();

        public TreeParent(String name) {
            super(name);
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            ((AbstractCollection)this.children).remove(child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            return this.children.toArray(new TreeObject[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    class TreeObject
    implements IAdaptable {
        private String name;
        private TreeParent parent;

        public TreeObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }

        public Object getAdapter(Class key) {
            return null;
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        private TreeParent invisibleRoot;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (this.invisibleRoot == null) {
                this.initialize();
            }
            return this.getChildren(this.invisibleRoot);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }

        private void initialize() {
            TreeObject to1 = new TreeObject("Leaf 1");
            TreeObject to2 = new TreeObject("Leaf 2");
            TreeObject to3 = new TreeObject("Leaf 3");
            TreeParent p1 = new TreeParent("Parent 1");
            p1.addChild(to1);
            p1.addChild(to2);
            p1.addChild(to3);
            TreeObject to4 = new TreeObject("Leaf 4");
            TreeParent p2 = new TreeParent("Parent 2");
            p2.addChild(to4);
            TreeParent root = new TreeParent("Root");
            root.addChild(p1);
            root.addChild(p2);
            this.invisibleRoot = new TreeParent(TreeEditorComponent.DEFAULT_TITLE);
            this.invisibleRoot.addChild(root);
        }
    }
}

