/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse;

import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IGenericMultiComponent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

public abstract class GenericMultiComponent
extends GenericComponent
implements IGenericMultiComponent {
    private String addButtonText = "Add";
    private String removeButtonText = "Remove";
    private int buttonOrientation = 1024;
    private boolean secureRemove = true;
    private Button addButton;
    private Button removeButton;
    private boolean hasAddRemoveButtons = true;

    public GenericMultiComponent() {
    }

    public GenericMultiComponent(String title) {
        super(title);
    }

    public boolean hasAddRemoveButtons() {
        return this.hasAddRemoveButtons;
    }

    public void setHasAddRemoveButtons(boolean hasAddRemoveButtons) {
        this.hasAddRemoveButtons = hasAddRemoveButtons;
    }

    protected Button createAddButton(IGridLayoutPane userArea, SelectionListener buttonListener) {
        this.addButton = userArea.addPushButton(this.getAddButtonText(), userArea.createGridLayoutData(1, 1));
        this.addButton.addSelectionListener(buttonListener);
        return this.addButton;
    }

    protected Button createRemoveButton(IGridLayoutPane userArea, SelectionListener buttonListener) {
        this.removeButton = userArea.addPushButton(this.getRemoveButtonText(), userArea.createGridLayoutData(1, 1));
        this.removeButton.addSelectionListener(buttonListener);
        this.removeButton.setEnabled(false);
        return this.removeButton;
    }

    public String getAddButtonText() {
        return this.addButtonText;
    }

    public void setAddButtonText(String addButtonText) {
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("Add Button text");
        }
        this.addButtonText = addButtonText;
    }

    public String getRemoveButtonText() {
        return this.removeButtonText;
    }

    public void setRemoveButtonText(String removeButtonText) {
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("Remove Button text");
        }
        this.removeButtonText = removeButtonText;
    }

    public int getButtonOrientation() {
        return this.buttonOrientation;
    }

    public void setButtonOrientation(int buttonOrientation) {
        if (!this.isComposable()) {
            this.throwFeatureNotModifyableException("Button Orientation");
        }
        this.buttonOrientation = buttonOrientation;
    }

    public boolean isSecureRemove() {
        return this.secureRemove;
    }

    public void setSecureRemove(boolean secureRemove) {
        this.secureRemove = secureRemove;
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    private void setAddButton(Button addButton) {
        this.addButton = addButton;
    }

    private void setRemoveButton(Button removeButton) {
        this.removeButton = removeButton;
    }

    protected final void setAddEnabled(boolean enabled) {
        if (this.hasAddRemoveButtons) {
            this.getAddButton().setEnabled(enabled);
        }
    }

    protected final void setRemoveEnabled(boolean enabled) {
        if (this.hasAddRemoveButtons) {
            this.getRemoveButton().setEnabled(enabled);
        }
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getAddButton() != null) {
            this.getAddButton().setEnabled(this.isEditable());
        }
        if (this.getRemoveButton() != null) {
            this.getRemoveButton().setEnabled(this.isEditable());
        }
    }
}

