/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.reuse;

import com.tssap.util.ui.AbstractEditable;
import com.tssap.util.ui.glpc.ContainerFrameworkException;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.reuse.IGenericComponent;
import java.util.Vector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public abstract class GenericComponent
extends AbstractEditable
implements IGenericComponent {
    private String initialTitle;
    private boolean initialEnabled = true;
    private Vector modifyListenersVector;
    private Vector selectionListenersVector;
    private Vector focusListenersVector;
    private IGridLayoutPane userAreaGridLayoutPane = null;

    protected GenericComponent() {
    }

    protected GenericComponent(String title) {
        this();
        this.setTitle(title);
    }

    public final Control createPartControl(IGridLayoutPane glp, boolean grabHorizontal, boolean grabVertical) {
        Composite ret = null;
        String title = this.getTitle();
        IGridLayoutData newGlData = glp.createGridLayoutData(4, 4, grabHorizontal, grabVertical, this.getUserGridNumOfColumns(), 1);
        glp = title != null && title.length() > 0 ? glp.addGridLayoutPane(title, this.getUserGridNumOfColumns(), this.isUserGridEqualColSize(), newGlData) : glp.addGridLayoutPane(this.getUserGridNumOfColumns(), this.isUserGridEqualColSize(), newGlData);
        this.setUserAreaGridLayoutPane(glp);
        this.initContainer(glp);
        ret = glp.getComposite();
        this.updateEditableBehavior();
        return ret;
    }

    public final Control createPartControl(IGridLayoutPane glp) {
        Control ret = null;
        ret = this.createPartControl(glp, true, true);
        return ret;
    }

    public final Control createPartControl(Composite parent) {
        IGridLayoutPane glp;
        Control ret = null;
        if (this.isComposable()) {
            String title = this.getTitle();
            glp = this.isUserGridEqualColSize() ? (title != null ? PaneFactory.createGridLayoutPaneWithTitleEqualCols(parent, title, this.getUserGridNumOfColumns()) : PaneFactory.createGridLayoutPaneEqualCols(parent, this.getUserGridNumOfColumns())) : (title != null ? PaneFactory.createGridLayoutPaneWithTitle(parent, title, this.getUserGridNumOfColumns()) : PaneFactory.createGridLayoutPane(parent, this.getUserGridNumOfColumns()));
        } else {
            throw new ContainerFrameworkException("Container already composed!");
        }
        ret = this.internalCreatePartControl(glp);
        this.updateEditableBehavior();
        return ret;
    }

    private Control internalCreatePartControl(IGridLayoutPane glp) {
        Composite ret = null;
        this.setUserAreaGridLayoutPane(glp);
        this.initContainer(glp);
        ret = glp.getComposite();
        return ret;
    }

    public String getTitle() {
        return this.getInitialTitle();
    }

    public void setTitle(String title) {
        if (this.getUserAreaGridLayoutPane() != null) {
            this.getUserAreaGridLayoutPane().setTitle(title);
        }
        this.setInitialTitle(title);
    }

    public boolean addSelectionListener(SelectionListener selectionListener) {
        return this.getSelectionListenersVector().add(selectionListener);
    }

    public boolean removeSelectionListener(SelectionListener selectionListener) {
        return this.getSelectionListenersVector().remove(selectionListener);
    }

    public boolean addModifyListener(ModifyListener modifyListener) {
        return this.getModifyListenersVector().add(modifyListener);
    }

    public boolean removeModifyListener(ModifyListener modifyListener) {
        return this.getModifyListenersVector().remove(modifyListener);
    }

    protected Vector getModifyListenersVector() {
        if (this.modifyListenersVector == null) {
            this.modifyListenersVector = new Vector();
        }
        return this.modifyListenersVector;
    }

    protected void setModifyListenersVector(Vector modifyListenersVector) {
        this.modifyListenersVector = modifyListenersVector;
    }

    protected Vector getSelectionListenersVector() {
        if (this.selectionListenersVector == null) {
            this.selectionListenersVector = new Vector();
        }
        return this.selectionListenersVector;
    }

    protected void setFocusListenersVector(Vector focusListenersVector) {
        this.focusListenersVector = focusListenersVector;
    }

    protected void setSelectionListenersVector(Vector selectionListenersVector) {
        this.selectionListenersVector = selectionListenersVector;
    }

    protected void fireModifyText(ModifyEvent e) {
        ModifyListener[] listeners = new ModifyListener[]{};
        listeners = (ModifyListener[])this.getModifyListenersVector().toArray(listeners).clone();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].modifyText(e);
            ++i;
        }
    }

    protected void fireWidgetSelected(SelectionEvent e) {
        SelectionListener[] listeners = new SelectionListener[]{};
        listeners = (SelectionListener[])this.getSelectionListenersVector().toArray(listeners).clone();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].widgetSelected(e);
            ++i;
        }
    }

    protected void fireWidgetDefaultSelected(SelectionEvent e) {
        SelectionListener[] listeners = new SelectionListener[]{};
        listeners = (SelectionListener[])this.getSelectionListenersVector().toArray(listeners).clone();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].widgetDefaultSelected(e);
            ++i;
        }
    }

    protected static Event transformEvent(SelectionEvent selEvent) {
        Event ret = new Event();
        ret.height = selEvent.height;
        ret.width = selEvent.width;
        ret.widget = selEvent.widget;
        ret.time = selEvent.time;
        ret.data = selEvent.data;
        return ret;
    }

    public final IGridLayoutPane getUserAreaGridLayoutPane() {
        return this.userAreaGridLayoutPane;
    }

    private boolean setUserAreaGridLayoutPane(IGridLayoutPane userAreaGridLayoutPane) {
        boolean ret = false;
        if (this.getUserAreaGridLayoutPane() == null) {
            this.userAreaGridLayoutPane = userAreaGridLayoutPane;
            ret = true;
        }
        return ret;
    }

    public final boolean isComposable() {
        boolean ret = this.getUserAreaGridLayoutPane() == null;
        return ret;
    }

    private String getInitialTitle() {
        return this.initialTitle;
    }

    private void setInitialTitle(String initialTitle) {
        this.initialTitle = initialTitle;
    }

    protected void throwFeatureNotModifyableException(String feature) {
        throw new ContainerFrameworkException("Feature '" + feature + "' cannot be modified after container composition!");
    }

    public void refresh() {
    }

    public boolean isEnabled() {
        return this.isInitialEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.setInitialEnabled(enabled);
        this.updateEditableBehavior();
    }

    protected final void setInitialEnabled(boolean enabled) {
        this.initialEnabled = enabled;
    }

    protected final boolean isInitialEnabled() {
        return this.initialEnabled;
    }

    public abstract boolean isUserGridEqualColSize();

    public abstract int getUserGridNumOfColumns();

    public abstract void initContainer(IGridLayoutPane var1);
}

