/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.pane.internal;

import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IToolBarPane;
import com.tssap.util.ui.pane.internal.BasicPane;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

final class ToolBarPane
extends BasicPane
implements IToolBarPane {
    private boolean isVertical;

    ToolBarPane(Composite pParent, boolean pIsVertical, IWidgetFactory pWidgetFactory) {
        super(pParent, pWidgetFactory);
        this.isVertical = pIsVertical;
    }

    protected Composite createPaneComposite() {
        ToolBar toolBar = this.getWidgetFactory().createToolBar(this.getPaneParent(), this.isVertical());
        return toolBar;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void addSeparator() {
        ToolBar toolBar = (ToolBar)this.getPaneComposite();
        this.getWidgetFactory().createSeparatorToolItem(toolBar);
    }

    private ToolItem addItem(int style, Image pButtonImage, String pButtonText, String pQuickInfo) {
        ToolBar toolBar = (ToolBar)this.getPaneComposite();
        ToolItem newToolItem = null;
        if (style == 8) {
            newToolItem = this.getWidgetFactory().createPushToolItem(toolBar);
        } else if (style == 32) {
            newToolItem = this.getWidgetFactory().createCheckToolItem(toolBar);
        } else if (style == 16) {
            newToolItem = this.getWidgetFactory().createRadioToolItem(toolBar);
        } else {
            throw new IllegalArgumentException("Unsupported style");
        }
        if (pButtonImage != null) {
            newToolItem.setImage(pButtonImage);
        }
        if (pButtonText != null) {
            newToolItem.setText(pButtonText);
        }
        if (pQuickInfo != null) {
            newToolItem.setToolTipText(pQuickInfo);
        }
        return newToolItem;
    }

    public ToolItem addToolBarButton(Image pButtonImage) {
        return this.addItem(8, pButtonImage, null, null);
    }

    public ToolItem addToolBarButton(String pButtonText) {
        return this.addItem(8, null, pButtonText, null);
    }

    public ToolItem addToolBarButton(Image pButtonImage, String pQuickInfo) {
        return this.addItem(8, pButtonImage, null, pQuickInfo);
    }

    public ToolItem addToolBarButton(String pButtonText, Image pButtonImage) {
        return this.addItem(8, pButtonImage, pButtonText, null);
    }

    public ToolItem addToolBarButton(String pButtonText, String pQuickInfo) {
        return this.addItem(8, null, pButtonText, pQuickInfo);
    }

    public ToolItem addToolBarButton(String pButtonText, Image pButtonImage, String pQuickInfo) {
        return this.addItem(8, pButtonImage, pButtonText, pQuickInfo);
    }

    public ToolItem addPushButton(String text, String quickInfo) {
        return this.addItem(8, null, text, quickInfo);
    }

    public ToolItem addPushButton(Image image, String quickInfo) {
        return this.addItem(8, image, null, quickInfo);
    }

    public ToolItem addPushButton(Image image, String text, String quickInfo) {
        return this.addItem(8, image, text, quickInfo);
    }

    public ToolItem addToggleButton(String text, String quickInfo) {
        return this.addItem(32, null, text, quickInfo);
    }

    public ToolItem addToggleButton(Image image, String quickInfo) {
        return this.addItem(32, image, null, quickInfo);
    }

    public ToolItem addToggleButton(Image image, String text, String quickInfo) {
        return this.addItem(32, image, text, quickInfo);
    }

    public ToolItem addRadioButton(String text, String quickInfo) {
        return this.addItem(16, null, text, quickInfo);
    }

    public ToolItem addRadioButton(Image image, String quickInfo) {
        return this.addItem(16, image, null, quickInfo);
    }

    public ToolItem addRadioButton(Image image, String text, String quickInfo) {
        return this.addItem(16, image, text, quickInfo);
    }
}

