/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.pane.internal;

import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.internal.BasicPane;
import com.tssap.util.ui.pane.internal.GridLayoutPane;
import com.tssap.util.ui.pane.internal.SashPane;
import com.tssap.util.ui.pane.internal.SimplePane;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

final class TabbedPane
extends BasicPane
implements ITabbedPane {
    protected static final boolean GRID_EQUAL_SIZED_DEFAULT = false;

    TabbedPane(Composite pParent, IWidgetFactory pWidgetFactory) {
        super(pParent, pWidgetFactory);
    }

    protected Composite createPaneComposite() {
        TabFolder createdComposite = this.getWidgetFactory().createTabFolder(this.getPaneParent());
        return createdComposite;
    }

    public IGridLayoutPane addGridLayoutPaneAsTab(String pTabName, int pNumOfColumns) {
        return this.addGridLayoutPaneAsTab(pTabName, pNumOfColumns, false);
    }

    public IGridLayoutPane addGridLayoutPaneAsTab(String pTabName, int pNumOfColumns, boolean pEqualSizedFlag) {
        Composite gridComposite = this.getWidgetFactory().createComposite(this.getPaneComposite(), false);
        FillLayout gridCompositeLayout = new FillLayout();
        gridComposite.setLayout((Layout)gridCompositeLayout);
        GridLayoutPane newGridLayoutPane = new GridLayoutPane(gridComposite, null, pNumOfColumns, pEqualSizedFlag, this.getWidgetFactory());
        TabItem newItem = this.getWidgetFactory().createTabItem(this.getFolder());
        newItem.setText(pTabName);
        newItem.setControl((Control)gridComposite);
        return newGridLayoutPane;
    }

    public ISashPane addHorizontalSashPaneAsTab(String pTabName) {
        return this.addSashPaneAsTab(pTabName, false);
    }

    public ISashPane addVerticalSashPaneAsTab(String pTabName) {
        return this.addSashPaneAsTab(pTabName, true);
    }

    private ISashPane addSashPaneAsTab(String pTabName, boolean pIsVertical) {
        Composite sashComposite = this.getWidgetFactory().createComposite(this.getPaneComposite(), true);
        FillLayout sashCompositeLayout = new FillLayout();
        sashComposite.setLayout((Layout)sashCompositeLayout);
        SashPane newSashPane = new SashPane(sashComposite, pIsVertical, this.getWidgetFactory());
        TabItem newItem = this.getWidgetFactory().createTabItem(this.getFolder());
        newItem.setText(pTabName);
        newItem.setControl((Control)sashComposite);
        return newSashPane;
    }

    TabFolder getFolder() {
        return (TabFolder)this.getPaneComposite();
    }

    public ISimplePane addSimpleAsTab(String pTabName) {
        Composite simpleComposite = this.getWidgetFactory().createComposite(this.getPaneComposite(), true);
        FillLayout simpleCompositeLayout = new FillLayout();
        simpleComposite.setLayout((Layout)simpleCompositeLayout);
        SimplePane newSimplePane = new SimplePane(simpleComposite, null, this.getWidgetFactory());
        TabItem newItem = this.getWidgetFactory().createTabItem(this.getFolder());
        newItem.setText(pTabName);
        newItem.setControl((Control)simpleComposite);
        return newSimplePane;
    }
}

