/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.pane.internal;

import com.tssap.util.ui.glpc.AbstractGridLayoutPaneContainer;
import com.tssap.util.ui.glpc.ContainerFrameworkException;
import com.tssap.util.ui.glpc.IGridLayoutPaneContainer;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.IToolBarPane;
import com.tssap.util.ui.pane.internal.CompoundPane;
import com.tssap.util.ui.pane.internal.SashPane;
import com.tssap.util.ui.pane.internal.SimplePane;
import com.tssap.util.ui.pane.internal.TabbedPane;
import com.tssap.util.ui.pane.internal.ToolBarPane;
import com.tssap.util.ui.reuse.table.ITableColumn;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.tree.ISapTreeViewer;
import com.tssap.util.ui.viewer.tree.SapTreeLabelProvider;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

final class GridLayoutPane
extends CompoundPane
implements IGridLayoutPane {
    private int numOfColumns;
    private boolean equalColumnSizeFlag;
    private int horizontalMargin = 2;
    private int verticalMargin = 2;
    private int horizontalSpacing = 2;
    private int verticalSpacing = 2;
    private static final int HORIZONTAL_ALIGN_DEFAULT = 1;
    private static final int VERTICAL_ALIGN_DEFAULT = 1;
    private static final boolean HORIZONTAL_GRAB_DEFAULT = false;
    private static final boolean VERTICAL_GRAB_DEFAULT = false;
    private static final int HORIZONTAL_SPAN_DEFAULT = 1;
    private static final int VERTICAL_SPAN_DEFAULT = 1;
    private final IGridLayoutData defaultViewerGridData = this.createGridLayoutData(4, 4, true, true);

    GridLayoutPane(Composite pParent, String pTitle, int pNumOfColumns, boolean pEqualColumnSizeFlag, IWidgetFactory pWidgetFactory) {
        super(pParent, pTitle, pWidgetFactory);
        this.numOfColumns = pNumOfColumns;
        this.equalColumnSizeFlag = pEqualColumnSizeFlag;
    }

    protected Composite createPaneComposite() {
        Group createdComposite;
        if (this.getTitle() != null) {
            createdComposite = this.getWidgetFactory().createGroup(this.getPaneParent(), true);
            createdComposite.setText(this.getTitle());
        } else {
            createdComposite = this.getWidgetFactory().createComposite(this.getPaneParent(), false);
        }
        GridLayout paneLayout = new GridLayout();
        paneLayout.numColumns = this.getNumOfColumns();
        paneLayout.makeColumnsEqualWidth = this.getEqualColumnSizeFlag();
        paneLayout.marginHeight = this.getHorizontalMargin();
        paneLayout.marginWidth = this.getVerticalMargin();
        paneLayout.horizontalSpacing = this.getHorizontalSpacing();
        paneLayout.verticalSpacing = this.getVerticalSpacing();
        createdComposite.setLayout((Layout)paneLayout);
        return createdComposite;
    }

    public int getNumOfColumns() {
        return this.numOfColumns;
    }

    public boolean getEqualColumnSizeFlag() {
        return this.equalColumnSizeFlag;
    }

    public Button addPushButton(String pButtonText, IGridLayoutData pLayoutData) {
        return this.addPushButton(pButtonText, CompoundPane.BUTTON_DEFAULT_IMAGE, "", pLayoutData);
    }

    public Button addPushButton(Image pButtonImage, IGridLayoutData pLayoutData) {
        return this.addPushButton("", pButtonImage, "", pLayoutData);
    }

    public Button addPushButton(String pButtonText, String pButtonTooltip, IGridLayoutData pLayoutData) {
        return this.addPushButton(pButtonText, CompoundPane.BUTTON_DEFAULT_IMAGE, pButtonTooltip, pLayoutData);
    }

    public Button addPushButton(Image pButtonImage, String pButtonTooltip, IGridLayoutData pLayoutData) {
        return this.addPushButton("", pButtonImage, pButtonTooltip, pLayoutData);
    }

    protected Button addPushButton(String pButtonText, Image pButtonImage, String pButtonTooltip, IGridLayoutData pLayoutData) {
        Button newButton = super.addPushButton(pButtonText, pButtonImage, pButtonTooltip);
        newButton.setLayoutData((Object)pLayoutData.getGridData());
        return newButton;
    }

    public Button addToggleButton(String text, IGridLayoutData layoutData) {
        return this.addToggleButton(text, CompoundPane.BUTTON_DEFAULT_IMAGE, "", layoutData);
    }

    public Button addToggleButton(Image image, IGridLayoutData layoutData) {
        return this.addToggleButton("", image, "", layoutData);
    }

    public Button addToggleButton(String text, String toolTip, IGridLayoutData layoutData) {
        return this.addToggleButton(text, CompoundPane.BUTTON_DEFAULT_IMAGE, toolTip, layoutData);
    }

    public Button addToggleButton(Image image, String toolTip, IGridLayoutData layoutData) {
        return this.addToggleButton("", image, toolTip, layoutData);
    }

    protected Button addToggleButton(String text, Image image, String toolTip, IGridLayoutData layoutData) {
        Button newButton = super.addToggleButton(text, image, toolTip);
        newButton.setLayoutData((Object)layoutData.getGridData());
        return newButton;
    }

    public Button addRadioButton(String pButtonText, IGridLayoutData pLayoutData) {
        return this.addRadioButton(pButtonText, CompoundPane.BUTTON_DEFAULT_IMAGE, "", pLayoutData);
    }

    public Button addRadioButton(Image pButtonImage, IGridLayoutData pLayoutData) {
        return this.addRadioButton("", pButtonImage, "", pLayoutData);
    }

    public Button addRadioButton(String pButtonText, String pButtonTooltip, IGridLayoutData pLayoutData) {
        return this.addRadioButton(pButtonText, CompoundPane.BUTTON_DEFAULT_IMAGE, pButtonTooltip, pLayoutData);
    }

    public Button addRadioButton(Image pButtonImage, String pButtonTooltip, IGridLayoutData pLayoutData) {
        return this.addRadioButton("", pButtonImage, pButtonTooltip, pLayoutData);
    }

    protected Button addRadioButton(String pButtonText, Image pButtonImage, String pButtonTooltip, IGridLayoutData pLayoutData) {
        Button newButton = super.addRadioButton(pButtonText, pButtonImage, pButtonTooltip);
        newButton.setLayoutData((Object)pLayoutData.getGridData());
        return newButton;
    }

    public Button addCheckBox(String pCheckBoxText, boolean pCheckBoxValue, IGridLayoutData pLayoutData) {
        Button newCheckBox = super.addCheckBox(pCheckBoxText, pCheckBoxValue);
        newCheckBox.setLayoutData((Object)pLayoutData.getGridData());
        return newCheckBox;
    }

    public Button[] addHorizontalRadioButtonGroup(String pTitle, String[] pRadioButtonText, IGridLayoutData pLayoutData) {
        return this.addHorizontalRadioButtonGroup(pTitle, pRadioButtonText, 0, pLayoutData);
    }

    public Button[] addHorizontalRadioButtonGroup(String pTitle, String[] pRadioButtonText, int pSelectedItem, IGridLayoutData pLayoutData) {
        Button[] buttonsOfGroup = super.addHorizontalRadioButtonGroup(pTitle, pRadioButtonText, pSelectedItem);
        return this.addLayoutToButtonGroup(buttonsOfGroup, pLayoutData);
    }

    public Button[] addVerticalRadioButtonGroup(String pTitle, String[] pRadioButtonText, IGridLayoutData pLayoutData) {
        return this.addVerticalRadioButtonGroup(pTitle, pRadioButtonText, 0, pLayoutData);
    }

    public Button[] addVerticalRadioButtonGroup(String pTitle, String[] pRadioButtonText, int pSelectedItem, IGridLayoutData pLayoutData) {
        Button[] buttonsOfGroup = super.addVerticalRadioButtonGroup(pTitle, pRadioButtonText, pSelectedItem);
        return this.addLayoutToButtonGroup(buttonsOfGroup, pLayoutData);
    }

    private Button[] addLayoutToButtonGroup(Button[] pButtons, IGridLayoutData pLayoutData) {
        if (pButtons.length > 0) {
            Group buttonGroup = (Group)pButtons[0].getParent();
            buttonGroup.setLayoutData((Object)pLayoutData.getGridData());
        }
        return pButtons;
    }

    public Label addTextLabel(String pLabelText, IGridLayoutData pLayoutData) {
        Label newLabel = super.addTextLabel(pLabelText);
        newLabel.setLayoutData((Object)pLayoutData.getGridData());
        return newLabel;
    }

    public Text addTextField(String pDefaultText, IGridLayoutData pLayoutData) {
        Text newTextField = super.addTextField(pDefaultText);
        newTextField.setLayoutData((Object)pLayoutData.getGridData());
        return newTextField;
    }

    public Text addTextField(boolean pReadOnly, IGridLayoutData pLayoutData) {
        Text newTextField = super.addTextField(pReadOnly);
        newTextField.setLayoutData((Object)pLayoutData.getGridData());
        return newTextField;
    }

    public Text addTextField(String pDefaultText, boolean pReadOnly, IGridLayoutData pLayoutData) {
        Text newTextField = super.addTextField(pDefaultText, pReadOnly);
        newTextField.setLayoutData((Object)pLayoutData.getGridData());
        return newTextField;
    }

    public Text addTextPane(String pDefaultText, boolean pReadOnly, IGridLayoutData pLayoutData) {
        Text newTextPane = super.addTextPane(pDefaultText, pReadOnly);
        newTextPane.setLayoutData((Object)pLayoutData.getGridData());
        return newTextPane;
    }

    public Text addTextPane(String pDefaultText, boolean pReadOnly, boolean pWordWrap, IGridLayoutData pLayoutData) {
        Text newTextPane = super.addTextPane(pDefaultText, pReadOnly, pWordWrap);
        newTextPane.setLayoutData((Object)pLayoutData.getGridData());
        return newTextPane;
    }

    public Label addImage(Image pLabelImage, IGridLayoutData pLayoutData) {
        return this.addImage(pLabelImage, true, pLayoutData);
    }

    public Label addImage(Image pLabelImage, boolean pBorderFlag, IGridLayoutData pLayoutData) {
        Label newImageLabel = super.addImage(pLabelImage, pBorderFlag);
        newImageLabel.setLayoutData((Object)pLayoutData.getGridData());
        return newImageLabel;
    }

    public Combo addComboBox(String[] pItems, String pDefaultText, boolean pReadOnly, IGridLayoutData pLayoutData) {
        Combo newCombo = super.addComboBox(pItems, pDefaultText, pReadOnly);
        newCombo.setLayoutData((Object)pLayoutData.getGridData());
        return newCombo;
    }

    public List addList(String[] pItems, IGridLayoutData pLayoutData) {
        return this.addList(pItems, false, pLayoutData);
    }

    public List addList(String[] pItems, boolean enableMultipleSelection, IGridLayoutData pLayoutData) {
        List newList = super.addList(pItems, enableMultipleSelection);
        newList.setLayoutData((Object)pLayoutData.getGridData());
        return newList;
    }

    public void addPlaceholder(int pHorizontalSpan, int pVerticalSpan) {
        this.addPlaceholder(this.createGridLayoutData(1, 1, pHorizontalSpan, pVerticalSpan));
    }

    public void addPlaceholder(IGridLayoutData pLayoutData) {
        Label newPlaceholder = super.addRealPlaceholder();
        newPlaceholder.setLayoutData((Object)pLayoutData.getGridData());
    }

    public Label addHorizontalSeparator() {
        Label separatorLabel = new Label(this.getPaneComposite(), 258);
        IGridLayoutData labLayoutData = this.createGridLayoutData(4, 4, this.getNumOfColumns(), 1);
        separatorLabel.setLayoutData((Object)labLayoutData.getGridData());
        return separatorLabel;
    }

    public CheckboxTableViewer addCheckboxTableViewer(boolean pEnableMultipleSelection, IGridLayoutData pLayoutData) {
        CheckboxTableViewer newCheckboxTableViewer = super.addCheckboxTableViewer(pEnableMultipleSelection);
        newCheckboxTableViewer.getTable().setLayoutData((Object)pLayoutData.getGridData());
        return newCheckboxTableViewer;
    }

    public CheckboxTreeViewer addCheckboxTreeViewer(boolean pEnableMultipleSelection, IGridLayoutData pLayoutData) {
        CheckboxTreeViewer newCheckboxTreeViewer = super.addCheckboxTreeViewer(pEnableMultipleSelection);
        newCheckboxTreeViewer.getTree().setLayoutData((Object)pLayoutData.getGridData());
        return newCheckboxTreeViewer;
    }

    public TextViewer addTextViewer(IGridLayoutData pLayoutData) {
        TextViewer newTextViewer = super.addTextViewer();
        newTextViewer.getTextWidget().setLayoutData((Object)pLayoutData.getGridData());
        return newTextViewer;
    }

    public TextViewer addTextViewer(boolean pWordWrap, IGridLayoutData pLayoutData) {
        TextViewer newTextViewer = super.addTextViewer(pWordWrap);
        newTextViewer.getTextWidget().setLayoutData((Object)pLayoutData.getGridData());
        return newTextViewer;
    }

    public TextViewer addTextViewer(boolean pWordWrap, boolean pReadOnly, IGridLayoutData pLayoutData) {
        TextViewer newTextViewer = super.addTextViewer(pWordWrap, pReadOnly);
        newTextViewer.getTextWidget().setLayoutData((Object)pLayoutData.getGridData());
        return newTextViewer;
    }

    public ListViewer addListViewer(boolean pEnableMultipleSelection, IGridLayoutData pLayoutData) {
        ListViewer newListViewer = super.addListViewer(pEnableMultipleSelection);
        newListViewer.getList().setLayoutData((Object)pLayoutData.getGridData());
        return newListViewer;
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection, IGridLayoutData pLayoutData) {
        TableViewer newTableViewer = super.addTableViewer(pEnableMultipleSelection);
        newTableViewer.getTable().setLayoutData((Object)pLayoutData.getGridData());
        return newTableViewer;
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection, String[] columnLabels, IGridLayoutData pLayoutData) {
        TableViewer newTableViewer = super.addTableViewer(pEnableMultipleSelection, columnLabels);
        newTableViewer.getTable().setLayoutData((Object)pLayoutData.getGridData());
        return newTableViewer;
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection, ITableColumn[] columns, IGridLayoutData pLayoutData) {
        TableViewer newTableViewer = super.addTableViewer(pEnableMultipleSelection, columns);
        newTableViewer.getTable().setLayoutData((Object)pLayoutData.getGridData());
        return newTableViewer;
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection, String[] columnLabels, int[] columnWidths, IGridLayoutData pLayoutData) {
        TableViewer newTableViewer = super.addTableViewer(pEnableMultipleSelection, columnLabels, columnWidths);
        newTableViewer.getTable().setLayoutData((Object)pLayoutData.getGridData());
        return newTableViewer;
    }

    public TreeViewer addTreeViewer(boolean pEnableMultipleSelection, IGridLayoutData pLayoutData) {
        TreeViewer newTreeViewer = super.addTreeViewer(pEnableMultipleSelection);
        newTreeViewer.getTree().setLayoutData((Object)pLayoutData.getGridData());
        return newTreeViewer;
    }

    public TableTreeViewer addTableTreeViewer(boolean pEnableMultipleSelection, IGridLayoutData pLayoutData) {
        TableTreeViewer newTabTreeViewer = super.addTableTreeViewer(pEnableMultipleSelection);
        newTabTreeViewer.getTableTree().setLayoutData((Object)pLayoutData.getGridData());
        return newTabTreeViewer;
    }

    public ISimplePane addSimplePane(boolean fill, boolean grab) {
        return this.addSimplePane(this.TITLE_DEFAULT, fill, grab);
    }

    public ISimplePane addSimplePane(boolean fillHorizontal, boolean fillVertical, boolean grabHorizontal, boolean grabVertical) {
        return this.addSimplePane(this.TITLE_DEFAULT, fillHorizontal, fillVertical, grabHorizontal, grabVertical);
    }

    public ISimplePane addSimplePane(IGridLayoutData pLayoutData) {
        return this.addSimplePane(this.TITLE_DEFAULT, pLayoutData);
    }

    public ISimplePane addSimplePane(String pTitle, boolean fill, boolean grab) {
        return this.addSimplePane(pTitle, fill, fill, grab, grab);
    }

    public ISimplePane addSimplePane(String pTitle, boolean fillHorizontal, boolean fillVertical, boolean grabHorizontal, boolean grabVertical) {
        int horizontalfillValue = 1;
        if (fillHorizontal) {
            horizontalfillValue = 4;
        }
        int verticalfillValue = 1;
        if (fillVertical) {
            verticalfillValue = 4;
        }
        return this.addSimplePane(pTitle, this.createGridLayoutData(horizontalfillValue, verticalfillValue, grabHorizontal, grabVertical));
    }

    public ISimplePane addSimplePane(String pTitle, IGridLayoutData pLayoutData) {
        SimplePane newSimplePane = (SimplePane)super.addSimplePane(pTitle);
        newSimplePane.getPaneComposite().setLayoutData((Object)pLayoutData.getGridData());
        return newSimplePane;
    }

    public ISashPane addHorizontalSashPane(IGridLayoutData pLayoutData) {
        SashPane newSashPane = (SashPane)super.addHorizontalSashPane();
        newSashPane.getPaneComposite().getParent().setLayoutData((Object)pLayoutData.getGridData());
        return newSashPane;
    }

    public ISashPane addVerticalSashPane(IGridLayoutData pLayoutData) {
        SashPane newSashPane = (SashPane)super.addVerticalSashPane();
        newSashPane.getPaneComposite().getParent().setLayoutData((Object)pLayoutData.getGridData());
        return newSashPane;
    }

    public IToolBarPane addHorizontalToolBar(IGridLayoutData pLayoutData) {
        ToolBarPane newToolBar = (ToolBarPane)super.addHorizontalToolBar();
        newToolBar.getPaneComposite().setLayoutData((Object)pLayoutData.getGridData());
        return newToolBar;
    }

    public IToolBarPane addVerticalToolBar(IGridLayoutData pLayoutData) {
        ToolBarPane newToolBar = (ToolBarPane)super.addVerticalToolBar();
        newToolBar.getPaneComposite().setLayoutData((Object)pLayoutData.getGridData());
        return newToolBar;
    }

    public ITabbedPane addTabbedPane(IGridLayoutData pLayoutData) {
        TabbedPane newTabbedPane = (TabbedPane)super.addTabbedPane();
        newTabbedPane.getFolder().setLayoutData((Object)pLayoutData.getGridData());
        return newTabbedPane;
    }

    public IGridLayoutPane addGridLayoutPane(int pNumOfColumns, IGridLayoutData pLayoutData) {
        return this.addGridLayoutPane(pNumOfColumns, false, pLayoutData);
    }

    public IGridLayoutPane addGridLayoutPane(int pNumOfColumns, boolean pEqualSizedFlag, IGridLayoutData pLayoutData) {
        GridLayoutPane newGridLayoutPane = (GridLayoutPane)super.addGridLayoutPane(pNumOfColumns, pEqualSizedFlag);
        newGridLayoutPane.setLayoutData(pLayoutData.getGridData());
        return newGridLayoutPane;
    }

    public IGridLayoutPane addGridLayoutPane(String pGroupTitle, int pNumOfColumns, IGridLayoutData pLayoutData) {
        return this.addGridLayoutPane(pGroupTitle, pNumOfColumns, false, pLayoutData);
    }

    public IGridLayoutPane addGridLayoutPane(String pGroupTitle, int pNumOfColumns, boolean pEqualSizedFlag, IGridLayoutData pLayoutData) {
        GridLayoutPane newGridLayoutPane = (GridLayoutPane)super.addGridLayoutPane(pGroupTitle, pNumOfColumns, pEqualSizedFlag);
        newGridLayoutPane.getPaneComposite().setLayoutData((Object)pLayoutData.getGridData());
        return newGridLayoutPane;
    }

    public ISapTableViewer addSapTableViewer(TableModel pTableModel, IGridLayoutData pLayoutData) {
        return this.addSapTableViewer(pTableModel, pLayoutData, false);
    }

    public ISapTableViewer addSapTableViewer(TableModel pTableModel, IGridLayoutData pLayoutData, boolean pSingleSelection) {
        ISapTableViewer newTableViewer = super.addSapTableViewer(pTableModel, pSingleSelection);
        newTableViewer.getTable().getParent().setLayoutData((Object)pLayoutData.getGridData());
        return newTableViewer;
    }

    public ISapTreeViewer addSapTreeViewer(TreeModel pTreeModel, IGridLayoutData pLayoutData) {
        ISapTreeViewer newTreeViewer = super.addSapTreeViewer(pTreeModel);
        newTreeViewer.getTree().getParent().setLayoutData((Object)pLayoutData.getGridData());
        return newTreeViewer;
    }

    public ISapTreeViewer addSapTreeViewer(TreeModel pTreeModel, SapTreeLabelProvider pTreeLabelProvider, IGridLayoutData pLayoutData) {
        ISapTreeViewer newTreeViewer = super.addSapTreeViewer(pTreeModel, pTreeLabelProvider);
        newTreeViewer.getTree().getParent().setLayoutData((Object)pLayoutData.getGridData());
        return newTreeViewer;
    }

    public void addGridLayoutPaneContainer(IGridLayoutPaneContainer pContainer, IGridLayoutData pLayoutData) {
        try {
            ((AbstractGridLayoutPaneContainer)pContainer).composeGridLayoutPaneContainer(this, this.getWidgetFactory(), pLayoutData);
        }
        catch (ClassCastException e) {
            throw new ContainerFrameworkException("Any GridLayoutPaneContainer class has to extend class AbstractGridLayoutPaneContainer.");
        }
    }

    public IGridLayoutData createGridLayoutData() {
        return new GridLayoutData(1, 1, false, false, 1, 1);
    }

    public IGridLayoutData createGridLayoutData(int pHorizontalAlignment, int pVerticalAlignment) {
        return new GridLayoutData(pHorizontalAlignment, pVerticalAlignment, false, false, 1, 1);
    }

    public IGridLayoutData createGridLayoutData(int pHorizontalAlignment, int pVerticalAlignment, int pHorizontalSpan, int pVerticalSpan) {
        return new GridLayoutData(pHorizontalAlignment, pVerticalAlignment, false, false, pHorizontalSpan, pVerticalSpan);
    }

    public IGridLayoutData createGridLayoutData(int pHorizontalAlignment, int pVerticalAlignment, boolean pGrabHorizontal, boolean pGrabVertical) {
        return new GridLayoutData(pHorizontalAlignment, pVerticalAlignment, pGrabHorizontal, pGrabVertical, 1, 1);
    }

    public IGridLayoutData createGridLayoutData(boolean pGrabHorizontal, boolean pGrabVertical) {
        return new GridLayoutData(1, 1, pGrabHorizontal, pGrabVertical, 1, 1);
    }

    public IGridLayoutData createGridLayoutData(boolean pGrabHorizontal, boolean pGrabVertical, int pHorizontalSpan, int pVerticalSpan) {
        return new GridLayoutData(1, 1, pGrabHorizontal, pGrabVertical, pHorizontalSpan, pVerticalSpan);
    }

    public IGridLayoutData createGridLayoutData(int pHorizontalAlignment, int pVerticalAlignment, boolean pGrabHorizontal, boolean pGrabVertical, int pHorizontalSpan, int pVerticalSpan) {
        return new GridLayoutData(pHorizontalAlignment, pVerticalAlignment, pGrabHorizontal, pGrabVertical, pHorizontalSpan, pVerticalSpan);
    }

    public Button addCheckBox() {
        return this.addCheckBox("");
    }

    public Button addCheckBox(String pCheckBoxText) {
        return this.addCheckBox(pCheckBoxText, false);
    }

    public Button addCheckBox(String pCheckBoxText, boolean pCheckBoxValue) {
        return this.addCheckBox(pCheckBoxText, pCheckBoxValue, this.createGridLayoutData());
    }

    public Label addImage(Image pImage) {
        return this.addImage(pImage, this.createGridLayoutData());
    }

    public Label addImage(Image pImage, boolean pBorderFlag) {
        return this.addImage(pImage, pBorderFlag, this.createGridLayoutData());
    }

    public Combo addComboBox() {
        return this.addComboBox(new String[0]);
    }

    public Combo addComboBox(String[] pItems) {
        return this.addComboBox(pItems, "");
    }

    public Combo addComboBox(String[] pItems, boolean pReadOnly) {
        return this.addComboBox(pItems, "", pReadOnly);
    }

    public Combo addComboBox(String[] pItems, String pDefaultText) {
        return this.addComboBox(pItems, pDefaultText, false);
    }

    public Combo addComboBox(String[] pItems, String pDefaultText, boolean pReadOnly) {
        return this.addComboBox(pItems, pDefaultText, pReadOnly, this.createGridLayoutData());
    }

    public Button[] addHorizontalRadioButtonGroup(String[] pRadioButtonText) {
        return this.addHorizontalRadioButtonGroup("", pRadioButtonText);
    }

    public Button[] addHorizontalRadioButtonGroup(String pTitle, String[] pRadioButtonText) {
        return this.addHorizontalRadioButtonGroup(pTitle, pRadioButtonText, 0);
    }

    public Button[] addHorizontalRadioButtonGroup(String pTitle, String[] pRadioButtonText, int pSelectedItem) {
        return this.addHorizontalRadioButtonGroup(pTitle, pRadioButtonText, pSelectedItem, this.createGridLayoutData());
    }

    public Button addPushButton(Image pButtonImage) {
        return this.addPushButton(pButtonImage, this.createGridLayoutData());
    }

    public Button addPushButton(String pButtonText) {
        return this.addPushButton(pButtonText, this.createGridLayoutData());
    }

    public Button addPushButton(Image pButtonImage, String pButtonTooltip) {
        return this.addPushButton(pButtonImage, pButtonTooltip, this.createGridLayoutData());
    }

    public Button addPushButton(String pButtonText, String pButtonTooltip) {
        return this.addPushButton(pButtonText, pButtonTooltip, this.createGridLayoutData());
    }

    public Button addRadioButton(Image pButtonImage) {
        return this.addRadioButton(pButtonImage, this.createGridLayoutData());
    }

    public Button addRadioButton(String pButtonText) {
        return this.addRadioButton(pButtonText, this.createGridLayoutData());
    }

    public Button addRadioButton(Image pButtonImage, String pButtonTooltip) {
        return this.addRadioButton(pButtonImage, pButtonTooltip, this.createGridLayoutData());
    }

    public Button addRadioButton(String pButtonText, String pButtonTooltip) {
        return this.addRadioButton(pButtonText, pButtonTooltip, this.createGridLayoutData());
    }

    public Button addToggleButton(Image image) {
        return this.addToggleButton(image, this.createGridLayoutData());
    }

    public Button addToggleButton(String text) {
        return this.addToggleButton(text, this.createGridLayoutData());
    }

    public Button addToggleButton(Image image, String toolTip) {
        return this.addToggleButton(image, toolTip, this.createGridLayoutData());
    }

    public Button addToggleButton(String text, String toolTip) {
        return this.addToggleButton(text, toolTip, this.createGridLayoutData());
    }

    public Label addTextLabel(String pLabelText) {
        return this.addTextLabel(pLabelText, this.createGridLayoutData());
    }

    public Text addTextField(String pDefaultText) {
        return this.addTextField(pDefaultText, false);
    }

    public Text addTextField(boolean pReadOnly) {
        return this.addTextField(pReadOnly, this.createGridLayoutData());
    }

    public Text addTextField(String pDefaultText, boolean pReadOnly) {
        return this.addTextField(pDefaultText, pReadOnly, this.createGridLayoutData());
    }

    public Text addTextPane(String pDefaultText) {
        return this.addTextPane(pDefaultText, false);
    }

    public Text addTextPane(String pDefaultText, boolean pReadOnly) {
        return this.addTextPane(pDefaultText, pReadOnly, this.createGridLayoutData());
    }

    public Text addTextPane(String pDefaultText, boolean pReadOnly, boolean pWordWrap) {
        return this.addTextPane(pDefaultText, pReadOnly, pWordWrap, this.createGridLayoutData());
    }

    public Button[] addVerticalRadioButtonGroup(String[] pRadioButtonText) {
        return this.addVerticalRadioButtonGroup("", pRadioButtonText);
    }

    public Button[] addVerticalRadioButtonGroup(String pTitle, String[] pRadioButtonText) {
        return this.addVerticalRadioButtonGroup(pTitle, pRadioButtonText, 0);
    }

    public Button[] addVerticalRadioButtonGroup(String pTitle, String[] pRadioButtonText, int pSelectedItem) {
        return this.addVerticalRadioButtonGroup(pTitle, pRadioButtonText, pSelectedItem, this.createGridLayoutData());
    }

    public List addList(String[] pItems) {
        return this.addList(pItems, false);
    }

    public List addList(String[] pItems, boolean enableMultipleSelection) {
        return this.addList(pItems, enableMultipleSelection, this.createGridLayoutData());
    }

    public ISimplePane addSimplePane() {
        return this.addSimplePane(this.createGridLayoutData());
    }

    public ISimplePane addSimplePane(String pTitle) {
        return this.addSimplePane(pTitle, this.createGridLayoutData());
    }

    public ITabbedPane addTabbedPane() {
        return this.addTabbedPane(this.createGridLayoutData());
    }

    public IGridLayoutPane addGridLayoutPane(int pNumOfColumns) {
        return this.addGridLayoutPane(pNumOfColumns, this.createGridLayoutData());
    }

    public IGridLayoutPane addGridLayoutPane(int pNumOfColumns, boolean pEqualSizedFlag) {
        return this.addGridLayoutPane(pNumOfColumns, pEqualSizedFlag, this.createGridLayoutData());
    }

    public ISashPane addHorizontalSashPane() {
        return this.addHorizontalSashPane(this.createGridLayoutData());
    }

    public ISashPane addVerticalSashPane() {
        return this.addVerticalSashPane(this.createGridLayoutData());
    }

    public ISapTableViewer addSapTableViewer(TableModel pTableModel) {
        return this.addSapTableViewer(pTableModel, this.createGridLayoutData());
    }

    public ISapTableViewer addSapTableViewer(TableModel pTableModel, boolean pSingleSelection) {
        return this.addSapTableViewer(pTableModel, this.createGridLayoutData(), pSingleSelection);
    }

    public ISapTreeViewer addSapTreeViewer(TreeModel pTreeModel) {
        return this.addSapTreeViewer(pTreeModel, this.createGridLayoutData());
    }

    public ISapTreeViewer addSapTreeViewer(TreeModel pTreeModel, SapTreeLabelProvider pTreeLabelProvider) {
        return this.addSapTreeViewer(pTreeModel, pTreeLabelProvider, this.createGridLayoutData());
    }

    public IToolBarPane addHorizontalToolBar() {
        return this.addHorizontalToolBar(this.createGridLayoutData());
    }

    public IToolBarPane addVerticalToolBar() {
        return this.addVerticalToolBar(this.createGridLayoutData());
    }

    public IGridLayoutPane addGridLayoutPane(String pGroupTitle, int pNumOfColumns, boolean pEqualSizedFlag) {
        return this.addGridLayoutPane(pGroupTitle, pNumOfColumns, pEqualSizedFlag, this.createGridLayoutData());
    }

    public IGridLayoutPane addGridLayoutPane(String pGroupTitle, int pNumOfColumns) {
        return this.addGridLayoutPane(pGroupTitle, pNumOfColumns, this.createGridLayoutData());
    }

    public void addPlaceholder() {
        this.addPlaceholder(this.createGridLayoutData());
    }

    public void addGridLayoutPaneContainer(IGridLayoutPaneContainer pContainer) {
        this.addGridLayoutPaneContainer(pContainer, this.createGridLayoutData());
    }

    public CheckboxTableViewer addCheckboxTableViewer(boolean pEnableMultipleSelection) {
        return this.addCheckboxTableViewer(pEnableMultipleSelection, this.defaultViewerGridData);
    }

    public CheckboxTreeViewer addCheckboxTreeViewer(boolean pEnableMultipleSelection) {
        return this.addCheckboxTreeViewer(pEnableMultipleSelection, this.defaultViewerGridData);
    }

    public TextViewer addTextViewer() {
        return this.addTextViewer(this.defaultViewerGridData);
    }

    public TextViewer addTextViewer(boolean pWordWrap) {
        return this.addTextViewer(pWordWrap, this.defaultViewerGridData);
    }

    public TextViewer addTextViewer(boolean pWordWrap, boolean pReadOnly) {
        return this.addTextViewer(pWordWrap, pReadOnly, this.defaultViewerGridData);
    }

    public ListViewer addListViewer(boolean pEnableMultipleSelection) {
        return this.addListViewer(pEnableMultipleSelection, this.defaultViewerGridData);
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection) {
        return this.addTableViewer(pEnableMultipleSelection, this.defaultViewerGridData);
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection, String[] columnLabels) {
        return this.addTableViewer(pEnableMultipleSelection, columnLabels, this.defaultViewerGridData);
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection, ITableColumn[] columns) {
        return this.addTableViewer(pEnableMultipleSelection, columns, this.defaultViewerGridData);
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection, String[] columnLabels, int[] columnWidths) {
        return this.addTableViewer(pEnableMultipleSelection, columnLabels, columnWidths, this.defaultViewerGridData);
    }

    public TreeViewer addTreeViewer(boolean pEnableMultipleSelection) {
        return this.addTreeViewer(pEnableMultipleSelection, this.defaultViewerGridData);
    }

    public TableTreeViewer addTableTreeViewer(boolean pEnableMultipleSelection) {
        return this.addTableTreeViewer(pEnableMultipleSelection, this.defaultViewerGridData);
    }

    public int getHorizontalMargin() {
        return this.horizontalMargin;
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public int getVerticalMargin() {
        return this.verticalMargin;
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setHorizontalMargin(int horizontalMargin) {
        this.horizontalMargin = horizontalMargin;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
    }

    public void setVerticalMargin(int verticalMargin) {
        this.verticalMargin = verticalMargin;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
    }

    public void setMargin(int newHorizontalMargin, int newVerticalMargin) {
        this.setHorizontalMargin(newHorizontalMargin);
        this.setVerticalMargin(newVerticalMargin);
    }

    public void setSpacing(int newHorizontalSpacing, int newVerticalSpacing) {
        this.setHorizontalSpacing(newHorizontalSpacing);
        this.setVerticalSpacing(newVerticalSpacing);
    }

    private class GridLayoutData
    implements IGridLayoutData {
        private int horizontalAlignment;
        private int verticalAlignment;
        private boolean grabHorizontal;
        private boolean grabVertical;
        private int horizontalSpan;
        private int verticalSpan;

        public GridLayoutData(int pHorizontalAlignment, int pVerticalAlignment, boolean pGrabHorizontal, boolean pGrabVertical, int pHorizontalSpan, int pVerticalSpan) {
            this.horizontalAlignment = pHorizontalAlignment;
            this.verticalAlignment = pVerticalAlignment;
            this.grabHorizontal = pGrabHorizontal;
            this.grabVertical = pGrabVertical;
            this.horizontalSpan = pHorizontalSpan;
            this.verticalSpan = pVerticalSpan;
        }

        public GridData getGridData() {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = this.horizontalAlignment;
            gridData.verticalAlignment = this.verticalAlignment;
            gridData.grabExcessHorizontalSpace = this.grabHorizontal;
            gridData.grabExcessVerticalSpace = this.grabVertical;
            gridData.horizontalSpan = this.horizontalSpan;
            gridData.verticalSpan = this.verticalSpan;
            return gridData;
        }
    }
}

