/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.pane.internal;

import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.ICompoundPane;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.IToolBarPane;
import com.tssap.util.ui.pane.internal.GridLayoutPane;
import com.tssap.util.ui.pane.internal.SashPane;
import com.tssap.util.ui.pane.internal.SimplePane;
import com.tssap.util.ui.pane.internal.TabbedPane;
import com.tssap.util.ui.pane.internal.TitledPane;
import com.tssap.util.ui.pane.internal.ToolBarPane;
import com.tssap.util.ui.reuse.table.ITableColumn;
import com.tssap.util.ui.reuse.table.TableUtil;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.table.SapTableViewer;
import com.tssap.util.ui.viewer.tree.ISapTreeViewer;
import com.tssap.util.ui.viewer.tree.SapTreeLabelProvider;
import com.tssap.util.ui.viewer.tree.SapTreeViewer;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

abstract class CompoundPane
extends TitledPane
implements ICompoundPane {
    protected static final String TEXT_DEFAULT = "";
    protected static final int SELECTED_ITEM_DEFAULT = 0;
    protected static final boolean CHECKBOX_DEFAULT = false;
    protected static final boolean TEXT_READONLY_DEFAULT = false;
    protected static final boolean TEXT_WORDWRAP_DEFAULT = false;
    protected static final boolean GRID_EQUAL_SIZED_DEFAULT = false;
    protected static final boolean COMBO_READONLY_DEFAULT = false;
    protected static final boolean LIST_MULTI_SELECTION_DEFAULT = false;
    protected static final boolean IMAGE_LABEL_BORDER_DEFAULT = true;
    protected static final boolean TABVIEWER_LINES_VISIBLE_DEFAULT = true;
    protected static final boolean TABVIEWER_HEADER_VISIBLE_DEFAULT = true;
    protected static final int TABVIEWER_COLUMN_WIDTH_DEFAULT = 100;
    protected static final String TABVIEWER_EMPTY_COLUMN_HEADER = "";
    protected static final String BUTTON_DEFAULT_TEXT = "";
    protected static final Image BUTTON_DEFAULT_IMAGE = null;
    protected static final String BUTTON_DEFAULT_TOOLTIP = "";
    protected String TITLE_DEFAULT = null;

    CompoundPane(Composite pParent, String pTitle, IWidgetFactory pWidgetFactory) {
        super(pParent, pTitle, pWidgetFactory);
    }

    protected Composite addComposite() {
        Composite newComposite = this.getWidgetFactory().createComposite(this.getPaneComposite(), false);
        return newComposite;
    }

    public Button addPushButton(String pButtonText) {
        return this.addPushButton(pButtonText, BUTTON_DEFAULT_IMAGE, "");
    }

    public Button addPushButton(Image pButtonImage) {
        return this.addPushButton("", pButtonImage, "");
    }

    public Button addPushButton(String pButtonText, String pButtonTooltip) {
        return this.addPushButton(pButtonText, BUTTON_DEFAULT_IMAGE, pButtonTooltip);
    }

    public Button addPushButton(Image pButtonImage, String pButtonTooltip) {
        return this.addPushButton("", pButtonImage, pButtonTooltip);
    }

    protected Button addPushButton(String pButtonText, Image pButtonImage, String pButtonTooltip) {
        return this.getWidgetFactory().createPushButton(this.getPaneComposite(), pButtonText, pButtonImage, pButtonTooltip);
    }

    public Button addToggleButton(Image image) {
        return this.addToggleButton("", image, "");
    }

    public Button addToggleButton(String text) {
        return this.addToggleButton(text, BUTTON_DEFAULT_IMAGE, "");
    }

    public Button addToggleButton(Image image, String toolTip) {
        return this.addToggleButton("", image, toolTip);
    }

    public Button addToggleButton(String text, String toolTip) {
        return this.addToggleButton(text, BUTTON_DEFAULT_IMAGE, toolTip);
    }

    protected Button addToggleButton(String text, Image image, String toolTip) {
        return this.getWidgetFactory().createToggleButton(this.getPaneComposite(), text, image, toolTip);
    }

    public Button addRadioButton(String pButtonText) {
        return this.addRadioButton(pButtonText, BUTTON_DEFAULT_IMAGE, "");
    }

    public Button addRadioButton(Image pButtonImage) {
        return this.addRadioButton("", pButtonImage, "");
    }

    public Button addRadioButton(String pButtonText, String pButtonTooltip) {
        return this.addRadioButton(pButtonText, BUTTON_DEFAULT_IMAGE, pButtonTooltip);
    }

    public Button addRadioButton(Image pButtonImage, String pButtonTooltip) {
        return this.addRadioButton("", pButtonImage, pButtonTooltip);
    }

    protected Button addRadioButton(String pButtonText, Image pButtonImage, String pButtonTooltip) {
        return this.getWidgetFactory().createRadioButton(this.getPaneComposite(), pButtonText, pButtonImage, pButtonTooltip);
    }

    public Button addCheckBox() {
        return this.addCheckBox("");
    }

    public Button addCheckBox(String pCheckBoxText) {
        return this.addCheckBox(pCheckBoxText, false);
    }

    public Button addCheckBox(String pCheckBoxText, boolean pCheckBoxValue) {
        return this.getWidgetFactory().createCheckBox(this.getPaneComposite(), pCheckBoxText, pCheckBoxValue);
    }

    public Button[] addHorizontalRadioButtonGroup(String[] pRadioButtonText) {
        return this.addHorizontalRadioButtonGroup("", pRadioButtonText);
    }

    public Button[] addHorizontalRadioButtonGroup(String pTitle, String[] pRadioButtonText) {
        return this.addHorizontalRadioButtonGroup(pTitle, pRadioButtonText, 0);
    }

    public Button[] addHorizontalRadioButtonGroup(String pTitle, String[] pRadioButtonText, int pSelectedItem) {
        return this.addRadioButtonGroup(pTitle, pRadioButtonText, pSelectedItem, true);
    }

    public Button[] addVerticalRadioButtonGroup(String[] pRadioButtonText) {
        return this.addVerticalRadioButtonGroup("", pRadioButtonText);
    }

    public Button[] addVerticalRadioButtonGroup(String pTitle, String[] pRadioButtonText) {
        return this.addVerticalRadioButtonGroup(pTitle, pRadioButtonText, 0);
    }

    public Button[] addVerticalRadioButtonGroup(String pTitle, String[] pRadioButtonText, int pSelectedItem) {
        return this.addRadioButtonGroup(pTitle, pRadioButtonText, pSelectedItem, false);
    }

    private Button[] addRadioButtonGroup(String pTitle, String[] pRadioButtonText, int pSelectedItem, boolean pIsHorizontalFlag) {
        return this.getWidgetFactory().createRadioButtonGroup(this.getPaneComposite(), pTitle, pRadioButtonText, pSelectedItem, pIsHorizontalFlag);
    }

    public Label addTextLabel(String pLabelText) {
        return this.getWidgetFactory().createTextLabel(this.getPaneComposite(), pLabelText);
    }

    public Text addTextField(String pDefaultText) {
        return this.addTextField(pDefaultText, false);
    }

    public Text addTextField(boolean pReadOnly) {
        return this.addTextField("", pReadOnly);
    }

    public Text addTextField(String pDefaultText, boolean pReadOnly) {
        return this.getWidgetFactory().createTextField(this.getPaneComposite(), pDefaultText, pReadOnly);
    }

    public Text addTextPane(String pDefaultText) {
        return this.addTextPane(pDefaultText, false);
    }

    public Text addTextPane(String pDefaultText, boolean pReadOnly) {
        return this.addTextPane(pDefaultText, pReadOnly, false);
    }

    public Text addTextPane(String pDefaultText, boolean pReadOnly, boolean pWordWrap) {
        return this.getWidgetFactory().createTextPane(this.getPaneComposite(), pDefaultText, pReadOnly, pWordWrap);
    }

    public Label addImage(Image pImage) {
        return this.addImage(pImage, true);
    }

    public Label addImage(Image pImage, boolean pBorderFlag) {
        return this.getWidgetFactory().createImageLabel(this.getPaneComposite(), pImage, pBorderFlag);
    }

    public Combo addComboBox() {
        return this.addComboBox(new String[0]);
    }

    public Combo addComboBox(String[] pItems) {
        return this.addComboBox(pItems, false);
    }

    public Combo addComboBox(String[] pItems, String pDefaultText) {
        return this.addComboBox(pItems, pDefaultText, false);
    }

    public Combo addComboBox(String[] pItems, boolean pReadOnly) {
        return this.addComboBox(pItems, "", pReadOnly);
    }

    public Combo addComboBox(String[] pItems, String pDefaultText, boolean pReadOnly) {
        return this.getWidgetFactory().createComboBox(this.getPaneComposite(), pItems, pDefaultText, pReadOnly);
    }

    public List addList(String[] pItems) {
        return this.addList(pItems, false);
    }

    public List addList(String[] pItems, boolean pEnableMultipleSelection) {
        return this.getWidgetFactory().createList(this.getPaneComposite(), pItems, pEnableMultipleSelection);
    }

    protected Label addRealPlaceholder() {
        Label newPlaceholder = this.getWidgetFactory().createTextLabel(this.getPaneComposite(), "");
        return newPlaceholder;
    }

    public void addPlaceholder() {
        this.addRealPlaceholder();
    }

    public ISimplePane addSimplePane() {
        SimplePane newSimplePane = new SimplePane(this.getPaneComposite(), this.TITLE_DEFAULT, this.getWidgetFactory());
        return newSimplePane;
    }

    public ISimplePane addSimplePane(String pTitle) {
        SimplePane newSimplePane = new SimplePane(this.getPaneComposite(), pTitle, this.getWidgetFactory());
        return newSimplePane;
    }

    public ISashPane addHorizontalSashPane() {
        SashPane newSashPane = new SashPane(this.getPaneComposite(), false, this.getWidgetFactory());
        return newSashPane;
    }

    public ISashPane addVerticalSashPane() {
        SashPane newSashPane = new SashPane(this.getPaneComposite(), true, this.getWidgetFactory());
        return newSashPane;
    }

    public ITabbedPane addTabbedPane() {
        TabbedPane newTabbedPane = new TabbedPane(this.getPaneComposite(), this.getWidgetFactory());
        return newTabbedPane;
    }

    public IGridLayoutPane addGridLayoutPane(int pNumOfColumns) {
        return this.addGridLayoutPane(pNumOfColumns, false);
    }

    public IGridLayoutPane addGridLayoutPane(int pNumOfColumns, boolean pEqualSizedFlag) {
        GridLayoutPane newGridLayoutPane = new GridLayoutPane(this.getPaneComposite(), null, pNumOfColumns, pEqualSizedFlag, this.getWidgetFactory());
        return newGridLayoutPane;
    }

    public IGridLayoutPane addGridLayoutPane(String pTitle, int pNumOfColumns) {
        return this.addGridLayoutPane(pTitle, pNumOfColumns, false);
    }

    public IGridLayoutPane addGridLayoutPane(String pTitle, int pNumOfColumns, boolean pEqualSizedFlag) {
        GridLayoutPane newGridLayoutPane = new GridLayoutPane(this.getPaneComposite(), pTitle, pNumOfColumns, pEqualSizedFlag, this.getWidgetFactory());
        return newGridLayoutPane;
    }

    public ISapTableViewer addSapTableViewer(TableModel pTableModel) {
        return this.addSapTableViewer(pTableModel, false);
    }

    public ISapTableViewer addSapTableViewer(TableModel pTableModel, boolean pSingleSelection) {
        Composite tableComposite = this.addComposite();
        ISapTableViewer newTableViewer = SapTableViewer.createTableViewer(tableComposite, pTableModel, pSingleSelection);
        return newTableViewer;
    }

    public ISapTreeViewer addSapTreeViewer(TreeModel pTreeModel) {
        Composite treeComposite = this.addComposite();
        ISapTreeViewer newTreeViewer = SapTreeViewer.createTreeViewer(treeComposite, pTreeModel);
        return newTreeViewer;
    }

    public ISapTreeViewer addSapTreeViewer(TreeModel pTreeModel, SapTreeLabelProvider pTreeLabelProvider) {
        Composite treeComposite = this.addComposite();
        ISapTreeViewer newTreeViewer = SapTreeViewer.createTreeViewer(treeComposite, pTreeModel, pTreeLabelProvider);
        return newTreeViewer;
    }

    public IToolBarPane addHorizontalToolBar() {
        ToolBarPane newToolBarPane = new ToolBarPane(this.getPaneComposite(), false, this.getWidgetFactory());
        return newToolBarPane;
    }

    public IToolBarPane addVerticalToolBar() {
        ToolBarPane newToolBarPane = new ToolBarPane(this.getPaneComposite(), true, this.getWidgetFactory());
        return newToolBarPane;
    }

    private int getViewerStyle(boolean pEnableMultipleSelection) {
        int viewerStyle = 68352;
        viewerStyle = pEnableMultipleSelection ? (viewerStyle |= 2) : (viewerStyle |= 4);
        return viewerStyle;
    }

    public CheckboxTableViewer addCheckboxTableViewer(boolean pEnableMultipleSelection) {
        boolean checkBoxes = true;
        Table newTable = this.internalCreateTable(pEnableMultipleSelection, true);
        newTable.setLinesVisible(true);
        newTable.setHeaderVisible(true);
        CheckboxTableViewer newCheckBoxTableViewer = new CheckboxTableViewer(newTable);
        return newCheckBoxTableViewer;
    }

    private Table internalCreateTable(boolean pEnableMultipleSelection, boolean checkBoxes) {
        return this.getWidgetFactory().createTable(this.getPaneComposite(), true, true, true, pEnableMultipleSelection, false, true, checkBoxes);
    }

    public CheckboxTreeViewer addCheckboxTreeViewer(boolean pEnableMultipleSelection) {
        boolean checkBoxes = true;
        Tree newTree = this.internalCreateTree(pEnableMultipleSelection, true);
        CheckboxTreeViewer newCheckboxTreeViewer = new CheckboxTreeViewer(newTree);
        return newCheckboxTreeViewer;
    }

    private Tree internalCreateTree(boolean pEnableMultipleSelection, boolean checkBoxes) {
        return this.getWidgetFactory().createTree(this.getPaneComposite(), true, true, true, pEnableMultipleSelection, checkBoxes);
    }

    public TextViewer addTextViewer() {
        return this.addTextViewer(false);
    }

    public TextViewer addTextViewer(boolean pWordWrap) {
        return this.addTextViewer(pWordWrap, false);
    }

    public TextViewer addTextViewer(boolean pWordWrap, boolean pReadOnly) {
        int viewerStyle = this.getViewerStyle(true);
        if (pWordWrap) {
            viewerStyle |= 0x40;
        }
        if (pReadOnly) {
            viewerStyle |= 8;
        }
        TextViewer newTextViewer = new TextViewer(this.getPaneComposite(), viewerStyle);
        newTextViewer.setDocument((IDocument)new Document(""));
        return newTextViewer;
    }

    public ListViewer addListViewer(boolean pEnableMultipleSelection) {
        List newList = new List(this.getPaneComposite(), this.getViewerStyle(pEnableMultipleSelection));
        ListViewer newListViewer = new ListViewer(newList);
        return newListViewer;
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection) {
        return this.addTableViewer(pEnableMultipleSelection, new String[0]);
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection, String[] columnLabels) {
        int[] columnWidths = new int[columnLabels.length];
        int col = 0;
        while (col < columnLabels.length) {
            columnWidths[col] = 100;
            ++col;
        }
        return this.addTableViewer(pEnableMultipleSelection, columnLabels, columnWidths);
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection, ITableColumn[] columns) {
        String[] colLabels = TableUtil.getMappedColumnLabels(columns);
        int[] colWidths = TableUtil.getMappedColumnWidths(columns);
        return this.addTableViewer(pEnableMultipleSelection, colLabels, colWidths);
    }

    protected TableViewer createTableViewer(Table table, String[] columnLabels, int[] columnWidths) {
        TableViewer newTableViewer = new TableViewer(table);
        CellEditor[] cellEditors = new CellEditor[columnLabels.length];
        int col = 0;
        while (col < columnLabels.length) {
            TableColumn tabCol = new TableColumn(table, 0);
            tabCol.setText(columnLabels[col]);
            tabCol.setWidth(columnWidths[col]);
            cellEditors[col] = new TextCellEditor((Composite)table);
            ++col;
        }
        newTableViewer.setCellEditors(cellEditors);
        return newTableViewer;
    }

    public TableViewer addTableViewer(boolean pEnableMultipleSelection, String[] columnLabels, int[] columnWidths) {
        Table newTable = this.internalCreateTable(pEnableMultipleSelection, false);
        newTable.setLinesVisible(true);
        if (columnLabels.length == 0) {
            newTable.setHeaderVisible(false);
            columnLabels = new String[]{""};
            columnWidths = new int[]{100};
        } else {
            newTable.setHeaderVisible(true);
        }
        return this.createTableViewer(newTable, columnLabels, columnWidths);
    }

    public TreeViewer addTreeViewer(boolean pEnableMultipleSelection) {
        Tree newTree = this.internalCreateTree(pEnableMultipleSelection, false);
        TreeViewer newTreeViewer = new TreeViewer(newTree);
        return newTreeViewer;
    }

    public TableTreeViewer addTableTreeViewer(boolean pEnableMultipleSelection) {
        TableTree newTabTree = this.getWidgetFactory().createTableTree(this.getPaneComposite(), true, true, true, pEnableMultipleSelection, false, false);
        TableTreeViewer newTabTreeViewer = new TableTreeViewer(newTabTree);
        return newTabTreeViewer;
    }
}

