/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.pane.internal;

import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IBasicPane;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public abstract class BasicPane
implements IBasicPane {
    private Composite paneParent;
    private Composite paneComposite;
    private boolean borderFlag;
    private IWidgetFactory widgetFactory;
    private Object layoutData;

    private BasicPane() {
    }

    public boolean isPaneModifiable() {
        return this.paneComposite == null;
    }

    protected BasicPane(Composite pParent, IWidgetFactory pWidgetFactory) {
        this.paneParent = pParent;
        this.widgetFactory = pWidgetFactory;
    }

    protected Composite getPaneComposite() {
        if (this.paneComposite == null) {
            this.paneComposite = this.createPaneComposite();
            if (this.layoutData != null) {
                this.paneComposite.setLayoutData(this.layoutData);
            }
        }
        return this.paneComposite;
    }

    public final Composite getPaneParent() {
        return this.paneParent;
    }

    protected abstract Composite createPaneComposite();

    public IWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public Composite getComposite() {
        return this.getPaneComposite();
    }

    public Composite getParent() {
        return this.getPaneParent();
    }

    public void setLayoutData(Object layoutData) {
        this.layoutData = layoutData;
        if (this.paneComposite != null) {
            this.paneComposite.setLayoutData(layoutData);
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        Composite paneComposite = this.getPaneComposite();
        if (paneComposite != null) {
            paneComposite.addDisposeListener(listener);
        }
    }
}

