/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.menu.internal.stat;

import com.tssap.util.ui.IAction;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.menu.IAbstractMenu;
import com.tssap.util.ui.menu.IMenu;
import com.tssap.util.ui.menu.IMenuComponent;
import com.tssap.util.ui.menu.IMenuItem;
import com.tssap.util.ui.menu.IMenuLabelProvider;
import com.tssap.util.ui.menu.IMenuStatus;
import com.tssap.util.ui.menu.IRadioMenu;
import com.tssap.util.ui.menu.IRadioMenuLabel;
import com.tssap.util.ui.menu.ISubMenuLabel;
import com.tssap.util.ui.menu.internal.stat.MenuLabel;

public class SubMenuLabel
extends MenuLabel
implements ISubMenuLabel {
    private IAbstractMenu subMenu;

    public SubMenuLabel(IMenuLabelProvider labelProvider, IMenuStatus menuStatus, IAction action) {
        super(labelProvider, menuStatus, action);
    }

    public SubMenuLabel(IMenuLabelProvider labelProvider, IMenuStatus menuStatus, IAbstractMenu subMenu) {
        this(labelProvider, menuStatus);
        this.setSubMenu(subMenu);
    }

    public SubMenuLabel(IMenuLabelProvider labelProvider, IMenuStatus menuStatus) {
        super(labelProvider, menuStatus);
    }

    public void setSubMenu(IAbstractMenu subMenu) {
        this.subMenu = subMenu;
    }

    public IAbstractMenu getSubMenu() {
        return this.subMenu;
    }

    public boolean isEnabled(IContext context) {
        boolean ret = super.isEnabled(context);
        if (ret) {
            IRadioMenu radioMenu;
            IRadioMenuLabel[] menuComponents;
            IAbstractMenu absMenu = this.getSubMenu();
            if (absMenu instanceof IMenu) {
                IMenu menu = (IMenu)absMenu;
                IMenuComponent[] menuComponents2 = menu.getMenuComponents();
                if (menuComponents2.length <= 0) {
                    ret = false;
                }
                boolean somethingEnabled = false;
                int i = 0;
                while (!somethingEnabled && i < menuComponents2.length) {
                    IMenuItem menuItem;
                    boolean enabled;
                    IMenuComponent iMenuComponent = menuComponents2[i];
                    if (iMenuComponent instanceof IMenuItem && (enabled = (menuItem = (IMenuItem)iMenuComponent).isEnabled(context))) {
                        somethingEnabled = true;
                    }
                    ++i;
                }
                if (!somethingEnabled) {
                    ret = false;
                }
            } else if (absMenu instanceof IRadioMenu && (menuComponents = (radioMenu = (IRadioMenu)absMenu).getMenuComponents()).length <= 0) {
                ret = false;
            }
        }
        return ret;
    }
}

