/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.menu.internal.stat;

import com.tssap.util.ui.IAction;
import com.tssap.util.ui.menu.DefaultMenuStatus;
import com.tssap.util.ui.menu.IMenuLabelProvider;
import com.tssap.util.ui.menu.IMenuStatus;
import com.tssap.util.ui.menu.IRadioAction;
import com.tssap.util.ui.menu.IRadioMenu;
import com.tssap.util.ui.menu.IRadioMenuLabel;
import com.tssap.util.ui.menu.MenuLabelProvider;
import com.tssap.util.ui.menu.RadioActionAdapter;
import com.tssap.util.ui.menu.internal.stat.AbstractMenu;
import com.tssap.util.ui.menu.internal.stat.RadioMenuLabel;
import java.util.Vector;

public class RadioMenu
extends AbstractMenu
implements IRadioMenu {
    private static boolean DEFAULT_RADIO_SEPARATOR_FLAG = false;
    private IRadioAction radioAction;
    private int indexOfSelectedMenuLabel = 0;

    public RadioMenu() {
        this(new DefaultMenuStatus());
    }

    public RadioMenu(IMenuStatus menuStatus) {
        this(menuStatus, new RadioActionAdapter());
    }

    public RadioMenu(IRadioAction radioAction) {
        this(new DefaultMenuStatus(), radioAction);
    }

    public RadioMenu(IMenuStatus menuStatus, IRadioAction radioAction) {
        super(menuStatus);
        this.setRadioAction(radioAction);
    }

    public IRadioMenuLabel[] getMenuComponents() {
        Vector subMenuComponentVector = this.getMenuComponentVector();
        IRadioMenuLabel[] subMenuComponentArray = new IRadioMenuLabel[subMenuComponentVector.size()];
        subMenuComponentArray = subMenuComponentVector.toArray(subMenuComponentArray);
        return subMenuComponentArray;
    }

    public IRadioAction getRadioAction() {
        return this.radioAction;
    }

    public void setRadioAction(IRadioAction radioAction) {
        this.radioAction = radioAction;
    }

    public int getNumberOfMenuComponents() {
        return this.getMenuComponentVector().size();
    }

    public IRadioMenuLabel getSelectedMenuComponent() {
        Vector compoVector = this.getMenuComponentVector();
        int selIndex = this.getIndexOfSelectedMenuCoponent();
        if (compoVector.size() > 0 && selIndex < compoVector.size()) {
            return (IRadioMenuLabel)this.getMenuComponentVector().get(selIndex);
        }
        return null;
    }

    public void setIndexOfSelectedMenuCoponent(int newIndex) {
        this.indexOfSelectedMenuLabel = newIndex;
    }

    public int getIndexOfSelectedMenuCoponent() {
        return this.indexOfSelectedMenuLabel;
    }

    public IRadioMenuLabel[] addRadioMenuActions(String[] menuText) {
        IRadioMenuLabel[] newLabels = new IRadioMenuLabel[menuText.length];
        int t = 0;
        while (t < menuText.length) {
            newLabels[t] = this.addRadioMenuAction(menuText[t]);
            ++t;
        }
        return newLabels;
    }

    public IRadioMenuLabel[] addRadioMenuActions(String[] menuText, IMenuStatus menuStatus) {
        IRadioMenuLabel[] newLabels = new IRadioMenuLabel[menuText.length];
        int t = 0;
        while (t < menuText.length) {
            newLabels[t] = this.addRadioMenuAction(menuText[t], menuStatus);
            ++t;
        }
        return newLabels;
    }

    public IRadioMenuLabel addRadioMenuAction(String menuText) {
        return this.addRadioMenuAction(new MenuLabelProvider(menuText));
    }

    public IRadioMenuLabel addRadioMenuAction(IMenuLabelProvider menuLabelProvider) {
        return this.addRadioMenuAction(menuLabelProvider, (IMenuStatus)new DefaultMenuStatus());
    }

    public IRadioMenuLabel addRadioMenuAction(String menuText, IMenuStatus menuStatus) {
        return this.addRadioMenuAction((IMenuLabelProvider)new MenuLabelProvider(menuText), menuStatus);
    }

    public IRadioMenuLabel addRadioMenuAction(IMenuLabelProvider menuLabelProvider, IMenuStatus menuStatus) {
        RadioMenuLabel newRadioMenuLabel = new RadioMenuLabel(menuLabelProvider, menuStatus);
        this.addMenuComponent(newRadioMenuLabel);
        return newRadioMenuLabel;
    }

    public IRadioMenuLabel addRadioMenuAction(String menuText, IAction menuAction) {
        return this.addRadioMenuAction((IMenuLabelProvider)new MenuLabelProvider(menuText), menuAction);
    }

    public IRadioMenuLabel addRadioMenuAction(IMenuLabelProvider menuLabelProvider, IAction menuAction) {
        return this.addRadioMenuAction(menuLabelProvider, (IMenuStatus)new DefaultMenuStatus(), menuAction);
    }

    public IRadioMenuLabel addRadioMenuAction(String menuText, IMenuStatus menuStatus, IAction menuAction) {
        return this.addRadioMenuAction(new MenuLabelProvider(menuText), menuStatus, menuAction);
    }

    public IRadioMenuLabel addRadioMenuAction(IMenuLabelProvider menuLabelProvider, IMenuStatus menuStatus, IAction menuAction) {
        RadioMenuLabel newRadioMenuLabel = new RadioMenuLabel(menuLabelProvider, menuStatus, menuAction);
        this.addMenuComponent(newRadioMenuLabel);
        return newRadioMenuLabel;
    }

    public IRadioMenuLabel getRadioMenuComponent(int index) {
        Vector compoVector = this.getMenuComponentVector();
        if (compoVector.size() > 0 && index < compoVector.size()) {
            return (IRadioMenuLabel)this.getMenuComponentVector().get(index);
        }
        return null;
    }
}

