/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.menu.internal.stat;

import com.tssap.util.ui.IAction;
import com.tssap.util.ui.menu.DefaultMenuStatus;
import com.tssap.util.ui.menu.IAbstractMenu;
import com.tssap.util.ui.menu.ICheckAction;
import com.tssap.util.ui.menu.ICheckMenuLabel;
import com.tssap.util.ui.menu.IMenu;
import com.tssap.util.ui.menu.IMenuComponent;
import com.tssap.util.ui.menu.IMenuLabel;
import com.tssap.util.ui.menu.IMenuLabelProvider;
import com.tssap.util.ui.menu.IMenuSeparator;
import com.tssap.util.ui.menu.IMenuStatus;
import com.tssap.util.ui.menu.IRadioAction;
import com.tssap.util.ui.menu.IRadioMenu;
import com.tssap.util.ui.menu.MenuLabelProvider;
import com.tssap.util.ui.menu.internal.stat.AbstractMenu;
import com.tssap.util.ui.menu.internal.stat.CheckMenuLabel;
import com.tssap.util.ui.menu.internal.stat.MenuLabel;
import com.tssap.util.ui.menu.internal.stat.MenuSeparator;
import com.tssap.util.ui.menu.internal.stat.RadioMenu;
import com.tssap.util.ui.menu.internal.stat.SubMenuLabel;
import java.util.Vector;

public class Menu
extends AbstractMenu
implements IMenu {
    public static boolean DEFAULT_SEPARATOR_FLAG = true;
    private static IMenuSeparator MENU_SEPARATOR = new MenuSeparator();
    private boolean menuComponentsSeparated = false;
    private static boolean DEFAULT_CHECK_FLAG = false;

    public Menu() {
        this(new DefaultMenuStatus());
    }

    public Menu(IMenuStatus menuStatus) {
        this(menuStatus, DEFAULT_SEPARATOR_FLAG);
    }

    public Menu(IMenuStatus menuStatus, boolean separatorFlag) {
        super(menuStatus);
        this.setMenuComponentsSeparated(separatorFlag);
    }

    public boolean isMenuComponentsSeparated() {
        return this.menuComponentsSeparated;
    }

    public void setMenuComponentsSeparated(boolean separatorFlag) {
        this.menuComponentsSeparated = separatorFlag;
    }

    public IMenuComponent[] getMenuComponents() {
        Vector subMenuComponentVector = this.getMenuComponentVector();
        IMenuComponent[] subMenuComponentArray = new IMenuComponent[subMenuComponentVector.size()];
        subMenuComponentArray = subMenuComponentVector.toArray(subMenuComponentArray);
        return subMenuComponentArray;
    }

    public IMenuLabel addMenuAction(IMenuLabelProvider menuLabelProvider, IAction menuAction) {
        return this.addMenuAction(menuLabelProvider, (IMenuStatus)new DefaultMenuStatus(), menuAction);
    }

    public IMenuLabel addMenuAction(String menuText, IAction menuAction) {
        return this.addMenuAction(new MenuLabelProvider(menuText), menuAction);
    }

    public IMenuLabel addMenuAction(String menuText, IMenuStatus menuStatus, IAction menuAction) {
        return this.addMenuAction(new MenuLabelProvider(menuText), menuStatus, menuAction);
    }

    public IMenuLabel addMenuAction(IMenuLabelProvider menuLabelProvider, IMenuStatus menuStatus, IAction menuAction) {
        MenuLabel newMenuAction = new MenuLabel(menuLabelProvider, menuStatus, menuAction);
        this.addMenuComponent(newMenuAction);
        return newMenuAction;
    }

    public ICheckMenuLabel addCheckableMenuAction(IMenuLabelProvider menuLabelProvider, ICheckAction menuAction) {
        return this.addCheckableMenuAction(menuLabelProvider, (IMenuStatus)new DefaultMenuStatus(), menuAction);
    }

    public ICheckMenuLabel addCheckableMenuAction(String menuText, ICheckAction menuAction) {
        return this.addCheckableMenuAction(menuText, (IMenuStatus)new DefaultMenuStatus(), menuAction);
    }

    public ICheckMenuLabel addCheckableMenuAction(String menuText, IMenuStatus menuStatus, ICheckAction menuAction) {
        return this.addCheckableMenuAction((IMenuLabelProvider)new MenuLabelProvider(menuText), menuStatus, menuAction);
    }

    public ICheckMenuLabel addCheckableMenuAction(IMenuLabelProvider menuLabelProvider, IMenuStatus menuStatus, ICheckAction menuAction) {
        return this.addCheckableMenuAction(menuLabelProvider, menuStatus, DEFAULT_CHECK_FLAG, menuAction);
    }

    public ICheckMenuLabel addCheckableMenuAction(String menuText, boolean checkFlag, ICheckAction menuAction) {
        return this.addCheckableMenuAction((IMenuLabelProvider)new MenuLabelProvider(menuText), checkFlag, menuAction);
    }

    public ICheckMenuLabel addCheckableMenuAction(IMenuLabelProvider menuLabelProvider, boolean checkFlag, ICheckAction menuAction) {
        return this.addCheckableMenuAction(menuLabelProvider, (IMenuStatus)new DefaultMenuStatus(), checkFlag, menuAction);
    }

    public ICheckMenuLabel addCheckableMenuAction(String menuText, IMenuStatus menuStatus, boolean checkFlag, ICheckAction menuAction) {
        return this.addCheckableMenuAction(new MenuLabelProvider(menuText), menuStatus, checkFlag, menuAction);
    }

    public ICheckMenuLabel addCheckableMenuAction(IMenuLabelProvider menuLabelProvider, IMenuStatus menuStatus, boolean checkFlag, ICheckAction menuAction) {
        CheckMenuLabel newCheckAction = new CheckMenuLabel(menuLabelProvider, menuStatus, checkFlag, menuAction);
        this.addMenuComponent(newCheckAction);
        return newCheckAction;
    }

    private IMenu createSubMenu() {
        Menu newSubMenu = new Menu();
        return newSubMenu;
    }

    public IMenu addSubMenu(String menuText) {
        IMenu newSubMenu = this.createSubMenu();
        this.addExistingSubMenu((IAbstractMenu)newSubMenu, menuText);
        return newSubMenu;
    }

    public IMenu addSubMenu(String menuText, IMenuStatus menuStatus) {
        IMenu newSubMenu = this.createSubMenu();
        this.addExistingSubMenu((IAbstractMenu)newSubMenu, menuText, menuStatus);
        return newSubMenu;
    }

    public IMenu addSubMenu(IMenuLabelProvider menuLabelProvider) {
        IMenu newSubMenu = this.createSubMenu();
        this.addExistingSubMenu((IAbstractMenu)newSubMenu, menuLabelProvider);
        return newSubMenu;
    }

    public IMenu addSubMenu(IMenuLabelProvider menuLabelProvider, IMenuStatus menuStatus) {
        IMenu newSubMenu = this.createSubMenu();
        this.addExistingSubMenu((IAbstractMenu)newSubMenu, menuLabelProvider, menuStatus);
        return newSubMenu;
    }

    public void addExistingSubMenu(IAbstractMenu subMenu, String menuText) {
        this.addExistingSubMenu(subMenu, menuText, (IMenuStatus)new DefaultMenuStatus());
    }

    public void addExistingSubMenu(IAbstractMenu subMenu, IMenuLabelProvider menuLabelProvider) {
        this.addExistingSubMenu(subMenu, menuLabelProvider, (IMenuStatus)new DefaultMenuStatus());
    }

    public void addExistingSubMenu(IAbstractMenu subMenu, String menuText, IMenuStatus menuStatus) {
        this.addExistingSubMenu(subMenu, new MenuLabelProvider(menuText), menuStatus);
    }

    public void addExistingSubMenu(IAbstractMenu subMenu, IMenuLabelProvider menuLabelProvider, IMenuStatus menuStatus) {
        SubMenuLabel labelForSubMenu = new SubMenuLabel(menuLabelProvider, menuStatus, subMenu);
        this.addMenuComponent(labelForSubMenu);
    }

    public IMenuSeparator addMenuSeparator() {
        MenuSeparator newSeparator = null;
        Object lastElement = this.getMenuComponentVector().lastElement();
        if (lastElement == null || !(lastElement instanceof IMenuSeparator)) {
            newSeparator = new MenuSeparator();
            this.addMenuComponent(newSeparator);
        }
        return newSeparator;
    }

    public IMenu addMenuPart() {
        Menu newMenuPart = new Menu();
        this.addExistingMenuPart(newMenuPart);
        return newMenuPart;
    }

    public IRadioMenu addRadioMenuPart() {
        RadioMenu newRadioMenuPart = new RadioMenu();
        this.addExistingMenuPart(newRadioMenuPart);
        return newRadioMenuPart;
    }

    public IRadioMenu addRadioMenuPart(IRadioAction radioAction) {
        RadioMenu newRadioMenuPart = new RadioMenu(radioAction);
        this.addExistingMenuPart(newRadioMenuPart);
        return newRadioMenuPart;
    }

    public void addExistingMenuPart(IAbstractMenu menuPart) {
        this.addMenuComponent(menuPart);
    }
}

