/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.menu.internal;

import com.tssap.util.ui.IAction;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.IDescriptionIndicator;
import com.tssap.util.ui.menu.ICheckAction;
import com.tssap.util.ui.menu.ICheckMenuLabel;
import com.tssap.util.ui.menu.IRadioAction;
import com.tssap.util.ui.menu.IRadioMenu;
import com.tssap.util.ui.menu.internal.DescriptorIndicationListener;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MenuItem;

public class MenuListenerFactory {
    public static SelectionListener createStandardListener(IAction action, IContext context) {
        return new ProcessAdapter(action, context);
    }

    public static SelectionListener createRadioListener(IRadioMenu radioMenu, int index) {
        return new RadioMenuListener(radioMenu, index);
    }

    public static SelectionListener createCheckMenuListener(ICheckMenuLabel checkMenuLabel) {
        return new CheckMenuListener(checkMenuLabel);
    }

    public static DescriptorIndicationListener createDescriptorIndicationListener(String string, IDescriptionIndicator[] descriptionIndicators) {
        return new DescriptorIndicationAdapter(string, descriptionIndicators);
    }

    private static class CheckMenuListener
    implements SelectionListener {
        private ICheckMenuLabel checkMenuLabel;

        public CheckMenuListener(ICheckMenuLabel checkMenuLabel) {
            this.setCheckMenuLabel(checkMenuLabel);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent evt) {
            this.getCheckMenuLabel().toggleChecked();
            ICheckAction checkAction = this.getCheckMenuLabel().getCheckAction();
            if (checkAction != null) {
                if (this.getCheckMenuLabel().isChecked()) {
                    checkAction.checked();
                } else {
                    checkAction.unchecked();
                }
            }
        }

        public ICheckMenuLabel getCheckMenuLabel() {
            return this.checkMenuLabel;
        }

        public void setCheckMenuLabel(ICheckMenuLabel checkMenuLabel) {
            this.checkMenuLabel = checkMenuLabel;
        }
    }

    private static class RadioMenuListener
    implements SelectionListener {
        private IRadioMenu radioMenu;
        private int indexInMenu;

        public RadioMenuListener(IRadioMenu radioMenu, int index) {
            this.setRadioMenu(radioMenu);
            this.setIndexInMenu(index);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent evt) {
            MenuItem selectedItem = (MenuItem)evt.getSource();
            selectedItem.setSelection(true);
            int index = this.getIndexInMenu();
            this.getRadioMenu().setIndexOfSelectedMenuCoponent(index);
            IRadioAction radioAction = this.getRadioMenu().getRadioAction();
            if (radioAction != null) {
                radioAction.radioChanged(index);
            }
        }

        public IRadioMenu getRadioMenu() {
            return this.radioMenu;
        }

        public void setRadioMenu(IRadioMenu radioMenu) {
            this.radioMenu = radioMenu;
        }

        public int getIndexInMenu() {
            return this.indexInMenu;
        }

        public void setIndexInMenu(int indexInMenu) {
            this.indexInMenu = indexInMenu;
        }
    }

    private static class ProcessAdapter
    implements SelectionListener {
        IContext context;
        IAction action;

        public ProcessAdapter(IAction action, IContext context) {
            this.setAction(action);
            this.setContext(context);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.getAction().process(this.getContext());
        }

        public IAction getAction() {
            return this.action;
        }

        private void setAction(IAction action) {
            this.action = action;
        }

        public IContext getContext() {
            return this.context;
        }

        private void setContext(IContext context) {
            this.context = context;
        }
    }

    private static class DescriptorIndicationAdapter
    implements DescriptorIndicationListener {
        private String description;
        private IDescriptionIndicator[] descriptionIndicators;

        public DescriptorIndicationAdapter(String description, IDescriptionIndicator[] descriptionIndicators) {
            this.setDescription(description);
            this.setDescriptionIndicators(descriptionIndicators);
        }

        public void widgetArmed(ArmEvent e) {
            this.indicateDescription();
        }

        public void menuShown(MenuEvent e) {
            this.indicateDescription();
        }

        public void menuHidden(MenuEvent e) {
            this.indicate("");
        }

        private void indicateDescription() {
            String description = this.getDescription();
            if (description == null) {
                description = "";
            }
            this.indicate(description);
        }

        private void indicate(String description) {
            int i = 0;
            while (i < this.getDescriptionIndicators().length) {
                IDescriptionIndicator indicator = this.getDescriptionIndicators()[i];
                indicator.indicateDescription(description);
                ++i;
            }
        }

        public String getDescription() {
            return this.description;
        }

        private void setDescription(String description) {
            this.description = description;
        }

        private void setDescriptionIndicators(IDescriptionIndicator[] descriptionIndicators) {
            this.descriptionIndicators = descriptionIndicators;
        }

        private IDescriptionIndicator[] getDescriptionIndicators() {
            return this.descriptionIndicators;
        }
    }
}

