/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.menu.internal;

import com.tssap.util.ui.IContext;
import com.tssap.util.ui.IDescriptionIndicator;
import com.tssap.util.ui.menu.IAbstractMenu;
import com.tssap.util.ui.menu.ICheckMenuLabel;
import com.tssap.util.ui.menu.IMenu;
import com.tssap.util.ui.menu.IMenuComponent;
import com.tssap.util.ui.menu.IMenuItem;
import com.tssap.util.ui.menu.IMenuLabel;
import com.tssap.util.ui.menu.IMenuSeparator;
import com.tssap.util.ui.menu.IRadioMenu;
import com.tssap.util.ui.menu.IRadioMenuLabel;
import com.tssap.util.ui.menu.ISubMenuLabel;
import com.tssap.util.ui.menu.internal.DescriptorIndicationListener;
import com.tssap.util.ui.menu.internal.MenuListenerFactory;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class MenuEngine {
    public static void show(IAbstractMenu menu, Control parent, IContext context) {
        Menu swtMenu = new Menu(parent);
        MenuEngine.construct(swtMenu, menu, context);
        swtMenu.setVisible(true);
    }

    public static void show(IAbstractMenu menu, Control parent, IContext context, IDescriptionIndicator[] indicators) {
        Menu swtMenu = new Menu(parent);
        MenuEngine.construct(swtMenu, menu, context, indicators);
        swtMenu.setVisible(true);
    }

    private static void constructMenu(Menu swtMenu, IMenu fwMenu, IContext context) {
        MenuEngine.constructMenu(swtMenu, fwMenu, context, null);
    }

    private static void constructMenu(Menu swtMenu, IMenu fwMenu, IContext context, IDescriptionIndicator[] indicators) {
        IMenuComponent[] components = fwMenu.getMenuComponents();
        int i = 0;
        while (i < components.length) {
            IMenuComponent iMenuComponent = components[i];
            if (iMenuComponent instanceof IMenuItem) {
                IMenuItem menuItem = (IMenuItem)iMenuComponent;
                if (menuItem.isVisible(context)) {
                    if (i > 0 && fwMenu.isMenuComponentsSeparated() && !(components[i - 1] instanceof IMenuSeparator) && i < components.length - 1) {
                        MenuEngine.addMenuSeparator(swtMenu);
                    }
                    if (iMenuComponent instanceof IMenu) {
                        IMenu menuPart = (IMenu)iMenuComponent;
                        MenuEngine.construct(swtMenu, menuPart, context, indicators);
                        if (i < components.length - 1) {
                            MenuEngine.addMenuSeparator(swtMenu);
                        }
                    } else if (iMenuComponent instanceof IRadioMenu) {
                        IRadioMenu radioMenuPart = (IRadioMenu)iMenuComponent;
                        MenuEngine.construct(swtMenu, radioMenuPart, context);
                    } else if (iMenuComponent instanceof IMenuLabel) {
                        MenuItem swtMenuItem;
                        IMenuLabel menuLabel = (IMenuLabel)iMenuComponent;
                        if (menuLabel instanceof ISubMenuLabel) {
                            ISubMenuLabel subMenuLabel = (ISubMenuLabel)menuLabel;
                            IAbstractMenu subMenu = subMenuLabel.getSubMenu();
                            swtMenuItem = new MenuItem(swtMenu, 64);
                            Menu swtSubMenu = new Menu(swtMenuItem);
                            MenuEngine.registerDescriptorIndicators((Widget)swtSubMenu, subMenuLabel, indicators);
                            swtMenuItem.setMenu(swtSubMenu);
                            MenuEngine.construct(swtSubMenu, subMenu, context, indicators);
                        } else if (menuLabel instanceof ICheckMenuLabel) {
                            ICheckMenuLabel checkMenuLabel = (ICheckMenuLabel)menuLabel;
                            swtMenuItem = new MenuItem(swtMenu, 32);
                            swtMenuItem.setSelection(checkMenuLabel.isChecked());
                            swtMenuItem.addSelectionListener(MenuListenerFactory.createCheckMenuListener(checkMenuLabel));
                        } else {
                            swtMenuItem = new MenuItem(swtMenu, 8);
                        }
                        MenuEngine.decorateMenuItem(swtMenuItem, menuLabel, context, indicators);
                    }
                }
            } else if (iMenuComponent instanceof IMenuSeparator && i < components.length - 1) {
                MenuEngine.addMenuSeparator(swtMenu);
            }
            ++i;
        }
    }

    private static void construct(Menu swtMenu, IAbstractMenu fwMenu, IContext context) {
        if (fwMenu instanceof IMenu) {
            MenuEngine.constructMenu(swtMenu, (IMenu)fwMenu, context);
        } else if (fwMenu instanceof IRadioMenu) {
            MenuEngine.constructRadioMenu(swtMenu, (IRadioMenu)fwMenu, context);
        }
    }

    private static void construct(Menu swtMenu, IAbstractMenu fwMenu, IContext context, IDescriptionIndicator[] indicators) {
        if (fwMenu instanceof IMenu) {
            MenuEngine.constructMenu(swtMenu, (IMenu)fwMenu, context, indicators);
        } else if (fwMenu instanceof IRadioMenu) {
            MenuEngine.constructRadioMenu(swtMenu, (IRadioMenu)fwMenu, context);
        }
    }

    private static void constructRadioMenu(Menu swtMenu, IRadioMenu fwMenu, IContext context) {
        IRadioMenuLabel[] components = fwMenu.getMenuComponents();
        int indexOfSelectedComponent = fwMenu.getIndexOfSelectedMenuCoponent();
        if (components != null) {
            int index = 0;
            while (index < components.length) {
                IRadioMenuLabel iRadioMenuLabel = components[index];
                MenuItem swtMenuItem = new MenuItem(swtMenu, 16);
                MenuEngine.decorateMenuItem(swtMenuItem, iRadioMenuLabel, context);
                swtMenuItem.addSelectionListener(MenuListenerFactory.createRadioListener(fwMenu, index));
                if (index == indexOfSelectedComponent) {
                    swtMenuItem.setSelection(true);
                }
                ++index;
            }
        }
    }

    private static void addMenuSeparator(Menu swtMenu) {
        MenuItem lastItem = swtMenu.getItem(swtMenu.getItemCount() - 1);
        if (2 != lastItem.getStyle()) {
            new MenuItem(swtMenu, 2);
        }
    }

    private static void decorateMenuItem(MenuItem swtMenuItem, IMenuLabel menuLabel, IContext context, IDescriptionIndicator[] descriptorIndicators) {
        swtMenuItem.setText(menuLabel.getText());
        swtMenuItem.setImage(menuLabel.getImage());
        swtMenuItem.setEnabled(menuLabel.isEnabled(context));
        if (menuLabel.getAction() != null) {
            MenuEngine.registerSelectionListener(swtMenuItem, menuLabel, context);
            MenuEngine.registerDescriptorIndicators((Widget)swtMenuItem, menuLabel, descriptorIndicators);
        }
    }

    private static void registerSelectionListener(MenuItem swtMenuItem, IMenuLabel menuLabel, IContext context) {
        SelectionListener selectionListener = MenuListenerFactory.createStandardListener(menuLabel.getAction(), context);
        swtMenuItem.addSelectionListener(selectionListener);
    }

    private static void registerDescriptorIndicators(Widget swtWidget, IMenuLabel menuLabel, IDescriptionIndicator[] descriptorIndicators) {
        if (descriptorIndicators != null) {
            DescriptorIndicationListener descriptorIndicationListener = MenuListenerFactory.createDescriptorIndicationListener(menuLabel.getDescription(), descriptorIndicators);
            if (swtWidget instanceof Menu) {
                ((Menu)swtWidget).addMenuListener((MenuListener)descriptorIndicationListener);
            }
            if (swtWidget instanceof MenuItem) {
                ((MenuItem)swtWidget).addArmListener((ArmListener)descriptorIndicationListener);
            }
        }
    }

    private static void decorateMenuItem(MenuItem swtMenuItem, IMenuLabel menuLabel, IContext context) {
        MenuEngine.decorateMenuItem(swtMenuItem, menuLabel, context, null);
    }
}

