/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.menu.context;

import com.tssap.util.ui.IContext;
import com.tssap.util.ui.menu.IMenu;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.ContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import com.tssap.util.ui.menu.context.IContextMenuPart;
import com.tssap.util.ui.menu.context.IContextMenuPartContainer;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class MixedContextMenu
extends ContextMenu
implements IContextMenuPartContainer {
    private Vector menuPartsVector;

    public IMenu getMenu(IContext context) {
        IMenu ret = MenuFactory.createMenu();
        Iterator iter = ((AbstractList)this.getMenuPartsVector()).iterator();
        while (iter.hasNext()) {
            IContextMenuPart part = (IContextMenuPart)iter.next();
            ret.addExistingMenuPart(part.getMenu(context));
        }
        return ret;
    }

    protected Vector getMenuPartsVector() {
        if (this.menuPartsVector == null) {
            this.menuPartsVector = new Vector();
        }
        return this.menuPartsVector;
    }

    public void addContextMenuPart(IContextMenuPart contextMenuPart) {
        this.getMenuPartsVector().addElement(contextMenuPart);
    }

    public IContextMenuPart[] getContextMenuParts() {
        IContextMenuPart[] ret = new IContextMenuPart[]{};
        if (this.getMenuPartsVector() != null && this.getMenuPartsVector().size() > 0) {
            ret = this.getMenuPartsVector().toArray(ret);
        }
        return ret;
    }

    public void performDefault(IContext context) {
        super.performDefault(context);
        IContextMenu[] menus = this.getAllContextMenus();
        int i = 0;
        while (i < menus.length) {
            IContextMenu iContextMenu = menus[i];
            iContextMenu.performDefault(context);
            ++i;
        }
    }

    public IContextMenu[] getAllContextMenus() {
        Vector<IContextMenu> retVector = new Vector<IContextMenu>();
        IContextMenu[] ret = new IContextMenu[]{};
        IContextMenuPart[] parts = this.getContextMenuParts();
        int i = 0;
        while (i < parts.length) {
            IContextMenuPart iContextMenuPart = parts[i];
            if (iContextMenuPart instanceof IContextMenuPartContainer) {
                IContextMenuPartContainer container = (IContextMenuPartContainer)iContextMenuPart;
                IContextMenu[] menus = container.getAllContextMenus();
                int j = 0;
                while (j < menus.length) {
                    IContextMenu iContextMenu = menus[j];
                    retVector.add(iContextMenu);
                    ++j;
                }
            } else if (iContextMenuPart instanceof IContextMenu) {
                IContextMenu iContextMenu = (IContextMenu)((Object)iContextMenuPart);
                retVector.add(iContextMenu);
            }
            if (retVector.size() > 0) {
                ret = retVector.toArray(ret);
            }
            ++i;
        }
        return ret;
    }
}

