/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.menu.context;

import com.tssap.util.action.Category;
import com.tssap.util.action.DefaultActionFilter;
import com.tssap.util.action.IActionFilter;
import com.tssap.util.action.ICategory;
import com.tssap.util.action.eclipse.CopyAction;
import com.tssap.util.action.eclipse.CutAction;
import com.tssap.util.action.eclipse.OpenAction;
import com.tssap.util.action.eclipse.PasteAction;
import com.tssap.util.action.eclipse.PropertiesAction;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.IContextProvider;
import com.tssap.util.ui.menu.IMenu;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.ContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import java.util.Hashtable;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class DynamicContextMenu
extends ContextMenu {
    private static Hashtable keyListenerHash = new Hashtable();
    private IActionFilter actionFilter = null;
    private IMenuFactory menuFactory;
    private ICategory defaultCategory = Category.OPEN;
    private int minimumSubmenuEntryCount = -1;

    public DynamicContextMenu(IMenuFactory menuFactory, int minimumSubmenuEntryCount, IActionFilter actionFilter) {
        this(menuFactory, minimumSubmenuEntryCount);
        this.setActionFilter(actionFilter);
    }

    public DynamicContextMenu(IMenuFactory menuFactory, IActionFilter actionFilter) {
        this(menuFactory);
        this.setActionFilter(actionFilter);
    }

    public DynamicContextMenu(IMenuFactory menuFactory, int minimumSubmenuEntryCount) {
        this(menuFactory);
        this.setMinimumSubmenuEntryCount(minimumSubmenuEntryCount);
    }

    public DynamicContextMenu(IMenuFactory menuFactory) {
        this.setMenuFactory(menuFactory);
    }

    public IMenu getMenu(IContext context) {
        IMenu menu = this.getMenuFactory().createContextMenu(context, this.getMinimumSubmenuEntryCount(), this.getActionFilter());
        return menu;
    }

    public IMenuFactory getMenuFactory() {
        return this.menuFactory;
    }

    public void setMenuFactory(IMenuFactory menuFactory) {
        this.menuFactory = menuFactory;
    }

    public void performDefault(IContext context) {
        MenuFactory.performActionsForContext(this.getDefaultCategory(), context, this.getActionFilter());
    }

    public ICategory getDefaultCategory() {
        return this.defaultCategory;
    }

    public void setDefaultCategory(ICategory defaultCategory) {
        this.defaultCategory = defaultCategory;
    }

    public int getMinimumSubmenuEntryCount() {
        return this.minimumSubmenuEntryCount;
    }

    public void setMinimumSubmenuEntryCount(int minimumSubmenuEntryCount) {
        this.minimumSubmenuEntryCount = minimumSubmenuEntryCount;
    }

    public IActionFilter getActionFilter() {
        if (this.actionFilter == null) {
            this.actionFilter = new DefaultActionFilter();
        }
        return this.actionFilter;
    }

    public void setActionFilter(IActionFilter actionFilter) {
        this.actionFilter = actionFilter;
    }

    public void registerShortcuts(Control control, IWorkbenchPart workbenchPart, IContextProvider contextProvider) {
        Object keyListener;
        IActionBars actionBars = null;
        if (workbenchPart instanceof IViewPart) {
            actionBars = ((IViewPart)workbenchPart).getViewSite().getActionBars();
        }
        if (actionBars != null) {
            actionBars.setGlobalActionHandler("open.ext", (IAction)new OpenAction(this, contextProvider));
            actionBars.setGlobalActionHandler("cut", (IAction)new CutAction(this, contextProvider));
            actionBars.setGlobalActionHandler("copy", (IAction)new CopyAction(this, contextProvider));
            actionBars.setGlobalActionHandler("paste", (IAction)new PasteAction(this, contextProvider));
            actionBars.setGlobalActionHandler("properties", (IAction)new PropertiesAction(this, contextProvider));
        }
        if ((keyListener = (KeyListener)keyListenerHash.get(control)) != null) {
            control.removeKeyListener(keyListener);
        }
        keyListener = new CMKeyListener(this, contextProvider);
        control.addKeyListener(keyListener);
        keyListenerHash.put(workbenchPart, keyListener);
    }

    private class CMKeyListener
    extends KeyAdapter {
        private IContextProvider contextProvider;
        private IContextMenu contextMenu;

        public CMKeyListener(IContextMenu contextMenu, IContextProvider contextProvider) {
            this.setContextProvider(contextProvider);
            this.setContextMenu(contextMenu);
        }

        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
            if (e.character == '\u007f') {
                MenuFactory.performActionsForContext(Category.DELETE, this.getContext(), DynamicContextMenu.this.getActionFilter());
            }
        }

        private IContextProvider getContextProvider() {
            return this.contextProvider;
        }

        private IContext getContext() {
            IContext ret = null;
            if (this.getContextProvider() != null) {
                ret = this.getContextProvider().getContext();
            }
            return ret;
        }

        private void setContextProvider(IContextProvider contextProvider) {
            this.contextProvider = contextProvider;
        }

        private IContextMenu getContextMenu() {
            return this.contextMenu;
        }

        private void setContextMenu(IContextMenu contextMenu) {
            this.contextMenu = contextMenu;
        }
    }
}

