/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.menu.context;

import com.tssap.util.action.StructuredViewerSelectionContext;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.IContextProvider;
import com.tssap.util.ui.IDescriptionIndicator;
import com.tssap.util.ui.menu.IMenu;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import com.tssap.util.ui.menu.context.IContextMenuPart;
import com.tssap.util.ui.menu.internal.MenuEngine;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Control;

public abstract class ContextMenu
implements IContextMenu,
IContextMenuPart {
    private Vector descriptionIndicatorVector;
    private static Hashtable mouseListenerHash = new Hashtable();
    private static Hashtable keyListenerHash = new Hashtable();

    public void show(Control parent, IContext context) {
        IMenu menu = this.getMenu(context);
        MenuEngine.show(menu, parent, context, this.getDescriptionIndicators());
    }

    public IMenu getMenu(IContext context) {
        return MenuFactory.createMenu();
    }

    public static void setDefaultDynamicContextMenuToStructuredViewer(StructuredViewer viewer) {
        DynamicContextMenu contextMenu = new DynamicContextMenu(new MenuFactory());
        ContextMenu.setContextMenuToStructuredViewer(viewer, contextMenu);
    }

    public static void setContextMenuToControl(Control control, IContextMenu contextMenu, IContextProvider contextProvider) {
        MouseListener listener = (MouseListener)((Object)mouseListenerHash.get(control));
        if (listener != null) {
            control.removeMouseListener((org.eclipse.swt.events.MouseListener)listener);
        }
        listener = new MouseListener(control, contextMenu, contextProvider);
        control.addMouseListener((org.eclipse.swt.events.MouseListener)listener);
        mouseListenerHash.put(control, listener);
        Object keyListener = (KeyListener)keyListenerHash.get(control);
        if (keyListener != null) {
            control.removeKeyListener(keyListener);
        }
        keyListener = new CMKeyListener(control, contextMenu, contextProvider);
        control.addKeyListener(keyListener);
        keyListenerHash.put(control, keyListener);
    }

    public static void setContextMenuToStructuredViewer(StructuredViewer viewer, IContextMenu contextMenu) {
        ContextMenu.setContextMenuToControl(viewer.getControl(), contextMenu, new StructuredViewerSelectionContext(viewer));
        viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener(contextMenu, new StructuredViewerSelectionContext(viewer)));
    }

    public void performDefault(IContext context) {
    }

    private Vector getDescriptionIndicatorVector() {
        if (this.descriptionIndicatorVector == null) {
            this.descriptionIndicatorVector = new Vector();
        }
        return this.descriptionIndicatorVector;
    }

    private void setDescriptionIndicatorVector(Vector descriptionIndicatorVector) {
        this.descriptionIndicatorVector = descriptionIndicatorVector;
    }

    private IDescriptionIndicator[] getDescriptionIndicators() {
        IDescriptionIndicator[] ret = null;
        Vector vec = this.getDescriptionIndicatorVector();
        if (!vec.isEmpty()) {
            ret = new IDescriptionIndicator[]{};
            ret = vec.toArray(ret);
        }
        return ret;
    }

    public boolean addDescriptionIndicator(IDescriptionIndicator descriptionIndicator) {
        return this.getDescriptionIndicatorVector().add(descriptionIndicator);
    }

    public boolean removeDescriptionIndicator(IDescriptionIndicator descriptionIndicator) {
        return this.getDescriptionIndicatorVector().remove(descriptionIndicator);
    }

    private static class CMKeyListener
    extends KeyAdapter {
        private IContextProvider contextProvider;
        private Control control;
        private IContextMenu contextMenu;

        public CMKeyListener(Control control, IContextMenu contextMenu, IContextProvider contextProvider) {
            this.setControl(control);
            this.setContextProvider(contextProvider);
            this.setContextMenu(contextMenu);
        }

        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
            int currentKeyCode = e.keyCode;
            int currentStateMask = e.stateMask;
            if (currentKeyCode == 0x1000013 && currentStateMask == 131072) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(this){
                    private final /* synthetic */ CMKeyListener this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        CMKeyListener.access$300(this.this$0).show(CMKeyListener.access$100(this.this$0), CMKeyListener.access$200(this.this$0).getContext());
                    }
                });
            }
        }

        private IContextProvider getContextProvider() {
            return this.contextProvider;
        }

        private void setContextProvider(IContextProvider contextProvider) {
            this.contextProvider = contextProvider;
        }

        private Control getControl() {
            return this.control;
        }

        private void setControl(Control control) {
            this.control = control;
        }

        private IContextMenu getContextMenu() {
            return this.contextMenu;
        }

        private void setContextMenu(IContextMenu contextMenu) {
            this.contextMenu = contextMenu;
        }

        static /* synthetic */ Control access$100(CMKeyListener x0) {
            return x0.getControl();
        }

        static /* synthetic */ IContextProvider access$200(CMKeyListener x0) {
            return x0.getContextProvider();
        }

        static /* synthetic */ IContextMenu access$300(CMKeyListener x0) {
            return x0.getContextMenu();
        }
    }

    private static class MouseListener
    extends MouseAdapter {
        private IContextProvider contextProvider;
        private Control control;
        private IContextMenu contextMenu;

        public MouseListener(Control control, IContextMenu contextMenu, IContextProvider contextProvider) {
            this.setControl(control);
            this.setContextProvider(contextProvider);
            this.setContextMenu(contextMenu);
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 3) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(this){
                    private final /* synthetic */ MouseListener this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        MouseListener.access$000(this.this$0);
                    }
                });
            }
        }

        private void mouseDownInternal() {
            this.getContextMenu().show(this.getControl(), this.getContextProvider().getContext());
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        private IContextProvider getContextProvider() {
            return this.contextProvider;
        }

        private void setContextProvider(IContextProvider contextProvider) {
            this.contextProvider = contextProvider;
        }

        private Control getControl() {
            return this.control;
        }

        private void setControl(Control control) {
            this.control = control;
        }

        private IContextMenu getContextMenu() {
            return this.contextMenu;
        }

        private void setContextMenu(IContextMenu contextMenu) {
            this.contextMenu = contextMenu;
        }

        static /* synthetic */ void access$000(MouseListener x0) {
            x0.mouseDownInternal();
        }
    }

    private static class DoubleClickListener
    implements IDoubleClickListener {
        private IContext context;
        private IContextMenu contextMenu;

        public DoubleClickListener(IContextMenu contextMenu, IContext context) {
            this.setContext(context);
            this.setContextMenu(contextMenu);
        }

        public void doubleClick(DoubleClickEvent event) {
            this.getContextMenu().performDefault(this.getContext());
        }

        private IContext getContext() {
            return this.context;
        }

        private void setContext(IContext context) {
            this.context = context;
        }

        private IContextMenu getContextMenu() {
            return this.contextMenu;
        }

        private void setContextMenu(IContextMenu contextMenu) {
            this.contextMenu = contextMenu;
        }
    }
}

