/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.menu;

import com.tssap.util.action.ActionContext;
import com.tssap.util.action.ActionProviderManager;
import com.tssap.util.action.Category;
import com.tssap.util.action.DefaultActionFilter;
import com.tssap.util.action.IActionContext;
import com.tssap.util.action.IActionFilter;
import com.tssap.util.action.IActionProviderManager;
import com.tssap.util.action.ICategory;
import com.tssap.util.action.IGenericAction;
import com.tssap.util.action.IGenericActionContainer;
import com.tssap.util.action.path.IPath;
import com.tssap.util.action.path.IPathElement;
import com.tssap.util.action.path.IPathProviderManager;
import com.tssap.util.action.path.PathProviderManager;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.IAction;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.IDisplayable;
import com.tssap.util.ui.action.IDisplayableCategory;
import com.tssap.util.ui.action.IDisplayableCategoryComparator;
import com.tssap.util.ui.action.IExtendedDisplayableCategory;
import com.tssap.util.ui.action.path.IDisplayablePathElement;
import com.tssap.util.ui.menu.IAbstractMenu;
import com.tssap.util.ui.menu.ICheckMenuLabel;
import com.tssap.util.ui.menu.IMenu;
import com.tssap.util.ui.menu.IMenuComponent;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.IMenuLabel;
import com.tssap.util.ui.menu.IMenuLabelProvider;
import com.tssap.util.ui.menu.IMenuStatus;
import com.tssap.util.ui.menu.IRadioMenu;
import com.tssap.util.ui.menu.IRadioMenuLabel;
import com.tssap.util.ui.menu.ISubMenuLabel;
import com.tssap.util.ui.menu.MenuLabelProvider;
import com.tssap.util.ui.menu.internal.stat.Menu;
import com.tssap.util.ui.menu.internal.stat.RadioMenu;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class MenuFactory
implements IMenuFactory {
    private static final TracerI T = TracingManager.getTracer(class$com$tssap$util$ui$menu$MenuFactory == null ? (class$com$tssap$util$ui$menu$MenuFactory = MenuFactory.class$("com.tssap.util.ui.menu.MenuFactory")) : class$com$tssap$util$ui$menu$MenuFactory);
    public static final int DEFAULT_MINIMUM_SUBMENU_ENTRY_COUNT = 2;
    private static final boolean DISPLAYABLE_PATH_ELEMENTS_ONLY = true;
    private static final boolean USE_DISPLAYABLE_DATA = true;
    private static final Comparator DEFAULT_ECLIPSE_MENU_ENTRY_SORTER = new MenuEntrySorter();
    private static final ICategory[] ECLIPSE_CATEGORIES = new ICategory[]{Category.NEW, Category.OPEN, Category.NAVIGATE, Category.EDIT, Category.CUT, Category.COPY, Category.PASTE, Category.DELETE, Category.OTHERS, Category.PROPERTIES};
    private IPathProviderManager pathProviderManager;
    static /* synthetic */ Class class$com$tssap$util$ui$menu$MenuFactory;

    public static IMenu createMenu() {
        Menu newMenu = new Menu();
        return newMenu;
    }

    public static IMenu createMenu(IMenuStatus menuStatus) {
        Menu newMenu = new Menu(menuStatus);
        return newMenu;
    }

    public static IRadioMenu createRadioMenu() {
        RadioMenu newRadioMenu = new RadioMenu();
        return newRadioMenu;
    }

    public static IRadioMenu createRadioMenu(IMenuStatus menuStatus) {
        RadioMenu newRadioMenu = new RadioMenu(menuStatus);
        return newRadioMenu;
    }

    public IMenu createContextMenu(IContext context) {
        IMenu ret = this.createContextMenu(context, 2);
        return ret;
    }

    public IMenu createContextMenu(IContext context, int minSubmenuEntries) {
        return this.createContextMenu(context, minSubmenuEntries, null);
    }

    public IMenu createContextMenu(IContext context, int minSubmenuEntries, IActionFilter actionFilter) {
        return this.createContextMenu(context, minSubmenuEntries, actionFilter, null);
    }

    public IMenu createContextMenu(IContext context, int minSubmenuEntries, IActionFilter actionFilter, IDisplayableCategoryComparator comparatorCallback) {
        if (actionFilter == null) {
            actionFilter = new DefaultActionFilter();
        }
        IMenu ret = MenuFactory.createMenu();
        Object[] objs = context.getContextObjects();
        if (objs.length > 0) {
            MuSiAction[] actions = MenuFactory.getAvailibleActions(context.getContextObjects(), actionFilter);
            ActionContext actionContext = new ActionContext(objs[0], objs);
            Vector notASubmenuList = new Vector();
            ret = this.handleActions(ret, context, actionContext, actions, minSubmenuEntries, notASubmenuList, comparatorCallback);
            ret = MenuFactory.transformSubMenuesToMenuParts(ret, minSubmenuEntries, notASubmenuList);
        }
        return ret;
    }

    protected static MuSiAction[] removeActionsWithDuplicatedCategories(MuSiAction[] actions) {
        MuSiAction[] ret = new MuSiAction[]{};
        int actionCountBefore = actions.length;
        HashMap<ICategory, MuSiAction> hashMap = new HashMap<ICategory, MuSiAction>();
        int i = 0;
        while (i < actionCountBefore) {
            MuSiAction oldOne = hashMap.put(actions[i].getCategory(), actions[i]);
            if (oldOne != null && T.info()) {
                T.info("removeActionsWithDuplicatedCategories(MuSiAction[] actions)", "Action with category " + oldOne.getCategory() + " removed");
            }
            ++i;
        }
        ret = hashMap.values().toArray(new MuSiAction[0]);
        int actionCountAfter = actions.length;
        if (actionCountBefore != actionCountAfter && T.info()) {
            T.info("removeActionsWithDuplicatedCategories(MuSiAction[] actions)", actionCountBefore - actionCountAfter + " actions removed");
        }
        return ret;
    }

    private IMenu handleActions(IMenu menu, IContext context, IActionContext actionContext, MuSiAction[] musiActions, Vector notASubmenuList, IDisplayableCategoryComparator comparatorCallback) {
        IMenu ret = this.handleActions(menu, context, actionContext, musiActions, 2, notASubmenuList, comparatorCallback);
        return ret;
    }

    private IMenu handleActions(IMenu menu, IContext context, IActionContext actionContext, MuSiAction[] musiActions, int minSubmenuEntries, Vector notASubmenuList, IDisplayableCategoryComparator comparatorCallback) {
        Comparator sorter = DEFAULT_ECLIPSE_MENU_ENTRY_SORTER;
        if (comparatorCallback != null) {
            sorter = new MenuEntrySorter(comparatorCallback);
        }
        Arrays.sort(musiActions, sorter);
        int j = 0;
        while (j < musiActions.length) {
            MuSiAction iMusiAction;
            MuSiAction iGenericAction = iMusiAction = musiActions[j];
            IPath iPath = this.calculatePath(context, actionContext, iMusiAction);
            if (iPath != null) {
                String[] iMenuPath = iPath.getPathTexts();
                IPathElement leafPathElement = iPath.getLeafElement();
                if (leafPathElement instanceof IDisplayable) {
                    IMenu iMenu = menu;
                    boolean multiAction = iMusiAction.isMultiAction();
                    int k = 1;
                    while (k < iMenuPath.length - 1) {
                        String name = iMenuPath[k];
                        IPathElement iPathElement = iPath.getPathElement(k);
                        boolean isSubMenu = iPathElement.isSubElement();
                        IMenu subMenu = this.checkIfSubMenuAlreadyContained(iMenu, name);
                        if (subMenu != null) {
                            iMenu = subMenu;
                        } else {
                            if (iPathElement instanceof IDisplayablePathElement) {
                                IDisplayablePathElement iDisplayablePathElement = (IDisplayablePathElement)iPathElement;
                                DisplayMenuLabelProvider menuLabelProvider = new DisplayMenuLabelProvider(iDisplayablePathElement);
                                iMenu = iMenu.addSubMenu(menuLabelProvider);
                            } else {
                                iMenu = iMenu.addSubMenu(name);
                            }
                            iMenu.setMenuComponentsSeparated(false);
                            if (!isSubMenu) {
                                notASubmenuList.add(iMenu);
                            }
                        }
                        ++k;
                    }
                    IMenuLabel label = this.checkIfMenuLabelAlreadyContained(iMenu, iMenuPath[iMenuPath.length - 1]);
                    Object actionContextObject = actionContext.getActionObject();
                    if (label == null) {
                        String name = iMenuPath[iMenuPath.length - 1];
                        IPathElement iPathElement = iPath.getLeafElement();
                        DelegateAction action = new DelegateAction(iGenericAction, actionContextObject, multiAction);
                        if (iPathElement instanceof IDisplayablePathElement) {
                            IDisplayablePathElement iDisplayablePathElement = (IDisplayablePathElement)iPathElement;
                            DisplayMenuLabelProvider menuLabelProvider = new DisplayMenuLabelProvider(iDisplayablePathElement);
                            iMenu.addMenuAction(menuLabelProvider, (IMenuStatus)action, (IAction)action);
                        } else {
                            iMenu.addMenuAction(name, (IMenuStatus)action, (IAction)action);
                        }
                    } else {
                        IMenuStatus status = label.getMenuStatus();
                        if (!multiAction && status instanceof DelegateAction) {
                            int replaceIndex;
                            ContextedAction formerContextAction;
                            int i;
                            ContextedAction[] contextedActions;
                            Vector vec;
                            DelegateAction delegate = (DelegateAction)status;
                            boolean newlyFoundActionIsEnabled = iGenericAction.isEnabled(actionContext);
                            if (newlyFoundActionIsEnabled) {
                                vec = delegate.getContextedDestinationActionVector();
                                contextedActions = new ContextedAction[]{};
                                contextedActions = vec.toArray(contextedActions);
                                i = 0;
                                while (i < contextedActions.length) {
                                    formerContextAction = contextedActions[i];
                                    if (formerContextAction.getContext().equals(actionContextObject)) {
                                        boolean formerlyFoundActionIsEnabled = formerContextAction.getAction().isEnabled(actionContext);
                                        if (!formerlyFoundActionIsEnabled || this.checkIfFallbackAction(formerContextAction) && !this.checkIfFallbackAction(iGenericAction)) {
                                            replaceIndex = vec.indexOf(formerContextAction);
                                            vec.remove(formerContextAction);
                                            vec.add(replaceIndex, new ContextedAction(iGenericAction, actionContextObject));
                                        } else if (T.info()) {
                                            T.info("handleActions", "Double defined action");
                                        }
                                    } else if (!delegate.isOnlyOneDestination()) {
                                        ContextedAction contextedAction = new ContextedAction(iGenericAction, actionContextObject);
                                        delegate.addContextedDestinationAction(contextedAction);
                                    }
                                    ++i;
                                }
                            } else {
                                vec = delegate.getContextedDestinationActionVector();
                                contextedActions = new ContextedAction[]{};
                                contextedActions = vec.toArray(contextedActions);
                                i = 0;
                                while (i < contextedActions.length) {
                                    formerContextAction = contextedActions[i];
                                    if (!formerContextAction.getContext().equals(actionContextObject)) {
                                        boolean formerlyFoundActionIsEnabled = formerContextAction.getAction().isEnabled(actionContext);
                                        if (formerlyFoundActionIsEnabled) {
                                            replaceIndex = vec.indexOf(formerContextAction);
                                            vec.remove(formerContextAction);
                                            vec.add(replaceIndex, new ContextedAction(iGenericAction, actionContextObject));
                                        }
                                    } else if (!delegate.isOnlyOneDestination()) {
                                        ContextedAction contextedAction = new ContextedAction(iGenericAction, actionContextObject);
                                        delegate.addContextedDestinationAction(contextedAction);
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                }
            }
            ++j;
        }
        return menu;
    }

    private boolean checkIfFallbackAction(IGenericAction genericAction) {
        boolean ret = ActionProviderManager.checkIfFallbackAction(genericAction);
        return ret;
    }

    private boolean checkIfFallbackAction(ContextedAction contextAction) {
        boolean ret = this.checkIfFallbackAction(contextAction.getAction());
        return ret;
    }

    private static IMenu transformSubMenuesToMenuParts(IMenu menu, int minimumSubMenuEntries, Collection notASubmenuList) {
        IMenu ret = MenuFactory.createMenu();
        boolean menuComponentsSeparated = menu.isMenuComponentsSeparated();
        ret.setMenuComponentsSeparated(menuComponentsSeparated);
        IMenuComponent[] comps = menu.getMenuComponents();
        int i = 0;
        while (i < comps.length) {
            IMenuComponent iMenuComponent = comps[i];
            if (iMenuComponent instanceof ISubMenuLabel) {
                int j;
                int compCount;
                ISubMenuLabel subMenuLabel = (ISubMenuLabel)iMenuComponent;
                IAbstractMenu absMenu = subMenuLabel.getSubMenu();
                if (absMenu instanceof IRadioMenu) {
                    IRadioMenu radioMenu = (IRadioMenu)absMenu;
                    IRadioMenuLabel[] radioMenuLabels = radioMenu.getMenuComponents();
                    compCount = radioMenuLabels.length;
                    if (compCount < minimumSubMenuEntries || notASubmenuList.contains(iMenuComponent)) {
                        IRadioMenu workRadioMenu = ret.addRadioMenuPart();
                        j = 0;
                        while (j < radioMenuLabels.length) {
                            IRadioMenuLabel iRadioMenuLabel = radioMenuLabels[j];
                            workRadioMenu.addRadioMenuAction(iRadioMenuLabel);
                            ++j;
                        }
                    } else {
                        ret.addExistingSubMenu(absMenu, subMenuLabel);
                    }
                } else {
                    IMenuComponent mc;
                    int k;
                    IMenuComponent[] mcs;
                    IMenu menuInM;
                    IMenuComponent compInM;
                    IMenuComponent[] compsInM;
                    IMenu m = (IMenu)absMenu;
                    m = MenuFactory.transformSubMenuesToMenuParts(m, minimumSubMenuEntries, notASubmenuList);
                    IMenuComponent[] menuComps = m.getMenuComponents();
                    compCount = menuComps.length;
                    if (notASubmenuList.contains(absMenu)) {
                        compsInM = m.getMenuComponents();
                        j = 0;
                        while (j < compsInM.length) {
                            compInM = compsInM[j];
                            MenuFactory.replaceLabelProvider(subMenuLabel, compInM, false);
                            if (compInM instanceof IMenu) {
                                menuInM = (IMenu)compInM;
                                mcs = menuInM.getMenuComponents();
                                k = 0;
                                while (k < mcs.length) {
                                    mc = mcs[k];
                                    MenuFactory.replaceLabelProvider(subMenuLabel, mc, false);
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        if (i > 0) {
                            ret.addMenuSeparator();
                        }
                        ret.addExistingMenuPart(m);
                        if (i < comps.length - 1) {
                            ret.addMenuSeparator();
                        }
                    } else if (compCount < minimumSubMenuEntries) {
                        compsInM = m.getMenuComponents();
                        j = 0;
                        while (j < compsInM.length) {
                            compInM = compsInM[j];
                            MenuFactory.replaceLabelProvider(subMenuLabel, compInM, true);
                            if (compInM instanceof IMenu) {
                                menuInM = (IMenu)compInM;
                                mcs = menuInM.getMenuComponents();
                                k = 0;
                                while (k < mcs.length) {
                                    mc = mcs[k];
                                    MenuFactory.replaceLabelProvider(subMenuLabel, mc, true);
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        if (i > 0) {
                            ret.addMenuSeparator();
                        }
                        ret.addExistingMenuPart(m);
                        if (i < comps.length - 1) {
                            ret.addMenuSeparator();
                        }
                    } else {
                        ret.addExistingSubMenu((IAbstractMenu)m, subMenuLabel);
                    }
                }
            } else if (iMenuComponent instanceof ICheckMenuLabel) {
                ICheckMenuLabel checkMenuLabel = (ICheckMenuLabel)iMenuComponent;
                ret.addCheckableMenuAction(checkMenuLabel.getLabelProvider(), checkMenuLabel.getMenuStatus(), checkMenuLabel.isChecked(), checkMenuLabel.getCheckAction());
            } else if (iMenuComponent instanceof IMenuLabel) {
                IMenuLabel menuLabel = (IMenuLabel)iMenuComponent;
                ret.addMenuAction(menuLabel.getLabelProvider(), menuLabel.getMenuStatus(), menuLabel.getAction());
            }
            ++i;
        }
        return ret;
    }

    private static void replaceLabelProvider(ISubMenuLabel subMenuLabel, IMenuComponent compInM, boolean combineLabels) {
        if (compInM instanceof IMenuLabel) {
            IMenuLabel compLabel = (IMenuLabel)compInM;
            IMenuLabelProvider compLabelProviderOld = compLabel.getLabelProvider();
            String pre = "";
            if (combineLabels) {
                pre = subMenuLabel.getText() + " - ";
            }
            String newText = pre + compLabelProviderOld.getText();
            Image newImage = compLabelProviderOld.getImage();
            if (newImage == null) {
                // empty if block
            }
            MenuLabelProvider compLabelProviderNew = new MenuLabelProvider(newText, newImage, compLabelProviderOld.getShortcut());
            compLabel.setLabelProvider(compLabelProviderNew);
        }
    }

    private IPath calculatePath(IContext context, IActionContext actionContext, MuSiAction iMusiAction) {
        IPath ret = null;
        MuSiAction iGenericAction = iMusiAction;
        if (iGenericAction.isAvailable(actionContext)) {
            ICategory iActionCategory = iGenericAction.getCategory();
            if (iActionCategory == null) {
                iActionCategory = Category.DEFAULT;
            }
            ret = this.getPathProviderManager().getPath(iActionCategory, context);
        }
        return ret;
    }

    private IMenu checkIfSubMenuAlreadyContained(IMenu iMenu, String pathText) {
        IMenu subMenu = null;
        IMenuComponent[] components = iMenu.getMenuComponents();
        int l = 0;
        while (subMenu == null && l < components.length) {
            ISubMenuLabel subMenuLabel;
            boolean subMenuAlreadyAvailable;
            IMenuComponent iMenuComponent = components[l];
            if (iMenuComponent instanceof ISubMenuLabel && (subMenuAlreadyAvailable = (subMenuLabel = (ISubMenuLabel)iMenuComponent).getText().equals(pathText)) && subMenuLabel.getSubMenu() instanceof IMenu) {
                subMenu = (IMenu)subMenuLabel.getSubMenu();
            }
            ++l;
        }
        return subMenu;
    }

    private IMenuLabel checkIfMenuLabelAlreadyContained(IMenu iMenu, String pathText) {
        IMenuLabel ret = null;
        IMenuComponent[] components = iMenu.getMenuComponents();
        int l = 0;
        while (ret == null && l < components.length) {
            IMenuLabel menuLabel;
            boolean menuAlreadyAvailable;
            IMenuComponent iMenuComponent = components[l];
            if (iMenuComponent instanceof IMenuLabel && (menuAlreadyAvailable = (menuLabel = (IMenuLabel)iMenuComponent).getText().equals(pathText))) {
                ret = menuLabel;
            }
            ++l;
        }
        return ret;
    }

    public IPathProviderManager getPathProviderManager() {
        if (this.pathProviderManager == null) {
            this.pathProviderManager = new PathProviderManager();
        }
        return this.pathProviderManager;
    }

    public void setPathProviderManager(IPathProviderManager pathProviderManager) {
        this.pathProviderManager = pathProviderManager;
    }

    private static Vector calculateAvailableSingleActionCategories(IGenericActionContainer singleActionContainer, Object[] objects) {
        Vector<Object> ret = new Vector<Object>();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (i == 0) {
                ret = MenuFactory.calculateAvailableSingleActionCategories(singleActionContainer, object, objects);
            } else {
                Vector calc = MenuFactory.calculateAvailableSingleActionCategories(singleActionContainer, object, objects);
                Object[] oldOnes = ret.toArray();
                ret = new Vector<Object>();
                int j = 0;
                while (j < oldOnes.length) {
                    Object oldOne = oldOnes[j];
                    if (calc.contains(oldOne)) {
                        ret.add(oldOne);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ret;
    }

    private static Vector calculateAvailableSingleActionCategories(IGenericActionContainer singleActionContainer, Object object, Object[] context) {
        Vector<ICategory> ret = new Vector<ICategory>();
        ActionContext actionContext = new ActionContext(object, context);
        IGenericAction[] singleActions = new IGenericAction[]{};
        int singleActionCount = 0;
        if (singleActionContainer != null) {
            singleActions = singleActionContainer.getActions();
            singleActionCount = singleActions.length;
            int j = 0;
            while (j < singleActionCount) {
                IGenericAction iSingleAction = singleActions[j];
                boolean available = iSingleAction.isAvailable(actionContext);
                ICategory category = iSingleAction.getCategory();
                if (available && !ret.contains(category)) {
                    ret.add(category);
                }
                ++j;
            }
        }
        return ret;
    }

    private static Vector calculateAvailableMultiActionCategories(IGenericActionContainer multiActionContainer, Object[] objects) {
        Vector<ICategory> ret = new Vector<ICategory>();
        IGenericAction[] multiActions = new IGenericAction[]{};
        if (multiActionContainer != null) {
            multiActions = multiActionContainer.getActions();
            int j = 0;
            while (j < multiActions.length) {
                ICategory category;
                IGenericAction iMultiAction = multiActions[j];
                boolean addIt = true;
                int k = 0;
                while (addIt && k < objects.length) {
                    Object object = objects[k];
                    ActionContext actionContext = new ActionContext(object, objects);
                    addIt = addIt && iMultiAction.isAvailable(actionContext);
                    ++k;
                }
                if (addIt && !ret.contains(category = iMultiAction.getCategory())) {
                    ret.add(category);
                }
                ++j;
            }
        }
        return ret;
    }

    public boolean isAvailableSingleActionCategory(ICategory category, Object[] context) {
        boolean ret = true;
        int i = 0;
        while (ret && i < context.length) {
            ActionContext actionContext = new ActionContext(context[i], context);
            IGenericActionContainer singleActions = ActionProviderManager.getInstance().getSingleActions(actionContext);
            IGenericAction[] genericActions = singleActions.getActions(category);
            boolean available = false;
            int j = 0;
            while (!available && j < genericActions.length) {
                available = genericActions[j].isAvailable(actionContext);
                ++j;
            }
            ret = ret && available;
            ++i;
        }
        return ret;
    }

    public boolean isAvailableMultiActionCategory(ICategory category, Object[] context) {
        boolean ret = true;
        int i = 0;
        while (ret && i < context.length) {
            ActionContext actionContext = new ActionContext(context[i], context);
            IGenericActionContainer multiActions = ActionProviderManager.getInstance().getMultiActions(actionContext);
            IGenericAction[] genericActions = multiActions.getActions(category);
            boolean available = false;
            int j = 0;
            while (!available && j < genericActions.length) {
                available = genericActions[j].isAvailable(actionContext);
                ++j;
            }
            ret = ret && available;
            ++i;
        }
        return ret;
    }

    public static MuSiAction[] getAvailibleActions(Object[] objects, IActionFilter actionFilter) {
        long time = System.currentTimeMillis();
        IActionProviderManager apm = ActionProviderManager.getInstance();
        IGenericAction[] multiActions = null;
        IGenericAction[][] singleActions = new IGenericAction[objects.length][];
        IActionContext[] ac = new IActionContext[objects.length];
        int i = 0;
        while (i < objects.length) {
            ac[i] = new ActionContext(objects[i], objects);
            if (i == 0) {
                multiActions = apm.getMultiActions(ac[i]).getActions();
            }
            singleActions[i] = apm.getSingleActions(ac[i]).getActions();
            ++i;
        }
        int i2 = 0;
        while (i2 < multiActions.length) {
            if (!multiActions[i2].isAvailable(ac[0]) || !actionFilter.isAvailable((IGenericAction)multiActions[i2], ac[0])) {
                multiActions[i2] = null;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < multiActions.length) {
            if (multiActions[i3] != null) {
                MenuFactory.removeCat(singleActions, multiActions[i3].getCategory());
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < singleActions.length) {
            int j = 0;
            while (j < singleActions[i4].length) {
                if (!(singleActions[i4][j] == null || singleActions[i4][j].isAvailable(ac[i4]) && actionFilter.isAvailable(singleActions[i4][j], ac[i4]))) {
                    singleActions[i4][j] = null;
                }
                ++j;
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < singleActions[0].length) {
            ICategory cat;
            if (singleActions[0][i5] != null && !MenuFactory.isCatAvailible(singleActions, cat = singleActions[0][i5].getCategory())) {
                MenuFactory.removeCat(singleActions, cat);
            }
            ++i5;
        }
        ArrayList<MuSiAction> musis = new ArrayList<MuSiAction>();
        MuSiActionContext musiac = new MuSiActionContext(multiActions, singleActions, objects);
        int i6 = 0;
        while (i6 < multiActions.length) {
            if (multiActions[i6] != null) {
                IGenericAction g = multiActions[i6];
                musis.add(new MuSiAction(g.getCategory(), musiac));
            }
            ++i6;
        }
        int i7 = 0;
        while (i7 < singleActions[0].length) {
            if (singleActions[0][i7] != null) {
                IGenericAction g = singleActions[0][i7];
                musis.add(new MuSiAction(g.getCategory(), musiac));
            }
            ++i7;
        }
        if (T.debug()) {
            T.debug("getAvailibleActions(Object[] objects)", "Time needed to collect actions: " + (System.currentTimeMillis() - time));
        }
        MuSiAction[] ret = musis.toArray(new MuSiAction[musis.size()]);
        return MenuFactory.removeActionsWithDuplicatedCategories(ret);
    }

    private static void removeCat(IGenericAction[][] singleActions, ICategory cat) {
        int i = 0;
        while (i < singleActions.length) {
            int j = 0;
            while (j < singleActions[i].length) {
                if (singleActions[i][j] != null && singleActions[i][j].getCategory().equals(cat)) {
                    singleActions[i][j] = null;
                }
                ++j;
            }
            ++i;
        }
    }

    private static boolean isCatAvailible(IGenericAction[][] singleActions, ICategory cat) {
        boolean ret = true;
        int i = 0;
        while (i < singleActions.length && ret) {
            boolean containsCat = false;
            int j = 0;
            while (j < singleActions[i].length && !containsCat) {
                if (singleActions[i][j] != null && singleActions[i][j].getCategory().equals(cat)) {
                    containsCat = true;
                }
                ++j;
            }
            ret &= containsCat;
            ++i;
        }
        return ret;
    }

    public static void performActionsForContext(ICategory category, IContext context, IActionFilter filter) {
        MuSiAction[] availibleActions = MenuFactory.getAvailibleActions(context.getContextObjects(), filter);
        HashSet<MuSiAction> hash = new HashSet<MuSiAction>();
        int i = 0;
        while (i < availibleActions.length) {
            MuSiAction action = availibleActions[i];
            if (category.equals(action.getCategory())) {
                hash.add(action);
            }
            ++i;
        }
        MuSiAction[] availibleActionsWithCurrentCategory = ((AbstractCollection)hash).toArray(new MuSiAction[0]);
        int i2 = 0;
        while (i2 < availibleActionsWithCurrentCategory.length) {
            availibleActionsWithCurrentCategory[i2].run(null);
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MuSiActionContext {
        public IGenericAction[] multis;
        public IGenericAction[][] singles;
        public Object[] objects;

        protected MuSiActionContext(IGenericAction[] multis, IGenericAction[][] singles, Object[] objects) {
            this.multis = multis;
            this.singles = singles;
            this.objects = objects;
        }
    }

    private static class MuSiAction
    implements IGenericAction {
        IPath path;
        ICategory cat;
        boolean enabled;
        MuSiActionContext musiac;

        public MuSiAction(ICategory cat, MuSiActionContext musiac) {
            this.cat = cat;
            this.musiac = musiac;
            this.checkEnabled();
        }

        private void checkEnabled() {
            this.enabled = false;
            int i = 0;
            while (i < this.musiac.multis.length && !this.enabled) {
                if (this.musiac.multis[i] != null && this.musiac.multis[i].getCategory().equals(this.cat) && this.musiac.multis[i].isEnabled(new ActionContext(this.musiac.objects[0], this.musiac.objects))) {
                    this.enabled = true;
                }
                ++i;
            }
            if (!this.enabled) {
                this.enabled = true;
                int i2 = 0;
                while (i2 < this.musiac.singles.length && this.enabled) {
                    ActionContext lineContext = new ActionContext(this.musiac.objects[i2], this.musiac.objects);
                    boolean lineEnabled = false;
                    int j = 0;
                    while (j < this.musiac.singles[i2].length && !lineEnabled) {
                        if (this.musiac.singles[i2][j] != null && this.musiac.singles[i2][j].getCategory().equals(this.cat) && this.musiac.singles[i2][j].isEnabled(lineContext)) {
                            lineEnabled = true;
                        }
                        ++j;
                    }
                    if (!lineEnabled) {
                        this.enabled = false;
                    }
                    ++i2;
                }
            }
        }

        public boolean isAvailable(IActionContext actionContext) {
            return true;
        }

        public boolean isEnabled(IActionContext actionContext) {
            return this.enabled;
        }

        public void run(IActionContext actionContext) {
            boolean finished = false;
            int i = 0;
            while (i < this.musiac.multis.length && !finished) {
                ActionContext ac = new ActionContext(this.musiac.objects[0], this.musiac.objects);
                if (this.musiac.multis[i] != null && this.musiac.multis[i].getCategory().equals(this.cat) && this.musiac.multis[i].isEnabled(ac)) {
                    this.saveRunAction(this.musiac.multis[i], ac);
                    finished = true;
                }
                ++i;
            }
            if (!finished) {
                int i2 = 0;
                while (i2 < this.musiac.singles.length) {
                    ActionContext lineContext = new ActionContext(this.musiac.objects[i2], this.musiac.objects);
                    boolean lineFinished = false;
                    int fallbackIndex = -1;
                    int j = 0;
                    while (j < this.musiac.singles[i2].length && !lineFinished) {
                        if (this.musiac.singles[i2][j] != null && this.musiac.singles[i2][j].getCategory().equals(this.cat) && this.musiac.singles[i2][j].isEnabled(lineContext)) {
                            if (this.musiac.singles[i2][j].isFallbackAction()) {
                                fallbackIndex = j;
                            } else {
                                this.saveRunAction(this.musiac.singles[i2][j], lineContext);
                                lineFinished = true;
                            }
                        }
                        ++j;
                    }
                    if (!lineFinished && fallbackIndex >= 0) {
                        this.saveRunAction(this.musiac.singles[i2][fallbackIndex], lineContext);
                        lineFinished = true;
                    }
                    ++i2;
                }
            }
        }

        private void saveRunAction(IGenericAction action, IActionContext ac) {
            try {
                action.run(ac);
            }
            catch (Throwable th) {
                T.error("Error in performing action", th);
            }
        }

        public ICategory getCategory() {
            return this.cat;
        }

        public boolean isMultiAction() {
            return true;
        }

        public IPath getPath() {
            return this.path;
        }

        public void setPath(IPath path) {
            this.path = path;
        }

        public boolean isFallbackAction() {
            return false;
        }
    }

    protected static class MenuEntrySorter
    implements Comparator {
        IDisplayableCategoryComparator postComparator = null;
        private static final int ORDER_PRE = 1;
        private static final int ORDER_MID = 2;
        private static final int ORDER_POST = 3;

        public MenuEntrySorter() {
        }

        public MenuEntrySorter(IDisplayableCategoryComparator postComparator) {
            this.setPostComparator(postComparator);
        }

        public int compare(Object o1, Object o2) {
            int ret = 0;
            if (o1 != null && o2 != null) {
                if (o1 instanceof MuSiAction && o2 instanceof MuSiAction) {
                    IPath path1 = ((MuSiAction)o1).getPath();
                    IPath path2 = ((MuSiAction)o2).getPath();
                    if (path1 != null && path2 != null) {
                        int order2;
                        int order1 = path1.getLeafElement().getOrder();
                        ret = order1 < (order2 = path2.getLeafElement().getOrder()) ? -1 : (order1 > order2 ? 1 : 0);
                    }
                }
                if (ret == 0 && o1 instanceof com.tssap.util.action.IAction && o2 instanceof com.tssap.util.action.IAction) {
                    String compare2;
                    ICategory category1 = ((com.tssap.util.action.IAction)o1).getCategory();
                    ICategory category2 = ((com.tssap.util.action.IAction)o2).getCategory();
                    String compare1 = MenuEntrySorter.getPredefinedEclipseCategoryString(category1);
                    ret = compare1.compareTo(compare2 = MenuEntrySorter.getPredefinedEclipseCategoryString(category2));
                    if (ret == 0) {
                        int depth1 = MenuEntrySorter.calculateCategoryDepth(category1);
                        int depth2 = MenuEntrySorter.calculateCategoryDepth(category2);
                        int depth = Math.min(depth1, depth2);
                        ICategory cat1 = category1;
                        ICategory cat2 = category2;
                        int i = 0;
                        while (i < depth1 - depth) {
                            cat1 = cat1.getParent();
                            ++i;
                        }
                        int i2 = 0;
                        while (i2 < depth2 - depth) {
                            cat2 = cat2.getParent();
                            ++i2;
                        }
                        if (!cat1.equals(cat2) && cat1 instanceof IDisplayableCategory && cat2 instanceof IDisplayableCategory) {
                            while (cat1 != null && cat2 != null) {
                                int compare;
                                compare1 = cat1.getDescription();
                                compare2 = cat2.getDescription();
                                if (cat1 instanceof IDisplayableCategory && cat2 instanceof IDisplayableCategory) {
                                    compare1 = ((IDisplayableCategory)cat1).getName();
                                    compare2 = ((IDisplayableCategory)cat2).getName();
                                }
                                if (cat1 instanceof IExtendedDisplayableCategory && cat2 instanceof IExtendedDisplayableCategory) {
                                    int pos1 = ((IExtendedDisplayableCategory)cat1).getPreferredPosition();
                                    int pos2 = ((IExtendedDisplayableCategory)cat2).getPreferredPosition();
                                    compare1 = MenuEntrySorter.align(pos1, 2) + compare1;
                                    compare2 = MenuEntrySorter.align(pos2, 2) + compare2;
                                }
                                if ((compare = compare1.compareTo(compare2)) != 0) {
                                    ret = compare;
                                }
                                cat1 = cat1.getParent();
                                cat2 = cat2.getParent();
                            }
                        }
                    }
                    if (this.getPostComparator() != null) {
                        ret = this.getPostComparator().compare((IDisplayableCategory)category1, (IDisplayableCategory)category2);
                    }
                }
            }
            return ret;
        }

        private static String align(int x, int order) {
            String DEF;
            String ret = DEF = "00000000000000";
            int defLength = DEF.length();
            if (x > -1) {
                if (order == 1) {
                    ret = ret + x;
                    ret = ret.substring(ret.length() - defLength);
                } else if (order == 2) {
                    ret = ret + x + "00";
                    ret = ret.substring(ret.length() - defLength - 2);
                } else if (order == 3) {
                    ret = x + DEF;
                    ret = ret.substring(0, defLength);
                }
            }
            return ret;
        }

        private static int calculateCategoryDepth(ICategory category) {
            int ret = 1;
            while ((category = category.getParent()) != null) {
                ++ret;
            }
            return ret;
        }

        private static boolean isPredefinedEclipseCategory(ICategory category) {
            boolean ret = false;
            int i = 0;
            while (!ret && i < ECLIPSE_CATEGORIES.length) {
                ret = ECLIPSE_CATEGORIES[i].equals(category);
                ++i;
            }
            return ret;
        }

        private static String getPredefinedEclipseCategoryString(ICategory category) {
            String ret = "00000000000099";
            int o = MenuEntrySorter.getOrderInPredefinedEclipseCategories(category);
            if (o > -1) {
                ret = MenuEntrySorter.align(o, 1);
            } else {
                o = MenuEntrySorter.getOrderInPostdefinedEclipseCategories(category);
                if (o > -1) {
                    ret = MenuEntrySorter.align(o, 3);
                }
            }
            return ret;
        }

        private static int getOrderInPredefinedEclipseCategories(ICategory category) {
            ICategory parentCategory;
            int ret = -1;
            if (!category.equals(Category.PROPERTIES) && (ret = Arrays.asList(ECLIPSE_CATEGORIES).indexOf(category)) < 0 && (parentCategory = category.getParent()) != null) {
                ret = MenuEntrySorter.getOrderInPredefinedEclipseCategories(parentCategory);
            }
            return ret;
        }

        private static int getOrderInPostdefinedEclipseCategories(ICategory category) {
            int ret = -1;
            if (category.equals(Category.PROPERTIES)) {
                ret = 99;
            }
            return ret;
        }

        public IDisplayableCategoryComparator getPostComparator() {
            return this.postComparator;
        }

        public void setPostComparator(IDisplayableCategoryComparator comparator) {
            this.postComparator = comparator;
        }
    }

    private class DisplayMenuLabelProvider
    implements IMenuLabelProvider {
        IDisplayable displayable = null;

        public DisplayMenuLabelProvider(IDisplayable displayable) {
            this.setDisplayable(displayable);
        }

        public String getText() {
            String ret = null;
            if (this.getDisplayable() != null) {
                ret = this.getDisplayable().getName();
            }
            return ret;
        }

        public String getDescription() {
            String ret = null;
            if (this.getDisplayable() != null) {
                ret = this.getDisplayable().getInfo();
            }
            return ret;
        }

        public Image getImage() {
            Image ret = null;
            if (this.getDisplayable() != null) {
                ret = this.getDisplayable().getImage();
            }
            return ret;
        }

        public String getShortcut() {
            String ret = null;
            if (this.getDisplayable() != null) {
                ret = this.getDisplayable().getInfo();
            }
            return ret;
        }

        public IDisplayable getDisplayable() {
            return this.displayable;
        }

        public void setDisplayable(IDisplayable displayable) {
            this.displayable = displayable;
        }
    }

    private class ContextedAction {
        private IGenericAction action;
        private Object context;

        public ContextedAction(IGenericAction action, Object context) {
            this.setAction(action);
            this.setContext(context);
        }

        public IGenericAction getAction() {
            return this.action;
        }

        public Object getContext() {
            return this.context;
        }

        private void setAction(IGenericAction action) {
            this.action = action;
        }

        private void setContext(Object context) {
            this.context = context;
        }

        public int hashCode() {
            return 17 + (this.context != null ? this.context.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            boolean ret = false;
            if (obj instanceof ContextedAction) {
                ContextedAction contextedAction = (ContextedAction)obj;
                if (this.getContext().equals(contextedAction.getContext())) {
                    ret = true;
                }
            }
            return ret;
        }
    }

    private class DelegateAction
    implements IAction,
    IMenuStatus {
        private Vector contextedDestinationActionVector;
        private boolean onlyOneDestination = false;

        public DelegateAction(IGenericAction action, Object context) {
            this.addContextedDestinationAction(new ContextedAction(action, context));
        }

        public DelegateAction(IGenericAction action, Object context, boolean onlyOneDestination) {
            this.addContextedDestinationAction(new ContextedAction(action, context));
            this.setOnlyOneDestination(onlyOneDestination);
        }

        public DelegateAction(ContextedAction contextedDestinationAction) {
            this(contextedDestinationAction.getAction(), contextedDestinationAction.getContext());
        }

        public void process(IContext context) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new BusyProcessWorker(context));
        }

        private void processInternal(IContext context) {
            ContextedAction[] contextedActions = this.getContextedDestinationActions();
            int i = 0;
            while (i < contextedActions.length) {
                contextedActions[i].getAction().run(new ActionContext(contextedActions[i].getContext(), context.getContextObjects()));
                ++i;
            }
        }

        public boolean isEnabled(IContext context) {
            boolean ret = true;
            ContextedAction[] contextedActions = this.getContextedDestinationActions();
            int i = 0;
            while (ret && i < contextedActions.length) {
                ret = contextedActions[i].getAction().isEnabled(new ActionContext(contextedActions[i].getContext(), context.getContextObjects()));
                ++i;
            }
            return ret;
        }

        public boolean isVisible(IContext context) {
            boolean ret = true;
            ContextedAction[] contextedActions = this.getContextedDestinationActions();
            int i = 0;
            while (ret && i < contextedActions.length) {
                ret = contextedActions[i].getAction().isAvailable(new ActionContext(contextedActions[i].getContext(), context.getContextObjects()));
                ++i;
            }
            return ret;
        }

        public ContextedAction[] getContextedDestinationActions() {
            ContextedAction[] ret = new ContextedAction[]{};
            if (this.getContextedDestinationActionVector() != null && this.getContextedDestinationActionVector().size() > 0) {
                ret = this.getContextedDestinationActionVector().toArray(ret);
            }
            return ret;
        }

        public boolean addContextedDestinationAction(ContextedAction contextedAction) {
            boolean ret = false;
            if (!this.isOnlyOneDestination() || this.getContextedDestinationActions().length < 1) {
                Vector vec = this.getContextedDestinationActionVector();
                boolean contextSupplied = false;
                Enumeration enumeration = vec.elements();
                while (!contextSupplied && enumeration.hasMoreElements()) {
                    ContextedAction iContextedAction = (ContextedAction)enumeration.nextElement();
                    if (!iContextedAction.getContext().equals(contextedAction.getContext())) continue;
                    contextSupplied = true;
                }
                if (!contextSupplied) {
                    ret = vec.add(contextedAction);
                }
            }
            return ret;
        }

        public boolean removeContextedDestinationAction(ContextedAction contextedAction) {
            return this.getContextedDestinationActionVector().remove(contextedAction);
        }

        private Vector getContextedDestinationActionVector() {
            if (this.contextedDestinationActionVector == null) {
                this.contextedDestinationActionVector = new Vector();
            }
            return this.contextedDestinationActionVector;
        }

        public boolean isOnlyOneDestination() {
            return this.onlyOneDestination;
        }

        private void setOnlyOneDestination(boolean onlyOneDestination) {
            this.onlyOneDestination = onlyOneDestination;
        }

        private class BusyProcessWorker
        implements Runnable {
            private IContext context;

            public BusyProcessWorker(IContext context) {
                this.setContext(context);
            }

            public void run() {
                DelegateAction.this.processInternal(this.getContext());
            }

            public IContext getContext() {
                return this.context;
            }

            private void setContext(IContext context) {
                this.context = context;
            }
        }
    }
}

