/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.lfsupport;

import com.tssap.util.UtilPlugin;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.lfsupport.LiteWidgetFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.WorkbenchColors;

public class WhiteWidgetFactory
extends LiteWidgetFactory {
    private Image formBannerImage;
    private PaintListener borderPainter;

    public Composite createComposite(Composite pParent, boolean pBorderFlag) {
        Composite ret = super.createComposite(pParent, pBorderFlag);
        this.modifyControl((Control)ret);
        return ret;
    }

    public Group createGroup(Composite pParent, boolean pBorderFlag) {
        Group ret = super.createGroup(pParent, pBorderFlag);
        this.modifyControl((Control)ret);
        return ret;
    }

    public SashForm createSashForm(Composite pParent, boolean pVertical) {
        SashForm ret = super.createSashForm(pParent, pVertical);
        this.modifyControl((Control)ret);
        return ret;
    }

    public ViewForm createViewForm(Composite pParent) {
        ViewForm ret = super.createViewForm(pParent);
        this.modifyControl((Control)ret);
        return ret;
    }

    public Button createCheckBox(Composite pParent, String pCheckBoxText, boolean pCheckBoxValue) {
        Button ret = super.createCheckBox(pParent, pCheckBoxText, pCheckBoxValue);
        this.modifyControl((Control)ret);
        return ret;
    }

    public Combo createComboBox(Composite pParent, String[] pItems, String pDefaultText, boolean pReadOnly) {
        int localStyle = 4;
        if (pReadOnly) {
            localStyle |= 8;
        }
        Combo newCombo = new Combo(pParent, this.modifyStyle(localStyle &= 0xFFFFF7FF));
        newCombo.setItems(pItems);
        newCombo.setText(pDefaultText);
        this.modifyControl((Control)newCombo);
        return newCombo;
    }

    public Label createImageLabel(Composite pParent, Image pImage, boolean pBorderFlag) {
        Label ret = super.createImageLabel(pParent, pImage, pBorderFlag);
        this.modifyControl((Control)ret);
        return ret;
    }

    public List createList(Composite pParent, String[] pItems, boolean enableMultipleSelection) {
        List ret = super.createList(pParent, pItems, enableMultipleSelection);
        this.modifyControl((Control)ret);
        return ret;
    }

    public Button createPushButton(Composite pParent, String pButtonText, Image pButtonImage, String pButtonTooltip) {
        Button ret = new Button(pParent, 0x800008);
        ret.setText(pButtonText);
        ret.setImage(pButtonImage);
        ret.setToolTipText(pButtonTooltip);
        this.modifyControl((Control)ret);
        return ret;
    }

    public ToolItem createPushToolItem(ToolBar pParent) {
        ToolItem ret = super.createPushToolItem(pParent);
        return ret;
    }

    public Button createRadioButton(Composite pParent, String pButtonText, Image pButtonImage, String pButtonTooltip) {
        Button ret = super.createRadioButton(pParent, pButtonText, pButtonImage, pButtonTooltip);
        this.modifyControl((Control)ret);
        return ret;
    }

    public Button[] createRadioButtonGroup(Composite pParent, String pTitle, String[] pRadioButtonText, int pSelectedItem, boolean pIsHorizontalFlag) {
        Button[] ret = super.createRadioButtonGroup(pParent, pTitle, pRadioButtonText, pSelectedItem, pIsHorizontalFlag);
        int i = 0;
        while (i < ret.length) {
            Button button = ret[i];
            this.modifyControl((Control)button);
            ++i;
        }
        return ret;
    }

    public ToolItem createSeparatorToolItem(ToolBar pParent) {
        ToolItem ret = super.createSeparatorToolItem(pParent);
        return ret;
    }

    public TabFolder createTabFolder(Composite pParent) {
        TabFolder ret = super.createTabFolder(pParent);
        this.modifyControl((Control)ret);
        return ret;
    }

    public TabItem createTabItem(TabFolder pTabFolder) {
        TabItem ret = super.createTabItem(pTabFolder);
        Control c = ret.getControl();
        if (c != null) {
            this.modifyControl(c);
        }
        return ret;
    }

    public Text createTextField(Composite pParent, String pDefaultText, boolean pReadOnly) {
        Text ret = super.createTextField(pParent, pDefaultText, pReadOnly);
        this.modifyControl((Control)ret);
        return ret;
    }

    public Label createTextLabel(Composite pParent, String pLabelText) {
        Label ret = super.createTextLabel(pParent, pLabelText);
        this.modifyControl((Control)ret);
        return ret;
    }

    public Text createTextPane(Composite pParent, String pDefaultText, boolean pReadOnly, boolean pUseWordWrap) {
        Text ret = super.createTextPane(pParent, pDefaultText, pReadOnly, pUseWordWrap);
        this.modifyControl((Control)ret);
        return ret;
    }

    public ToolBar createToolBar(Composite pParent, boolean pVertical) {
        ToolBar ret = super.createToolBar(pParent, pVertical);
        this.modifyControl((Control)ret);
        return ret;
    }

    protected void modifyControl(Control ret) {
        ret.setBackground(WorkbenchColors.getSystemColor((int)1));
        ret.addPaintListener(this.getBorderPainter());
    }

    protected PaintListener getBorderPainter() {
        if (this.borderPainter == null) {
            this.borderPainter = new BorderPainter();
        }
        return this.borderPainter;
    }

    protected int modifyStyle(int style) {
        int ret = super.modifyStyle(style);
        Integer.toBinaryString(ret);
        Integer.toBinaryString(ret |= 0x800000);
        return ret;
    }

    protected Text createTextComponent(Composite pParent, String pDefaultText, boolean pReadOnly, int pStyle) {
        int localStyle = pStyle | 0x800000;
        if (pReadOnly) {
            localStyle |= 8;
        }
        Text newText = new Text(pParent, this.modifyStyle(localStyle &= 0xFFFFF7FF));
        newText.setText(pDefaultText);
        return newText;
    }

    public PaintListener createFormTitlePaintListener(String title) {
        FormTitlePaintListener ret = new FormTitlePaintListener(title);
        return ret;
    }

    public PaintListener createSectionTitlePaintListener(String title) {
        SectionTitlePaintListener ret = new SectionTitlePaintListener(title);
        return ret;
    }

    public Table createTable(Composite pParent, boolean pBorderFlag, boolean pHScroll, boolean pVScroll, boolean pMultiSelect, boolean pHideSelect, boolean pFullSelect, boolean pCheckBox) {
        pBorderFlag = false;
        Table ret = super.createTable(pParent, pBorderFlag, pHScroll, pVScroll, pMultiSelect, pHideSelect, pFullSelect, pCheckBox);
        this.modifyControl((Control)ret);
        return ret;
    }

    public TableTree createTableTree(Composite pParent, boolean pBorderFlag, boolean pHScroll, boolean pVScroll, boolean pMultiSelect, boolean pFullSelect, boolean pCheckBox) {
        pBorderFlag = false;
        TableTree ret = super.createTableTree(pParent, pBorderFlag, pHScroll, pVScroll, pMultiSelect, pFullSelect, pCheckBox);
        this.modifyControl((Control)ret);
        return ret;
    }

    public Tree createTree(Composite pParent, boolean pBorderFlag, boolean pHScroll, boolean pVScroll, boolean pMultiSelect, boolean pCheckBox) {
        pBorderFlag = false;
        Tree ret = super.createTree(pParent, pBorderFlag, pHScroll, pVScroll, pMultiSelect, pCheckBox);
        this.modifyControl((Control)ret);
        return ret;
    }

    class BorderPainter
    implements PaintListener {
        private Color textBorderColor = WorkbenchColors.getSystemColor((int)2);
        private Color viewerBorderColor = WorkbenchColors.getSystemColor((int)15);

        BorderPainter() {
        }

        public void paintControl(PaintEvent event) {
            if (event.widget instanceof Widget) {
                Control control;
                Widget widget = event.widget;
                this.paintWidgetInternal(widget, event);
                if (widget instanceof Control && (control = (Control)event.widget) instanceof Composite) {
                    Composite composite = (Composite)event.widget;
                    Control[] children = composite.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        Control c = children[i];
                        this.paintControlInternal(c, event);
                        ++i;
                    }
                }
            }
        }

        private void paintControlInternal(Control c, PaintEvent event) {
            if (c instanceof Text || c instanceof Combo || c instanceof Canvas) {
                Rectangle b = c.getBounds();
                GC gc = event.gc;
                this.clearBorder(c, gc);
                gc.setForeground(this.textBorderColor);
                gc.drawRectangle(b.x - 1, b.y - 2, b.width + 1, b.height + 3);
            } else if (c instanceof Table || c instanceof Tree || c instanceof TableTree) {
                Rectangle b = c.getBounds();
                GC gc = event.gc;
                gc.setForeground(this.viewerBorderColor);
                gc.drawRectangle(b.x - 1, b.y - 1, b.width + 2, b.height + 2);
            }
        }

        private void paintWidgetInternal(Widget w, PaintEvent event) {
        }

        private void clearBorder(Control c, GC gc) {
            Rectangle b = c.getBounds();
            gc.setForeground(c.getBackground());
            gc.drawRectangle(b.x - 2, b.y - 2, b.width + 2, b.height + 2);
            gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
            gc.drawRectangle(b.x, b.y, b.width, b.height);
        }
    }

    public class SectionTitlePaintListener
    implements PaintListener {
        private final Color borderColor = new Color((Device)Display.getCurrent(), 152, 170, 203);
        private static final int H_GAP = 10;
        private static final int V_GAP = 5;
        private String titleText;

        public SectionTitlePaintListener(String titleText) {
            this.setTitleText(titleText);
        }

        private void setTitleText(String titleText) {
            this.titleText = titleText;
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            gc.setFont(JFaceResources.getBannerFont());
            gc.drawText(this.getTitleText(), 10, 5, true);
            gc.setForeground(this.borderColor);
            gc.setLineWidth(2);
            int xStartPos = e.x + 3;
            int yPos = e.y + 20;
            int hLineSpan = e.width - 5 - xStartPos;
            gc.drawLine(xStartPos, yPos, xStartPos + hLineSpan, yPos);
        }

        public String getTitleText() {
            return this.titleText;
        }
    }

    public class FormTitlePaintListener
    implements PaintListener {
        private static final int H_GAP = 10;
        private static final int V_GAP = 5;
        private String titleText;

        public FormTitlePaintListener(String titleText) {
            this.setTitleText(titleText);
        }

        private void setTitleText(String titleText) {
            this.titleText = titleText;
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            if (this.getFormBannerImage() != null) {
                gc.drawImage(this.getFormBannerImage(), 0, 0);
            }
            gc.setFont(JFaceResources.getHeaderFont());
            gc.drawText(this.getTitleText(), 10, 5, true);
        }

        private Image getFormBannerImage() {
            if (WhiteWidgetFactory.this.formBannerImage == null) {
                WhiteWidgetFactory.this.formBannerImage = SapIdeUtilImages.createImageFromIconsDirectory(UtilPlugin.getInstance().getDescriptor(), "form_banner.gif");
            }
            return WhiteWidgetFactory.this.formBannerImage;
        }

        public String getTitleText() {
            return this.titleText;
        }
    }
}

