/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.lfsupport;

import com.tssap.util.UtilPlugin;
import com.tssap.util.ui.lfsupport.DefaultWidgetFactory;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.lfsupport.LiteWidgetFactory;
import com.tssap.util.ui.lfsupport.WhiteWidgetFactory;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;

public class EditorWidgetFactoryContainer
implements IWidgetFactory,
IPropertyChangeListener {
    private static final boolean PATCHWORK = false;
    private static EditorWidgetFactoryContainer singleton;
    public static final int DEFAULT_WIDGET_FACTORY_INDEX = 0;
    public static final int LITE_WIDGET_FACTORY_INDEX = 1;
    public static final int WHITE_WIDGET_FACTORY_INDEX = 2;
    private Vector widgetFactoryVector = new Vector();
    private int activeWidgetFactoryIndex;

    private EditorWidgetFactoryContainer() {
        this.addWidgetFactory(new DefaultWidgetFactory());
        this.addWidgetFactory(new LiteWidgetFactory());
        this.addWidgetFactory(new WhiteWidgetFactory());
        IPreferenceStore preferenceStore = UtilPlugin.getInstance().getPreferenceStore();
        this.activeWidgetFactoryIndex = preferenceStore.getInt("editor widget factory index");
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public boolean addWidgetFactory(IWidgetFactory widgetFactory) {
        return this.widgetFactoryVector.add(widgetFactory);
    }

    public IWidgetFactory[] getWidgetFactories() {
        IWidgetFactory[] ret = new IWidgetFactory[]{};
        ret = this.widgetFactoryVector.toArray(ret);
        return ret;
    }

    private void setActiveWidgetFactoryIndex(int index) {
        int count = this.widgetFactoryVector.size();
        if (index < 0) {
            index = 0;
        } else if (index > count - 1) {
            index = count - 1;
        }
        this.activeWidgetFactoryIndex = index;
    }

    public Button createPushButton(Composite pParent, String pButtonText, Image pButtonImage, String pButtonTooltip) {
        return this.getActiveWidgetFactory().createPushButton(pParent, pButtonText, pButtonImage, pButtonTooltip);
    }

    public Button createToggleButton(Composite pParent, String pButtonText, Image pButtonImage, String pButtonTooltip) {
        return this.getActiveWidgetFactory().createToggleButton(pParent, pButtonText, pButtonImage, pButtonTooltip);
    }

    public Button createRadioButton(Composite pParent, String pButtonText, Image pButtonImage, String pButtonTooltip) {
        return this.getActiveWidgetFactory().createRadioButton(pParent, pButtonText, pButtonImage, pButtonTooltip);
    }

    public Button createCheckBox(Composite pParent, String pCheckBoxText, boolean pCheckBoxValue) {
        return this.getActiveWidgetFactory().createCheckBox(pParent, pCheckBoxText, pCheckBoxValue);
    }

    public Button[] createRadioButtonGroup(Composite pParent, String pTitle, String[] pRadioButtonText, int pSelectedItem, boolean pIsHorizontalFlag) {
        return this.getActiveWidgetFactory().createRadioButtonGroup(pParent, pTitle, pRadioButtonText, pSelectedItem, pIsHorizontalFlag);
    }

    public Text createTextField(Composite pParent, String pDefaultText, boolean pReadOnly) {
        return this.getActiveWidgetFactory().createTextField(pParent, pDefaultText, pReadOnly);
    }

    public Text createTextPane(Composite pParent, String pDefaultText, boolean pReadOnly, boolean pUseWordWrap) {
        return this.getActiveWidgetFactory().createTextPane(pParent, pDefaultText, pReadOnly, pUseWordWrap);
    }

    public Label createTextLabel(Composite pParent, String pLabelText) {
        return this.getActiveWidgetFactory().createTextLabel(pParent, pLabelText);
    }

    public Label createImageLabel(Composite pParent, Image pImage, boolean pBorderFlag) {
        return this.getActiveWidgetFactory().createImageLabel(pParent, pImage, pBorderFlag);
    }

    public Combo createComboBox(Composite pParent, String[] pItems, String pDefaultText, boolean pReadOnly) {
        return this.getActiveWidgetFactory().createComboBox(pParent, pItems, pDefaultText, pReadOnly);
    }

    public List createList(Composite pParent, String[] pItems, boolean enableMultipleSelection) {
        return this.getActiveWidgetFactory().createList(pParent, pItems, enableMultipleSelection);
    }

    public Composite createComposite(Composite pParent, boolean pBorderFlag) {
        return this.getActiveWidgetFactory().createComposite(pParent, pBorderFlag);
    }

    public Tree createTree(Composite pParent, boolean pBorderFlag, boolean pHScroll, boolean pVScroll, boolean pMultiSelect, boolean pCheckBox) {
        return this.getActiveWidgetFactory().createTree(pParent, pBorderFlag, pHScroll, pVScroll, pMultiSelect, pCheckBox);
    }

    public Table createTable(Composite pParent, boolean pBorderFlag, boolean pHScroll, boolean pVScroll, boolean pMultiSelect, boolean pHideSelect, boolean pFullSelect, boolean pCheckBox) {
        return this.getActiveWidgetFactory().createTable(pParent, pBorderFlag, pHScroll, pVScroll, pMultiSelect, pHideSelect, pFullSelect, pCheckBox);
    }

    public TableTree createTableTree(Composite pParent, boolean pBorderFlag, boolean pHScroll, boolean pVScroll, boolean pMultiSelect, boolean pFullSelect, boolean pCheckBox) {
        return this.getActiveWidgetFactory().createTableTree(pParent, pBorderFlag, pHScroll, pVScroll, pMultiSelect, pFullSelect, pCheckBox);
    }

    public Group createGroup(Composite pParent, boolean pBorderFlag) {
        return this.getActiveWidgetFactory().createGroup(pParent, pBorderFlag);
    }

    public SashForm createSashForm(Composite pParent, boolean pVertical) {
        return this.getActiveWidgetFactory().createSashForm(pParent, pVertical);
    }

    public ToolBar createToolBar(Composite pParent, boolean pVertical) {
        return this.getActiveWidgetFactory().createToolBar(pParent, pVertical);
    }

    public ToolItem createPushToolItem(ToolBar pParent) {
        return this.getActiveWidgetFactory().createPushToolItem(pParent);
    }

    public ToolItem createCheckToolItem(ToolBar pParent) {
        return this.getActiveWidgetFactory().createCheckToolItem(pParent);
    }

    public ToolItem createRadioToolItem(ToolBar pParent) {
        return this.getActiveWidgetFactory().createRadioToolItem(pParent);
    }

    public ToolItem createSeparatorToolItem(ToolBar pParent) {
        return this.getActiveWidgetFactory().createSeparatorToolItem(pParent);
    }

    public ViewForm createViewForm(Composite pParent) {
        return this.getActiveWidgetFactory().createViewForm(pParent);
    }

    public TabFolder createTabFolder(Composite pParent) {
        return this.getActiveWidgetFactory().createTabFolder(pParent);
    }

    public TabItem createTabItem(TabFolder pTabFolder) {
        return this.getActiveWidgetFactory().createTabItem(pTabFolder);
    }

    public PaintListener createFormTitlePaintListener(String title) {
        return this.getActiveWidgetFactory().createFormTitlePaintListener(title);
    }

    public PaintListener createSectionTitlePaintListener(String title) {
        return this.getActiveWidgetFactory().createSectionTitlePaintListener(title);
    }

    public int getActiveWidgetFactoryIndex() {
        if (this.activeWidgetFactoryIndex < 0) {
            IPreferenceStore preferenceStore = UtilPlugin.getInstance().getPreferenceStore();
            this.activeWidgetFactoryIndex = preferenceStore.getInt("editor widget factory index");
        }
        return this.activeWidgetFactoryIndex;
    }

    private IWidgetFactory getActiveWidgetFactory() {
        Object obj = this.widgetFactoryVector.get(this.getActiveWidgetFactoryIndex());
        if (obj == null) {
            obj = new DefaultWidgetFactory();
        }
        IWidgetFactory ret = (IWidgetFactory)obj;
        return ret;
    }

    public static EditorWidgetFactoryContainer getSingleton() {
        if (singleton == null) {
            singleton = new EditorWidgetFactoryContainer();
        }
        return singleton;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object obj;
        if ("editor widget factory index".equals(event.getProperty()) && (obj = event.getNewValue()) instanceof Integer) {
            this.setActiveWidgetFactoryIndex((Integer)obj);
        }
    }
}

