/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.lfsupport;

import com.tssap.util.ui.lfsupport.IWidgetFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;

public abstract class AbstractWidgetFactory
implements IWidgetFactory {
    public Button createPushButton(Composite pParent, String pButtonText, Image pButtonImage, String pButtonTooltip) {
        Button newButton = new Button(pParent, this.modifyStyle(8));
        newButton.setText(pButtonText);
        newButton.setImage(pButtonImage);
        newButton.setToolTipText(pButtonTooltip);
        return newButton;
    }

    public Button createToggleButton(Composite pParent, String pButtonText, Image pButtonImage, String pButtonTooltip) {
        Button newButton = new Button(pParent, this.modifyStyle(2));
        newButton.setText(pButtonText);
        newButton.setImage(pButtonImage);
        newButton.setToolTipText(pButtonTooltip);
        return newButton;
    }

    public Button createRadioButton(Composite pParent, String pButtonText, Image pButtonImage, String pButtonTooltip) {
        Button newButton = new Button(pParent, this.modifyStyle(16));
        newButton.setText(pButtonText);
        newButton.setImage(pButtonImage);
        newButton.setToolTipText(pButtonTooltip);
        return newButton;
    }

    public Button createCheckBox(Composite pParent, String pCheckBoxText, boolean pCheckBoxValue) {
        Button newCheckBox = new Button(pParent, this.modifyStyle(32));
        newCheckBox.setSelection(pCheckBoxValue);
        newCheckBox.setText(pCheckBoxText);
        return newCheckBox;
    }

    public Button[] createRadioButtonGroup(Composite pParent, String pTitle, String[] pRadioButtonText, int pSelectedItem, boolean pIsHorizontalFlag) {
        Group radioButtonGroup = new Group(pParent, this.modifyStyle(16));
        radioButtonGroup.setText(pTitle);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = pIsHorizontalFlag ? 256 : 512;
        radioButtonGroup.setLayout((Layout)fillLayout);
        Button[] retButton = new Button[pRadioButtonText.length];
        int b = 0;
        while (b < pRadioButtonText.length) {
            Button newRadioButton = new Button((Composite)radioButtonGroup, this.modifyStyle(16));
            newRadioButton.setText(pRadioButtonText[b]);
            if (b == pSelectedItem) {
                newRadioButton.setSelection(true);
            }
            retButton[b] = newRadioButton;
            ++b;
        }
        return retButton;
    }

    public Text createTextField(Composite pParent, String pDefaultText, boolean pReadOnly) {
        return this.createTextComponent(pParent, pDefaultText, pReadOnly, this.modifyStyle(2052));
    }

    public Text createTextPane(Composite pParent, String pDefaultText, boolean pReadOnly, boolean pWordWrap) {
        if (pWordWrap) {
            int localStyle = 2626;
            return this.createTextComponent(pParent, pDefaultText, pReadOnly, this.modifyStyle(localStyle));
        }
        int localStyle = 2818;
        return this.createTextComponent(pParent, pDefaultText, pReadOnly, this.modifyStyle(localStyle));
    }

    protected Text createTextComponent(Composite pParent, String pDefaultText, boolean pReadOnly, int pStyle) {
        int localStyle = pStyle;
        if (pReadOnly) {
            localStyle |= 8;
        }
        Text newText = new Text(pParent, this.modifyStyle(localStyle));
        newText.setText(pDefaultText);
        return newText;
    }

    public Label createTextLabel(Composite pParent, String pLabelText) {
        Label newLabel = new Label(pParent, this.modifyStyle(0));
        newLabel.setText(pLabelText);
        return newLabel;
    }

    public Combo createComboBox(Composite pParent, String[] pItems, String pDefaultText, boolean pReadOnly) {
        int localStyle = 4;
        if (pReadOnly) {
            localStyle |= 8;
        }
        Combo newCombo = new Combo(pParent, this.modifyStyle(localStyle));
        newCombo.setItems(pItems);
        newCombo.setText(pDefaultText);
        return newCombo;
    }

    public List createList(Composite pParent, String[] pItems, boolean enableMultipleSelection) {
        int localStyle = 2816;
        localStyle = enableMultipleSelection ? (localStyle |= 2) : (localStyle |= 4);
        List newList = new List(pParent, this.modifyStyle(localStyle));
        newList.setItems(pItems);
        return newList;
    }

    public Label createImageLabel(Composite pParent, Image pImage, boolean pBorderFlag) {
        int localStyle = 0;
        if (pBorderFlag) {
            localStyle = 2048;
        }
        Label newImageLabel = new Label(pParent, this.modifyStyle(localStyle));
        newImageLabel.setImage(pImage);
        return newImageLabel;
    }

    public Composite createComposite(Composite pParent, boolean pBorderFlag) {
        Composite ret = null;
        int localStyle = 0;
        if (pBorderFlag) {
            localStyle = 2048;
        }
        ret = new Composite(pParent, this.modifyStyle(localStyle));
        return ret;
    }

    public Group createGroup(Composite pParent, boolean pBorderFlag) {
        Group ret = null;
        int localStyle = 0;
        if (pBorderFlag) {
            localStyle = 16;
        }
        ret = new Group(pParent, this.modifyStyle(localStyle));
        return ret;
    }

    public SashForm createSashForm(Composite pParent, boolean pVertical) {
        SashForm ret = null;
        int style = 0;
        style = pVertical ? (style |= 0x200) : (style |= 0x100);
        ret = new SashForm(pParent, this.modifyStyle(style));
        return ret;
    }

    public TabFolder createTabFolder(Composite pParent) {
        TabFolder ret = new TabFolder(pParent, this.modifyStyle(0));
        return ret;
    }

    public TabItem createTabItem(TabFolder pTabFolder) {
        TabItem ret = new TabItem(pTabFolder, this.modifyStyle(0));
        return ret;
    }

    public ToolBar createToolBar(Composite pParent, boolean pVertical) {
        ToolBar ret = null;
        int style = 0x800040;
        style = pVertical ? (style |= 0x200) : (style |= 0x100);
        ret = new ToolBar(pParent, this.modifyStyle(style));
        return ret;
    }

    public ViewForm createViewForm(Composite pParent) {
        ViewForm ret = new ViewForm(pParent, this.modifyStyle(0));
        return ret;
    }

    public ToolItem createPushToolItem(ToolBar pParent) {
        ToolItem ret = null;
        int style = 8;
        ret = new ToolItem(pParent, this.modifyStyle(style));
        return ret;
    }

    public ToolItem createCheckToolItem(ToolBar pParent) {
        ToolItem ret = null;
        int style = 32;
        ret = new ToolItem(pParent, this.modifyStyle(style));
        return ret;
    }

    public ToolItem createRadioToolItem(ToolBar pParent) {
        ToolItem ret = null;
        int style = 16;
        ret = new ToolItem(pParent, this.modifyStyle(style));
        return ret;
    }

    public ToolItem createSeparatorToolItem(ToolBar pParent) {
        ToolItem ret = new ToolItem(pParent, this.modifyStyle(2));
        return ret;
    }

    protected int modifyStyle(int style) {
        return style;
    }

    public PaintListener createFormTitlePaintListener(String titleText) {
        return null;
    }

    public PaintListener createSectionTitlePaintListener(String titleText) {
        return null;
    }

    public TableTree createTableTree(Composite pParent, boolean pBorderFlag, boolean pHScroll, boolean pVScroll, boolean pMultiSelect, boolean pFullSelect, boolean pCheckBox) {
        TableTree ret = null;
        int localStyle = 0;
        if (pBorderFlag) {
            localStyle |= 0x800;
        }
        if (pHScroll) {
            localStyle |= 0x100;
        }
        if (pVScroll) {
            localStyle |= 0x200;
        }
        if (pMultiSelect) {
            localStyle |= 2;
        }
        if (pFullSelect) {
            localStyle |= 0x10000;
        }
        if (pCheckBox) {
            localStyle |= 0x20;
        }
        ret = new TableTree(pParent, this.modifyStyle(localStyle));
        return ret;
    }

    public Tree createTree(Composite pParent, boolean pBorderFlag, boolean pHScroll, boolean pVScroll, boolean pMultiSelect, boolean pCheckBox) {
        Tree ret = null;
        int localStyle = 0;
        if (pBorderFlag) {
            localStyle |= 0x800;
        }
        if (pHScroll) {
            localStyle |= 0x100;
        }
        if (pVScroll) {
            localStyle |= 0x200;
        }
        if (pMultiSelect) {
            localStyle |= 2;
        }
        if (pCheckBox) {
            localStyle |= 0x20;
        }
        ret = new Tree(pParent, this.modifyStyle(localStyle));
        return ret;
    }

    public Table createTable(Composite pParent, boolean pBorderFlag, boolean pHScroll, boolean pVScroll, boolean pMultiSelect, boolean pHideSelect, boolean pFullSelect, boolean pCheckBox) {
        Table ret = null;
        int localStyle = 0;
        if (pBorderFlag) {
            localStyle |= 0x800;
        }
        if (pHScroll) {
            localStyle |= 0x100;
        }
        if (pVScroll) {
            localStyle |= 0x200;
        }
        if (pMultiSelect) {
            localStyle |= 2;
        }
        if (pHideSelect) {
            localStyle |= 0x8000;
        }
        if (pFullSelect) {
            localStyle |= 0x10000;
        }
        if (pCheckBox) {
            localStyle |= 0x20;
        }
        ret = new Table(pParent, this.modifyStyle(localStyle));
        return ret;
    }
}

