/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.glpc.section;

import com.tssap.util.ui.glpc.section.IMenuProvider;
import com.tssap.util.ui.glpc.section.ITreeSection;
import com.tssap.util.ui.glpc.section.SectionWithButtons;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.viewer.tree.ISapTreeViewer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeModel;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeSection
extends SectionWithButtons
implements ITreeSection,
SelectionListener {
    private TreeModel mTreeModel = null;
    private ISapTreeViewer mTreeViewer = null;
    private TreeItem mSelection = null;
    private Menu mContextMenu = null;
    private Vector mMenuProviders = new Vector();

    public TreeSection(TreeModel treeModel, IWidgetFactory widgetFactory, String title, String description, String[] buttons) {
        this(treeModel, widgetFactory, title, description, buttons, null);
    }

    public TreeSection(TreeModel treeModel, IWidgetFactory widgetFactory, String title, String description, String[] buttons, boolean[] buttonsEnabled) {
        super(widgetFactory, 1, false, title, description, buttons, buttonsEnabled);
        this.mTreeModel = treeModel;
    }

    public TreeModel getTreeModel() {
        return this.mTreeModel;
    }

    public ISapTreeViewer getTreeViewer() {
        return this.mTreeViewer;
    }

    public void initButtonedSection(IGridLayoutPane glp) {
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, true, 1, 1);
        this.mTreeViewer = glp.addSapTreeViewer(this.mTreeModel, gd);
        this.mTreeViewer.getTree().addSelectionListener((SelectionListener)this);
        this.mContextMenu = new Menu((Control)this.mTreeViewer.getTree());
        this.mTreeViewer.getTree().setMenu(this.mContextMenu);
        this.mContextMenu.addMenuListener((MenuListener)new ContextMenuListener());
    }

    protected final void preInitButtonedSection(IGridLayoutPane glp) {
    }

    protected final void postInitButtonedSection(IGridLayoutPane glp) {
    }

    public void addSelectionListener(SelectionListener listener) {
        this.mTreeViewer.getTree().addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.mTreeViewer.getTree().removeSelectionListener(listener);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget instanceof Tree) {
            Tree tree = (Tree)e.widget;
            this.mSelection = tree.getSelection()[0];
        } else {
            super.widgetSelected(e);
        }
    }

    public void addMenuProvider(IMenuProvider provider) {
        this.mMenuProviders.add(provider);
    }

    public void removeMenuProvider(IMenuProvider provider) {
        this.mMenuProviders.remove(provider);
    }

    private class ContextMenuListener
    implements MenuListener {
        private ContextMenuListener() {
        }

        public void menuHidden(MenuEvent e) {
        }

        public void menuShown(MenuEvent e) {
            if (e.widget instanceof Menu) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                Enumeration enumeration = TreeSection.this.mMenuProviders.elements();
                while (enumeration.hasMoreElements()) {
                    IMenuProvider provider = (IMenuProvider)enumeration.nextElement();
                    provider.addItems(menu);
                }
            }
        }
    }
}

