/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.glpc.section;

import com.tssap.util.ui.glpc.section.IMenuProvider;
import com.tssap.util.ui.glpc.section.ITableSection;
import com.tssap.util.ui.glpc.section.SectionWithButtons;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.TableModel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableSection
extends SectionWithButtons
implements ITableSection,
SelectionListener {
    private TableModel mTableModel = null;
    private ISapTableViewer mTableViewer = null;
    private int mSelectedIndex = -1;
    private boolean mSingleSelection = false;
    private Menu mContextMenu = null;
    private Vector mMenuProviders = new Vector();
    private int[] mColumnWidths = null;

    public TableSection(TableModel tableModel, IWidgetFactory widgetFactory, String title, String description, String[] buttons) {
        this(tableModel, widgetFactory, title, description, buttons, null);
    }

    public TableSection(TableModel tableModel, IWidgetFactory widgetFactory, String title, String description, String[] buttons, boolean[] buttonsEnabled) {
        this(tableModel, widgetFactory, title, description, buttons, buttonsEnabled, false);
    }

    public TableSection(TableModel tableModel, IWidgetFactory widgetFactory, String title, String description, String[] buttons, boolean[] buttonsEnabled, boolean singleSelection) {
        super(widgetFactory, 1, false, title, description, buttons, buttonsEnabled);
        this.mTableModel = tableModel;
        this.mSingleSelection = singleSelection;
        this.initColumnWidths();
    }

    private void initColumnWidths() {
        this.mColumnWidths = new int[this.mTableModel.getColumnCount()];
        int i = 0;
        while (i < this.mColumnWidths.length) {
            this.mColumnWidths[i] = Integer.MAX_VALUE;
            ++i;
        }
    }

    public void setColumnWidths(int[] columnWidths) {
        int i = 0;
        while (i < columnWidths.length & i < this.mColumnWidths.length) {
            this.mColumnWidths[i] = columnWidths[i];
            ++i;
        }
    }

    public TableModel getTableModel() {
        return this.mTableModel;
    }

    public ISapTableViewer getTableViewer() {
        return this.mTableViewer;
    }

    public final void initButtonedSection(IGridLayoutPane glp) {
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, true);
        this.mTableViewer = glp.addSapTableViewer(this.mTableModel, gd, this.mSingleSelection);
        this.mTableViewer.getTable().addSelectionListener((SelectionListener)this);
        this.mContextMenu = new Menu((Control)this.mTableViewer.getTable());
        this.mTableViewer.getTable().setMenu(this.mContextMenu);
        this.mContextMenu.addMenuListener((MenuListener)new ContextMenuListener());
        int columnWidth = this.mTableViewer.getTable().getColumnCount();
        this.mTableViewer.getTable().addControlListener((ControlListener)new TableControlListener());
    }

    protected final void preInitButtonedSection(IGridLayoutPane glp) {
    }

    protected final void postInitButtonedSection(IGridLayoutPane glp) {
    }

    public void addSelectionListener(SelectionListener listener) {
        this.mTableViewer.getTable().addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.mTableViewer.getTable().removeSelectionListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.mTableViewer.getTable().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.mTableViewer.getTable().removeFocusListener(listener);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Table table;
        if (e.widget instanceof Table && (table = (Table)e.widget).equals(this.mTableViewer.getTable())) {
            this.mSelectedIndex = table.getSelectionIndex();
        }
        super.widgetSelected(e);
    }

    public void addMenuProvider(IMenuProvider provider) {
        this.mMenuProviders.add(provider);
    }

    public void removeMenuProvider(IMenuProvider provider) {
        this.mMenuProviders.remove(provider);
    }

    public int getSelectionIndex() {
        return this.mSelectedIndex;
    }

    public void setSelectionIndex(int index) {
        if (index > -1 && index < this.mTableViewer.getTable().getItemCount()) {
            this.mTableViewer.getTable().select(index);
            this.mSelectedIndex = index;
        }
    }

    private class TableControlListener
    implements ControlListener {
        private TableControlListener() {
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            if (e.widget instanceof Table) {
                Table table = (Table)e.widget;
                int tableWidth = table.getSize().x - 10;
                TableColumn[] columns = table.getColumns();
                int fixedColumnsWidhth = 0;
                int columnCount = table.getColumnCount();
                int i = 0;
                while (i < TableSection.this.mColumnWidths.length) {
                    if (TableSection.this.mColumnWidths[i] != Integer.MAX_VALUE) {
                        fixedColumnsWidhth += TableSection.this.mColumnWidths[i];
                        --columnCount;
                    }
                    ++i;
                }
                tableWidth -= fixedColumnsWidhth;
                int i2 = 0;
                while (i2 < columns.length) {
                    if (TableSection.this.mColumnWidths[i2] == Integer.MAX_VALUE) {
                        columns[i2].setWidth(tableWidth / columnCount);
                    } else {
                        columns[i2].setWidth(TableSection.this.mColumnWidths[i2]);
                    }
                    ++i2;
                }
            }
        }
    }

    private class ContextMenuListener
    implements MenuListener {
        private ContextMenuListener() {
        }

        public void menuHidden(MenuEvent e) {
        }

        public void menuShown(MenuEvent e) {
            Menu menu = (Menu)e.widget;
            if (e.widget instanceof Menu) {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
            }
            if (e.widget instanceof Menu) {
                Enumeration enumeration = TableSection.this.mMenuProviders.elements();
                while (enumeration.hasMoreElements()) {
                    IMenuProvider provider = (IMenuProvider)enumeration.nextElement();
                    provider.addItems(menu);
                }
            }
        }
    }
}

