/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.glpc.section;

import com.tssap.util.ui.glpc.section.AbstractSection;
import com.tssap.util.ui.glpc.section.ButtonClickedEvent;
import com.tssap.util.ui.glpc.section.IButtonClickedListener;
import com.tssap.util.ui.glpc.section.ISectionWithButtons;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

public abstract class SectionWithButtons
extends AbstractSection
implements ISectionWithButtons,
SelectionListener {
    private String[] mButtonNames = null;
    private boolean[] mButtonsEnabled = null;
    private Button[] mButtons = null;
    private Vector mButtonClickedListeners = new Vector();
    private int mColumns;
    private boolean mEqualSizedFlag;

    public SectionWithButtons(IWidgetFactory widgetFactory, int columns, String title, String description, String[] buttons) {
        this(widgetFactory, columns, false, title, description, buttons, null);
    }

    public SectionWithButtons(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title, String description, String[] buttons) {
        this(widgetFactory, columns, equalColumns, title, description, buttons, null);
    }

    public SectionWithButtons(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title, String description, String[] buttons, boolean[] buttonsEnabled) {
        super(widgetFactory, 2, false, title, description);
        this.mColumns = columns;
        this.mEqualSizedFlag = equalColumns;
        this.mButtonNames = buttons;
        this.mButtonsEnabled = buttonsEnabled;
        this.mButtons = new Button[this.mButtonNames.length];
    }

    public final void initSection(IGridLayoutPane glp) {
        this.preInitButtonedSection(glp);
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, true);
        IGridLayoutPane userArea = glp.addGridLayoutPane(this.mColumns, this.mEqualSizedFlag, gd);
        this.initButtonedSection(userArea);
        gd = glp.createGridLayoutData(4, 4, false, true);
        IGridLayoutPane buttonPane = glp.addGridLayoutPane(1, gd);
        int i = 0;
        while (i < this.mButtonNames.length) {
            gd = buttonPane.createGridLayoutData(4, 4, true, false);
            this.mButtons[i] = buttonPane.addPushButton(this.mButtonNames[i], gd);
            this.mButtons[i].addSelectionListener((SelectionListener)this);
            if (this.mButtonsEnabled != null && this.mButtonsEnabled.length > i) {
                this.mButtons[i].setEnabled(this.mButtonsEnabled[i]);
            } else {
                this.mButtons[i].setEnabled(true);
            }
            ++i;
        }
        this.postInitButtonedSection(glp);
    }

    protected void preInitButtonedSection(IGridLayoutPane glp) {
    }

    protected void postInitButtonedSection(IGridLayoutPane glp) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget instanceof Button) {
            Button button = (Button)e.widget;
            int i = 0;
            while (i < this.mButtons.length) {
                if (button.equals(this.mButtons[i])) {
                    this.raiseButtonClickedEvent(new ButtonClickedEvent(i));
                }
                ++i;
            }
        }
    }

    private void raiseButtonClickedEvent(ButtonClickedEvent e) {
        Enumeration enumeration = this.mButtonClickedListeners.elements();
        while (enumeration.hasMoreElements()) {
            IButtonClickedListener listener = (IButtonClickedListener)enumeration.nextElement();
            listener.buttonClicked(e);
        }
    }

    public void addButtonClickedListener(IButtonClickedListener listener) {
        this.mButtonClickedListeners.add(listener);
    }

    public void removeButtonClickedListener(IButtonClickedListener listener) {
        this.mButtonClickedListeners.remove(listener);
    }

    public void setButtonEnabled(int index, boolean enabled) {
        this.mButtons[index].setEnabled(enabled);
    }

    public abstract void initButtonedSection(IGridLayoutPane var1);
}

