/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.glpc.section;

import com.tssap.util.ui.glpc.AbstractTitledGridLayoutPaneContainer;
import com.tssap.util.ui.glpc.section.ISection;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.PaintListener;

public abstract class AbstractSection
extends AbstractTitledGridLayoutPaneContainer
implements ISection {
    private int mColumns = 0;
    private boolean mEqualColumns = false;

    public AbstractSection(IWidgetFactory widgetFactory, int columns, String title, String description) {
        this(widgetFactory, columns, false, title, description);
    }

    public AbstractSection(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title, String description) {
        super(widgetFactory, 1, false, title, description);
        this.mColumns = columns;
        this.mEqualColumns = equalColumns;
    }

    public final void initContainer(IGridLayoutPane glp) {
        this.preInitSection(glp);
        this.setTitleFont(JFaceResources.getBannerFont());
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, true);
        IGridLayoutPane userArea = glp.addGridLayoutPane(this.mColumns, this.mEqualColumns, gd);
        this.initSection(userArea);
        this.postInitSection(glp);
    }

    protected void preInitSection(IGridLayoutPane glp) {
    }

    protected void postInitSection(IGridLayoutPane glp) {
    }

    protected PaintListener getTitlePaintListener() {
        PaintListener ret = this.getWidgetFactory().createSectionTitlePaintListener(this.getTitle());
        return ret;
    }

    protected boolean isDescriptionVisible() {
        return true;
    }

    public abstract void initSection(IGridLayoutPane var1);
}

