/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.glpc.form;

import com.tssap.util.ui.glpc.AbstractTitledGridLayoutPaneContainer;
import com.tssap.util.ui.glpc.form.IForm;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.PaintListener;

public abstract class AbstractForm
extends AbstractTitledGridLayoutPaneContainer
implements IForm {
    private int mColumns = 0;
    private boolean mEqualColumns = false;

    public AbstractForm(IWidgetFactory widgetFactory, int columns, String title) {
        this(widgetFactory, columns, false, title);
    }

    public AbstractForm(IWidgetFactory widgetFactory, int columns, String title, String description) {
        this(widgetFactory, columns, false, title, description);
    }

    public AbstractForm(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title) {
        this(widgetFactory, columns, equalColumns, title, "");
    }

    public AbstractForm(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title, String description) {
        super(widgetFactory, 1, false, title, description);
        this.mColumns = columns;
        this.mEqualColumns = equalColumns;
    }

    public final void initContainer(IGridLayoutPane glp) {
        this.preInitForm(glp);
        this.setTitleFont(JFaceResources.getHeaderFont());
        this.setDescriptionFont(JFaceResources.getBannerFont());
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, true);
        IGridLayoutPane userArea = glp.addGridLayoutPane(this.mColumns, this.mEqualColumns, gd);
        this.initForm(userArea);
        this.postInitForm(glp);
    }

    protected void preInitForm(IGridLayoutPane glp) {
    }

    protected void postInitForm(IGridLayoutPane glp) {
    }

    protected PaintListener getTitlePaintListener() {
        PaintListener ret = this.getWidgetFactory().createFormTitlePaintListener(this.getTitle());
        return ret;
    }

    protected boolean isDescriptionVisible() {
        return false;
    }

    public int getColumns() {
        return this.mColumns;
    }

    public abstract void initForm(IGridLayoutPane var1);
}

