/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.glpc;

import com.tssap.util.ui.glpc.AbstractGridLayoutPaneContainer;
import com.tssap.util.ui.glpc.ITitledGridLayoutPaneContainer;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class AbstractTitledGridLayoutPaneContainer
extends AbstractGridLayoutPaneContainer
implements ITitledGridLayoutPaneContainer {
    private String title;
    private String description;
    private Label titleLabel;
    private Label descriptionLabel;
    public static final String DEFAULT_TITLE = "";
    public static final String DEFAULT_DESCRIPTION = "";
    private static final int DESCRIPTION_DISTANCE = 1;

    public AbstractTitledGridLayoutPaneContainer(IWidgetFactory widgetFactory, int columns) {
        this(widgetFactory, columns, "");
    }

    public AbstractTitledGridLayoutPaneContainer(IWidgetFactory widgetFactory, int columns, boolean equalColumns) {
        this(widgetFactory, columns, equalColumns, "");
    }

    public AbstractTitledGridLayoutPaneContainer(IWidgetFactory widgetFactory, int columns, String title) {
        this(widgetFactory, columns, title, "");
    }

    public AbstractTitledGridLayoutPaneContainer(IWidgetFactory widgetFactory, int columns, String title, String description) {
        this(widgetFactory, columns, false, title, description);
    }

    public AbstractTitledGridLayoutPaneContainer(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title) {
        this(widgetFactory, columns, equalColumns, title, "");
    }

    public AbstractTitledGridLayoutPaneContainer(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title, String description) {
        super(widgetFactory, columns, equalColumns);
        this.setTitle(title);
        this.setDescription(description);
    }

    protected void preInitContainer(IGridLayoutPane outerPane) {
        Composite composite;
        IGridLayoutPane titleArea = outerPane.addGridLayoutPane(1, outerPane.createGridLayoutData(4, 4, true, false, 3, 1));
        titleArea.setMargin(0, 0);
        if (this.isDescriptionVisible()) {
            titleArea.setSpacing(0, 10);
        } else {
            titleArea.setSpacing(0, 0);
        }
        String titleText = this.getTitle();
        this.titleLabel = titleArea.addTextLabel(titleText);
        String descriptionText = this.getDescription();
        this.descriptionLabel = titleArea.addTextLabel(descriptionText);
        this.descriptionLabel.setVisible(this.isDescriptionVisible());
        PaintListener pl = this.getTitlePaintListener();
        if (pl != null && (composite = titleArea.getComposite()) != null) {
            composite.addPaintListener(pl);
            this.titleLabel.setVisible(false);
        }
    }

    protected PaintListener getTitlePaintListener() {
        return null;
    }

    protected IGridLayoutPane prepareContainer(IGridLayoutPane outerPane) {
        IGridLayoutPane userArea = outerPane.addGridLayoutPane(this.getUserGridNumOfColumns(), this.isUserGridEqualColSize(), outerPane.createGridLayoutData(4, 4, true, true, 3, 1));
        return userArea;
    }

    protected void postInitContainer(IGridLayoutPane outerPane) {
    }

    public String getTitle() {
        String ret = this.title;
        return ret;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.title = title;
        if (this.getTitleLabel() != null) {
            this.getTitleLabel().setText(title);
            AbstractTitledGridLayoutPaneContainer.updateLabel(this.getTitleLabel());
        }
    }

    public String getDescription() {
        String ret = this.description;
        return ret;
    }

    public void setDescription(String description) {
        if (description == null) {
            description = "";
        }
        this.description = description;
        if (this.getDescriptionLabel() != null) {
            this.getDescriptionLabel().setText(description);
            AbstractTitledGridLayoutPaneContainer.updateLabel(this.getDescriptionLabel());
        }
    }

    protected void setTitleFont(Font font) {
        this.getTitleLabel().setFont(font);
        AbstractTitledGridLayoutPaneContainer.updateLabel(this.getTitleLabel());
    }

    protected Font getTitleFont() {
        Font ret = this.getTitleLabel().getFont();
        return ret;
    }

    protected void setDescriptionFont(Font font) {
        if (this.getDescriptionLabel() != null) {
            this.getDescriptionLabel().setFont(font);
            AbstractTitledGridLayoutPaneContainer.updateLabel(this.getDescriptionLabel());
        }
    }

    protected Font getDescriptionFont() {
        Font ret = null;
        if (this.getDescriptionLabel() != null) {
            ret = this.getDescriptionLabel().getFont();
        }
        return ret;
    }

    private Label getDescriptionLabel() {
        return this.descriptionLabel;
    }

    private Label getTitleLabel() {
        return this.titleLabel;
    }

    private static void updateLabel(Label label) {
        if (label != null) {
            if (label.getText().length() >= 0) {
                AbstractTitledGridLayoutPaneContainer.resizeControl((Control)label);
            } else {
                AbstractTitledGridLayoutPaneContainer.disappearControl((Control)label);
            }
        }
    }

    private static void resizeControl(Control control) {
        if (control != null) {
            control.pack();
        }
    }

    private static void disappearControl(Control control) {
        if (control != null) {
            control.setSize(0, 0);
        }
    }

    protected boolean isDescriptionVisible() {
        return true;
    }
}

