/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.glpc;

import com.tssap.util.ui.AbstractEditable;
import com.tssap.util.ui.glpc.ContainerFrameworkException;
import com.tssap.util.ui.glpc.IGridLayoutPaneContainer;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;

public abstract class AbstractGridLayoutPaneContainer
extends AbstractEditable
implements IGridLayoutPaneContainer {
    public static final boolean USER_GRID_DEFAULT_EQUAL_SIZE_FLAG = false;
    protected static final int OUTER_GRID_NUM_OF_COLUMNS = 3;
    private int userGridNumOfColumns;
    private boolean userGridEqualColSizeFlag;
    private IWidgetFactory widgetFactory;
    private IGridLayoutPane userAreaGridLayoutPane = null;

    private AbstractGridLayoutPaneContainer() {
    }

    public AbstractGridLayoutPaneContainer(IWidgetFactory widgetFactory, int userAreaColumns) {
        this(widgetFactory, userAreaColumns, false);
    }

    public AbstractGridLayoutPaneContainer(IWidgetFactory widgetFactory, int userGridColumns, boolean userGridEqualColSize) {
        this.widgetFactory = widgetFactory;
        this.userGridNumOfColumns = userGridColumns;
        this.userGridEqualColSizeFlag = userGridEqualColSize;
    }

    public int getUserGridNumOfColumns() {
        return this.userGridNumOfColumns;
    }

    public boolean isUserGridEqualColSize() {
        return this.userGridEqualColSizeFlag;
    }

    public void composeGridLayoutPaneContainer(IGridLayoutPane parentPane, IWidgetFactory widgetFactory, IGridLayoutData layoutData) {
        if (!this.isComposable()) {
            throw new ContainerFrameworkException("Container already composed!");
        }
        IGridLayoutPane outerGridLayoutPane = parentPane.addGridLayoutPane(3, layoutData);
        outerGridLayoutPane.setMargin(0, 0);
        this.preInitContainer(outerGridLayoutPane);
        IGridLayoutPane userArea = this.prepareContainer(outerGridLayoutPane);
        this.setUserAreaGridLayoutPane(userArea);
        this.initContainer(userArea);
        this.postInitContainer(outerGridLayoutPane);
    }

    protected abstract void preInitContainer(IGridLayoutPane var1);

    protected abstract IGridLayoutPane prepareContainer(IGridLayoutPane var1);

    protected abstract void postInitContainer(IGridLayoutPane var1);

    public IGridLayoutPane getUserAreaGridLayoutPane() {
        return this.userAreaGridLayoutPane;
    }

    private boolean setUserAreaGridLayoutPane(IGridLayoutPane userAreaGridLayoutPane) {
        boolean ret = false;
        if (this.getUserAreaGridLayoutPane() == null) {
            this.userAreaGridLayoutPane = userAreaGridLayoutPane;
            ret = true;
        }
        return ret;
    }

    public boolean isComposable() {
        boolean ret = this.getUserAreaGridLayoutPane() == null;
        return ret;
    }

    public IWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public abstract void initContainer(IGridLayoutPane var1);
}

