/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.dialog;

import com.tssap.util.core.IFilter;
import com.tssap.util.ui.reuse.tree.LogicalCheckedTreeViewer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class StructuredObjectSelectionDialog
extends SelectionDialog {
    public static final int TREELOGIC_NONE = 0;
    public static final int TREELOGIC_TYPE1 = 1;
    public static final int TREELOGIC_TYPE2 = 2;
    public static final int TREELOGIC_TYPE3 = 3;
    public static final int TREELOGIC_TYPE4 = 4;
    public static final int TREELOGIC_TYPE5 = 5;
    private static final Object[] EMPTY_OBJ_AR = new Object[0];
    private static final int SEL_TYPE_SELEL = 0;
    private static final int SEL_TYPE_LEAVES = 1;
    private static final int SEL_TYPE_ALL = 2;
    private static final int SEL_TYPE_FILTER = 3;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
    private Shell parentShell;
    private String title;
    private String message;
    private LogicalCheckedTreeViewer myTreeViewer;
    private ILabelProvider myLabelProvider;
    private ITreeContentProvider myTreeContentProvider;
    private Object treeInput;
    private Object[] preSelection = EMPTY_OBJ_AR;
    private ArrayList selectableElements;
    private int type;
    private IFilter filter;
    private int checkedTreeLogic;
    private Object[] pregrayedElements;
    private int myExpandLevel;

    protected StructuredObjectSelectionDialog(Shell parentShell) {
        this(parentShell, "Object Selector", "");
    }

    public StructuredObjectSelectionDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        super.setTitle(title);
        super.setMessage(message);
    }

    public Object[] openDialog(ITreeContentProvider tcp, Object[] selectableElements) {
        return this.openDialog(tcp, selectableElements, 0);
    }

    public Object[] openDialog(ITreeContentProvider tcp, boolean returnLeaves) {
        return this.openDialog(tcp, returnLeaves, 0);
    }

    public Object[] openDialog(ITreeContentProvider tcp, IFilter filter) {
        return this.openDialog(tcp, filter, 0);
    }

    public Object[] openDialog(ITreeContentProvider tcp, Object[] selectableElements, int treeLogicType) {
        this.setTreeContentProvider(tcp);
        this.setCheckedTreeLogic(treeLogicType);
        this.setSelectableElements(selectableElements);
        this.type = 0;
        return this.internalOpen();
    }

    public Object[] openDialog(ITreeContentProvider tcp, boolean returnLeaves, int treeLogicType) {
        this.setTreeContentProvider(tcp);
        this.setCheckedTreeLogic(treeLogicType);
        this.type = returnLeaves ? 1 : 2;
        return this.internalOpen();
    }

    public Object[] openDialog(ITreeContentProvider tcp, IFilter filter, int treeLogicType) {
        this.setTreeContentProvider(tcp);
        this.setCheckedTreeLogic(treeLogicType);
        this.setFilter(filter);
        this.type = 3;
        return this.internalOpen();
    }

    public Object[] openPreFilteredDialog(ITreeContentProvider tcp, Object[] unselectableElements) {
        this.setTreeContentProvider(tcp);
        this.setCheckedTreeLogic(3);
        this.type = 2;
        this.pregrayedElements = unselectableElements;
        Object[] ret = this.internalOpen();
        this.pregrayedElements = null;
        return ret;
    }

    public Object[] openPreFilteredSingleSiblingDialog(ITreeContentProvider tcp, Object[] unselectableElements) {
        this.setTreeContentProvider(tcp);
        this.setCheckedTreeLogic(4);
        this.type = 2;
        this.pregrayedElements = unselectableElements;
        Object[] ret = this.internalOpen();
        this.pregrayedElements = null;
        return ret;
    }

    private Object[] internalOpen() {
        int pressed = super.open();
        Object[] ret = pressed != 0 ? null : this.getResult();
        return ret;
    }

    public void setLabelProvider(ILabelProvider lProvider) {
        this.myLabelProvider = lProvider;
    }

    private void setTreeContentProvider(ITreeContentProvider lProvider) {
        this.myTreeContentProvider = lProvider;
    }

    public ITreeContentProvider getContentProvider() {
        return this.myTreeContentProvider;
    }

    public void setPreSelectedObjects(Object[] selectedObjs) {
        if (selectedObjs != null) {
            this.preSelection = selectedObjs;
        }
    }

    public void setPreGrayedObjects(Object[] grayedObjs) {
        if (grayedObjs != null) {
            this.pregrayedElements = grayedObjs;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.createTreeViewer(composite);
        return composite;
    }

    private void createTreeViewer(Composite parent) {
        int treeStyle = 68352;
        CheckboxTreeViewer checktv = new CheckboxTreeViewer(parent, treeStyle);
        this.myTreeViewer = new LogicalCheckedTreeViewer(checktv);
        this.myTreeViewer.setSelectionLogicType(this.getCheckedTreeLogic());
        GridData data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 300;
        this.myTreeViewer.getCheckboxTreeViewer().getTree().setLayoutData((Object)data);
        this.myTreeViewer.setContentProvider(this.getContentProvider());
        this.myTreeViewer.getCheckboxTreeViewer().setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.myTreeViewer.getCheckboxTreeViewer().setInput(this.getTreeInput());
        switch (this.type) {
            case 3: {
                this.myTreeViewer.setResultFilter(this.getFilter());
                break;
            }
            case 1: {
                this.myTreeViewer.setResultFilterType(1);
                break;
            }
            case 0: {
                this.myTreeViewer.setResultFilter(new SelectableElementFilter());
                break;
            }
        }
        this.myTreeViewer.preCheckElements(this.preSelection);
        if (this.pregrayedElements != null) {
            this.myTreeViewer.preGrayedElements(this.pregrayedElements);
        }
        this.myTreeViewer.expandToLevel(this.getExpandLevel());
    }

    private int getExpandLevel() {
        return this.myExpandLevel;
    }

    public void setExpandTreeLevel(int level) {
        this.myExpandLevel = level;
        if (this.myTreeViewer != null) {
            this.myTreeViewer.expandToLevel(level);
        }
    }

    private int getCheckedTreeLogic() {
        return this.checkedTreeLogic;
    }

    private void setCheckedTreeLogic(int treeLogic) {
        this.checkedTreeLogic = treeLogic;
        if (this.myTreeViewer != null) {
            this.myTreeViewer.setSelectionLogicType(treeLogic);
        }
    }

    private Object getTreeInput() {
        return this.treeInput;
    }

    public void setTreeInput(Object treeContentProviderInput) {
        this.treeInput = treeContentProviderInput;
    }

    public void refreshTreeViewer() {
        if (this.myTreeViewer != null) {
            this.myTreeViewer.refreshTreeViewer();
        }
    }

    private ILabelProvider getLabelProvider() {
        if (this.myLabelProvider == null) {
            this.myLabelProvider = new LabelProvider();
        }
        return this.myLabelProvider;
    }

    public Object[] getResult() {
        return this.myTreeViewer.getFilteredSelection();
    }

    private ArrayList getSelectableElements() {
        if (this.selectableElements == null) {
            this.selectableElements = new ArrayList();
        }
        return this.selectableElements;
    }

    private void setSelectableElements(Object[] selectableElements) {
        this.getSelectableElements().clear();
        this.getSelectableElements().addAll(Arrays.asList(selectableElements));
    }

    protected IFilter getFilter() {
        return this.filter;
    }

    protected void setFilter(IFilter filter) {
        this.filter = filter;
    }

    class SelectableElementFilter
    implements IFilter {
        SelectableElementFilter() {
        }

        public boolean accept(Object o) {
            return StructuredObjectSelectionDialog.this.getSelectableElements().contains(o);
        }
    }
}

