/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.dialog;

import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceChooserDialog
extends Dialog {
    private boolean filesOnlyChooser;
    private String title;
    private String message;
    protected TreeViewer viewer;
    private IResource currentResource;
    private ArrayList resourceFilter = new ArrayList();
    private IContainer root;
    private IResource defaultSelection;
    private IProject[] rootProjects;

    public ResourceChooserDialog(Shell parentShell, String title, String msg) {
        this(parentShell, title, msg, false);
    }

    public ResourceChooserDialog(Shell parentShell, String title, String msg, boolean filesOnly) {
        super(parentShell);
        this.title = title;
        this.message = msg;
        this.filesOnlyChooser = filesOnly;
    }

    public int open() {
        return super.open();
    }

    public int open(IContainer root, IResource defaultSelection) {
        this.root = root;
        this.defaultSelection = defaultSelection;
        return super.open();
    }

    public int open(IProject[] rootProjects, IResource defaultSelection) {
        this.addResourceFilter(new ProjectFilter(rootProjects));
        this.defaultSelection = defaultSelection;
        return super.open();
    }

    public void addResourceFilter(ViewerFilter filter) {
        ((AbstractCollection)this.resourceFilter).remove(filter);
        this.resourceFilter.add(filter);
        if (this.viewer != null) {
            this.viewer.addFilter(filter);
        }
    }

    public void removeFilter(ViewerFilter filter) {
        ((AbstractCollection)this.resourceFilter).remove(filter);
        if (this.viewer != null) {
            this.viewer.removeFilter(filter);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public IResource getSelectedResource() {
        return this.currentResource;
    }

    protected Control createDialogArea(Composite parent) {
        IGridLayoutPane pane = PaneFactory.createGridLayoutPane(parent, 1);
        this.viewer = pane.addTreeViewer(false);
        GridData data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 300;
        this.viewer.getTree().setLayoutData((Object)data);
        this.decorateViewer(this.viewer);
        if (this.root != null) {
            this.viewer.setInput((Object)this.root);
        } else {
            this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        }
        if (this.defaultSelection instanceof IResource) {
            this.viewer.reveal((Object)this.defaultSelection);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.defaultSelection));
            this.currentResource = this.defaultSelection;
        }
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new MySelectionChangeListener());
        return pane.getComposite();
    }

    protected void selectionHasChanged(IResource currentResource) {
        if (this.filesOnlyChooser) {
            if (currentResource instanceof IFile) {
                this.getButton(0).setEnabled(true);
            } else {
                this.getButton(0).setEnabled(false);
            }
        }
    }

    private void decorateViewer(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        int i = 0;
        while (i < this.resourceFilter.size()) {
            viewer.addFilter((ViewerFilter)this.resourceFilter.get(i));
            ++i;
        }
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    class ProjectFilter
    extends ViewerFilter {
        private ArrayList allowedPrj;

        public ProjectFilter(IProject[] prj) {
            this.allowedPrj = new ArrayList<IProject>(Arrays.asList(prj));
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean ret = true;
            if (element instanceof IProject) {
                ret = this.allowedPrj.contains(element);
            }
            return ret;
        }
    }

    class MySelectionChangeListener
    implements ISelectionChangedListener {
        MySelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TreeItem[] selItems = ResourceChooserDialog.this.viewer.getTree().getSelection();
            if (selItems != null && selItems.length > 0 && selItems[0].getData() instanceof IResource) {
                ResourceChooserDialog.this.currentResource = (IResource)selItems[0].getData();
            }
            ResourceChooserDialog.this.selectionHasChanged(ResourceChooserDialog.this.currentResource);
        }
    }
}

