/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.dialog;

import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ObjectSelectionDialog
extends SelectionDialog {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 150;
    private Shell parentShell;
    private TableViewer myTableViewer;
    private MyDefaultContentProvider myContentProvider = new MyDefaultContentProvider();
    private ILabelProvider myLabelProvider = new MyDefaultLableProvider();
    private boolean isSingleSelectionEnabled = true;
    private ViewerSorter mySorter;

    protected ObjectSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public ObjectSelectionDialog(Shell parentShell, String title, String message) {
        this(parentShell);
        super.setTitle(title);
        super.setMessage(message);
    }

    public Object[] openDialog(Object[] selectableElements) {
        this.myContentProvider.setElements(selectableElements);
        int pressed = super.open();
        if (pressed != 0) {
            super.setResult(null);
        }
        return super.getResult();
    }

    public void setLabelProvider(ILabelProvider lProvider) {
        this.myLabelProvider = lProvider;
        if (this.myTableViewer != null && this.myLabelProvider != null) {
            this.myTableViewer.setLabelProvider((IBaseLabelProvider)lProvider);
        }
    }

    public void setObjectSorter(ViewerSorter viewerSorter) {
        this.mySorter = viewerSorter;
        if (this.myTableViewer != null) {
            this.myTableViewer.setSorter(viewerSorter);
        }
    }

    public void setSingleSelection(boolean singleSelection) {
        this.isSingleSelectionEnabled = singleSelection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.createListViewer(composite);
        return composite;
    }

    private void createListViewer(Composite parent) {
        Object[] content;
        int tableStyle = 68352;
        if (this.isSingleSelectionEnabled) {
            this.myTableViewer = new TableViewer(parent, tableStyle |= 4);
            this.myTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ObjectSelectionDialog.this.handleDoubleClickInSingleSelection(event);
                }
            });
            this.myTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ObjectSelectionDialog.this.handleSelectionChanged();
                }
            });
        } else {
            this.myTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)(tableStyle |= 2));
            ((CheckboxTableViewer)this.myTableViewer).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ObjectSelectionDialog.this.handleCheckStateChanged();
                }
            });
        }
        GridData data = new GridData(1808);
        data.widthHint = 400;
        data.heightHint = 150;
        this.myTableViewer.getTable().setLayoutData((Object)data);
        this.myTableViewer.setContentProvider((IContentProvider)this.myContentProvider);
        if (this.myLabelProvider != null) {
            this.myTableViewer.setLabelProvider((IBaseLabelProvider)this.myLabelProvider);
        }
        this.myTableViewer.setSorter(this.mySorter);
        this.myTableViewer.setInput((Object)"");
        if (this.isSingleSelectionEnabled && (content = this.myContentProvider.getElements("")).length > 0) {
            this.myTableViewer.setSelection((ISelection)new StructuredSelection(new Object[]{content[0]}));
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.isSingleSelectionEnabled) {
            this.handleSelectionChanged();
        } else {
            this.handleCheckStateChanged();
        }
    }

    protected void handleCheckStateChanged() {
        Button okBut = this.getButton(0);
        if (okBut != null) {
            if (((CheckboxTableViewer)this.myTableViewer).getCheckedElements().length > 0) {
                okBut.setEnabled(true);
            } else {
                okBut.setEnabled(false);
            }
        }
        this.updateSelectedElements();
    }

    protected void handleSelectionChanged() {
        Button okBut = this.getButton(0);
        if (okBut != null) {
            if (this.myTableViewer.getTable().getSelection().length > 0) {
                okBut.setEnabled(true);
            } else {
                okBut.setEnabled(false);
            }
        }
        this.updateSelectedElements();
    }

    protected void handleDoubleClickInSingleSelection(DoubleClickEvent event) {
        Button okBut = this.getButton(0);
        if (okBut != null && okBut.isEnabled()) {
            this.okPressed();
        }
    }

    private void updateSelectedElements() {
        Object[] selection;
        if (this.myTableViewer instanceof CheckboxTableViewer) {
            selection = ((CheckboxTableViewer)this.myTableViewer).getCheckedElements();
        } else {
            int[] selIndex = this.myTableViewer.getTable().getSelectionIndices();
            selection = new Object[selIndex.length];
            int i = 0;
            while (i < selIndex.length) {
                selection[i] = this.myTableViewer.getElementAt(selIndex[i]);
                ++i;
            }
        }
        super.setSelectionResult(selection);
    }

    static class MyDefaultContentProvider
    implements IStructuredContentProvider {
        private static final Object[] EMPTY_ELEMENTS = new Object[0];
        private Object[] myElements = EMPTY_ELEMENTS;

        MyDefaultContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.myElements;
        }

        public void setElements(Object[] myElements) {
            this.myElements = myElements != null ? myElements : EMPTY_ELEMENTS;
        }
    }

    static class MyDefaultLableProvider
    extends LabelProvider {
        MyDefaultLableProvider() {
        }

        public Image getImage(Object element) {
            return SapIdeUtilImages.getSapImage(SapImage.ICON_ACTIVATE);
        }
    }
}

