/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.dialog;

import com.tssap.util.UtilPlugin;
import com.tssap.util.ui.dialog.ILogonInformation;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;

public class LogonDialog
extends MessageDialog {
    private static final int USER_SHOW_AND_EDIT = 0;
    private static final int USER_SHOW_READONLY = 1;
    private static final int USER_HIDE = 2;
    private static final int PASSWORD_SHOW_AND_EDIT = 0;
    private static final int PASSWORD_MASK_AND_EDIT = 1;
    private static final String DEFAULT_USER = "";
    private static final String DEFAULT_PASSWORD = "";
    private static final char MASK_CHARACTER = '*';
    private static final String[] BUTTONS = new String[]{"OK", "Cancel"};
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private int usrSpec;
    private String defaultUsr;
    private int pwdSpec;
    private String defaultPwd;
    private Text userTextField;
    private Text passwordTextField;
    private String user;
    private String password;

    private LogonDialog(Shell parentShell, String title, String message, String defaultUser, int userSpec, String defaultPassword, int passwordSpec) {
        super(parentShell, title, null, message, 3, BUTTONS, 0);
        this.usrSpec = userSpec;
        this.defaultUsr = defaultUser;
        this.pwdSpec = passwordSpec;
        this.defaultPwd = defaultPassword;
    }

    private static Shell getUsableShell() {
        Shell shell = null;
        IWorkbenchWindow activeWbWindow = UtilPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        if (activeWbWindow != null) {
            shell = activeWbWindow.getShell();
        }
        return shell;
    }

    public static ILogonInformation getUserAndPassword(String title, String message) {
        return LogonDialog.getUserAndPassword(title, message, "");
    }

    public static ILogonInformation getUserAndPassword(String title, String message, String defaultUser) {
        return LogonDialog.getUserAndPassword(title, message, defaultUser, "");
    }

    public static ILogonInformation getUserAndPassword(String title, String message, String defaultUserName, String defaultPassword) {
        LogonDialog logonDiad = new LogonDialog(LogonDialog.getUsableShell(), title, message, defaultUserName, 0, defaultPassword, 1);
        return LogonDialog.displayDialog(logonDiad);
    }

    public static ILogonInformation getPasswordForUser(String title, String message, String userName) {
        return LogonDialog.getPasswordForUser(title, message, userName, "");
    }

    public static ILogonInformation getPasswordForUser(String title, String message, String userName, String defaultPassword) {
        LogonDialog logonDiad = new LogonDialog(LogonDialog.getUsableShell(), title, message, userName, 1, defaultPassword, 1);
        return LogonDialog.displayDialog(logonDiad);
    }

    public static ILogonInformation getPasswordOnly(String title, String message) {
        return LogonDialog.getPasswordOnly(title, message, "");
    }

    public static ILogonInformation getPasswordOnly(String title, String message, String defaultPassword) {
        LogonDialog logonDiad = new LogonDialog(LogonDialog.getUsableShell(), title, message, "", 2, defaultPassword, 1);
        return LogonDialog.displayDialog(logonDiad);
    }

    public static ILogonInformation getUserAndPassword(Shell parent, String title, String message) {
        return LogonDialog.getUserAndPassword(parent, title, message, "");
    }

    public static ILogonInformation getUserAndPassword(Shell parent, String title, String message, String defaultUser) {
        return LogonDialog.getUserAndPassword(parent, title, message, defaultUser, "");
    }

    public static ILogonInformation getUserAndPassword(Shell parent, String title, String message, String defaultUserName, String defaultPassword) {
        LogonDialog logonDiad = new LogonDialog(parent, title, message, defaultUserName, 0, defaultPassword, 1);
        return LogonDialog.displayDialog(logonDiad);
    }

    public static ILogonInformation getPasswordForUser(Shell parent, String title, String message, String userName) {
        return LogonDialog.getPasswordForUser(parent, title, message, userName, "");
    }

    public static ILogonInformation getPasswordForUser(Shell parent, String title, String message, String userName, String defaultPassword) {
        LogonDialog logonDiad = new LogonDialog(parent, title, message, userName, 1, defaultPassword, 1);
        return LogonDialog.displayDialog(logonDiad);
    }

    public static ILogonInformation getPasswordOnly(Shell parent, String title, String message) {
        return LogonDialog.getPasswordOnly(parent, title, message, "");
    }

    public static ILogonInformation getPasswordOnly(Shell parent, String title, String message, String defaultPassword) {
        LogonDialog logonDiad = new LogonDialog(parent, title, message, "", 2, defaultPassword, 1);
        return LogonDialog.displayDialog(logonDiad);
    }

    private static ILogonInformation displayDialog(LogonDialog diag) {
        LogonInformation logInf = null;
        diag.open();
        if (diag.getReturnCode() == 0) {
            logInf = new LogonInformation();
            if (diag.user != null) {
                logInf.setUserName(diag.user);
            }
            if (diag.password != null) {
                logInf.setPassword(diag.password);
            }
        }
        return logInf;
    }

    protected Control createCustomArea(Composite parent) {
        parent.setLayout((Layout)new RowLayout());
        Composite customComposite = new Composite(parent, 0);
        customComposite.setLayoutData((Object)new RowData(400, 50));
        customComposite.setLayout((Layout)new FillLayout());
        IGridLayoutPane windowGrid = PaneFactory.createGridLayoutPane(customComposite, 2);
        if (this.usrSpec != 2) {
            windowGrid.addTextLabel("User ");
            boolean readOnlyFlag = this.usrSpec == 1;
            this.userTextField = windowGrid.addTextField(this.defaultUsr, readOnlyFlag, windowGrid.createGridLayoutData(4, 1, true, false));
        }
        windowGrid.addTextLabel("Password ");
        this.passwordTextField = windowGrid.addTextField(this.defaultPwd, windowGrid.createGridLayoutData(4, 1, true, false));
        this.passwordTextField.setEchoChar('*');
        return customComposite;
    }

    public boolean close() {
        if (this.userTextField != null) {
            this.user = this.userTextField.getText();
        }
        if (this.passwordTextField != null) {
            this.password = this.passwordTextField.getText();
        }
        return super.close();
    }

    private static class LogonInformation
    implements ILogonInformation {
        private String userName = null;
        private String password = null;

        private LogonInformation() {
        }

        public String getPassword() {
            return this.password;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setPassword(String string) {
            this.password = string;
        }

        public void setUserName(String string) {
            this.userName = string;
        }
    }
}

