/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.dialog;

import com.tssap.util.UtilPlugin;
import com.tssap.util.ui.dialog.ResourceChooserDialog;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.reuse.chooser.impl.FileExtensionFilter;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class ImageChooserDialog
extends ResourceChooserDialog {
    private final Image EMPTY_IMAGE = new Image((Device)Display.getCurrent(), 1, 1);
    private Image currentPrevImg;
    private IFile currSelFile;
    private Label imgLabel;
    private Label txtLabel;
    private Button okButton;
    static /* synthetic */ Class class$com$tssap$util$ui$dialog$ImageChooserDialog;

    public ImageChooserDialog(Shell parentShell) {
        super(parentShell, "IconChooser", "Choose an Icon");
    }

    protected IFile getCurrentSelectedImgFile() {
        return this.currSelFile;
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        this.createPreviewGroup(parent);
        this.addResourceFilter(new FileExtensionFilter(new String[]{"gif", "jpg", "jpeg"}));
        parent.addDisposeListener((DisposeListener)new ImgChooseDisposeListener());
        return parent;
    }

    private void createPreviewGroup(Composite parent) {
        IGridLayoutPane prevPane = PaneFactory.createGridLayoutPane(parent, 3);
        GridData gd = new GridData();
        gd.horizontalAlignment = 256;
        gd.verticalAlignment = 16;
        gd.horizontalSpan = 3;
        prevPane.setLayoutData(gd);
        IGridLayoutData gld = prevPane.createGridLayoutData(4, 4, true, true);
        prevPane.addTextLabel("Preview: ");
        this.imgLabel = prevPane.addImage(this.EMPTY_IMAGE);
        gd = new GridData();
        gd.widthHint = 32;
        gd.heightHint = 32;
        this.imgLabel.setLayoutData((Object)gd);
        this.txtLabel = prevPane.addTextLabel("                                                 ", gld);
        this.initialUpdatePrefviewPane();
    }

    private void initialUpdatePrefviewPane() {
        TreeItem[] sel = this.viewer.getTree().getSelection();
        if (sel != null && sel.length > 0 && sel[0].getData() instanceof IResource) {
            this.selectionHasChanged((IResource)sel[0].getData());
        }
    }

    public void selectionHasChanged(IResource curentSelection) {
        String sizeTxt;
        IFile imgFile = null;
        Image selImage = null;
        if (this.okButton == null) {
            this.okButton = this.getButton(0);
            if (this.okButton != null) {
                this.okButton.setEnabled(false);
            }
        }
        if (curentSelection instanceof IFile) {
            imgFile = (IFile)curentSelection;
            selImage = this.getImg(imgFile);
        }
        if (this.imgLabel.getImage() != null) {
            this.imgLabel.getImage().dispose();
        }
        if (selImage != null) {
            sizeTxt = "  Image Size = (" + selImage.getBounds().width + "x" + selImage.getBounds().height + ")";
            if (this.okButton != null) {
                this.okButton.setEnabled(true);
            }
            this.currSelFile = imgFile;
        } else {
            sizeTxt = "";
            if (this.okButton != null) {
                this.okButton.setEnabled(false);
            }
            this.currSelFile = null;
        }
        this.txtLabel.setText(sizeTxt);
        this.imgLabel.setImage(selImage);
        this.currentPrevImg = selImage;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Image getImg(IFile imgFile) {
        Image ret = null;
        InputStream is = null;
        is = imgFile.getContents();
        ret = new Image((Device)this.viewer.getControl().getDisplay(), is);
        Object var6_4 = null;
        if (is == null) return ret;
        try {
            is.close();
            return ret;
        }
        catch (IOException e1) {
            UtilPlugin.getTracer().log(4, class$com$tssap$util$ui$dialog$ImageChooserDialog == null ? (class$com$tssap$util$ui$dialog$ImageChooserDialog = ImageChooserDialog.class$("com.tssap.util.ui.dialog.ImageChooserDialog")) : class$com$tssap$util$ui$dialog$ImageChooserDialog, "getImg(IFile imgFile)", "Unable to close file stream", (Throwable)e1);
        }
        return ret;
        {
            catch (Exception e) {
                UtilPlugin.getTracer().warning(class$com$tssap$util$ui$dialog$ImageChooserDialog == null ? (class$com$tssap$util$ui$dialog$ImageChooserDialog = ImageChooserDialog.class$("com.tssap.util.ui.dialog.ImageChooserDialog")) : class$com$tssap$util$ui$dialog$ImageChooserDialog, "getImg(IFile imgFile)", "Unable to create image", (Throwable)e);
                Object var6_5 = null;
                if (is == null) return ret;
                try {
                    is.close();
                    return ret;
                }
                catch (IOException e1) {
                    UtilPlugin.getTracer().log(4, class$com$tssap$util$ui$dialog$ImageChooserDialog == null ? (class$com$tssap$util$ui$dialog$ImageChooserDialog = ImageChooserDialog.class$("com.tssap.util.ui.dialog.ImageChooserDialog")) : class$com$tssap$util$ui$dialog$ImageChooserDialog, "getImg(IFile imgFile)", "Unable to close file stream", (Throwable)e1);
                }
                return ret;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e1) {
                UtilPlugin.getTracer().log(4, class$com$tssap$util$ui$dialog$ImageChooserDialog == null ? (class$com$tssap$util$ui$dialog$ImageChooserDialog = ImageChooserDialog.class$("com.tssap.util.ui.dialog.ImageChooserDialog")) : class$com$tssap$util$ui$dialog$ImageChooserDialog, "getImg(IFile imgFile)", "Unable to close file stream", (Throwable)e1);
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ImgChooseDisposeListener
    implements DisposeListener {
        ImgChooseDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            ImageChooserDialog.this.EMPTY_IMAGE.dispose();
            if (ImageChooserDialog.this.currentPrevImg != null) {
                ImageChooserDialog.this.currentPrevImg.dispose();
            }
        }
    }
}

