/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui.dialog;

import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class CheckboxSelectionDialog
extends SelectionDialog {
    private int[] defaultSelection;
    private int[] checkedIndexes;
    private String[] checkBoxTxt;
    private Button[] checkBoxes;

    protected CheckboxSelectionDialog(Shell shell) {
        this(shell, null, null);
    }

    protected CheckboxSelectionDialog(Shell parentShell, String title, String message) {
        this(parentShell, title, message, new String[0], new int[0]);
    }

    protected CheckboxSelectionDialog(Shell parentShell, String title, String message, String[] checkBoxTxt, int[] defaultSelection) {
        super(parentShell);
        super.setTitle(title);
        super.setMessage(message);
        this.setCheckboxTxt(checkBoxTxt);
        this.setDefaultSelection(defaultSelection);
        this.checkedIndexes = defaultSelection;
    }

    public static int[] openDialog(Shell shell, String title, String message, String[] selectableElements) {
        return CheckboxSelectionDialog.openDialog(shell, title, message, selectableElements, new int[0]);
    }

    public static int[] openDialog(Shell shell, String title, String message, String[] selectableElements, int[] defaultSelection) {
        CheckboxSelectionDialog diag = new CheckboxSelectionDialog(shell, title, message, selectableElements, defaultSelection);
        int pressed = diag.open();
        int[] ret = null;
        if (pressed == 0) {
            ret = diag.getCheckedIndexes();
        }
        return ret;
    }

    private void setDefaultSelection(int[] defaultSelection) {
        this.defaultSelection = defaultSelection;
    }

    private void setCheckboxTxt(String[] checkBoxTxt) {
        this.checkBoxTxt = checkBoxTxt;
    }

    protected int[] getCheckedIndexes() {
        return this.checkedIndexes;
    }

    private void handleSelectionChanged() {
        ArrayList<Integer> arL = new ArrayList<Integer>();
        int i = 0;
        while (i < this.checkBoxes.length) {
            if (this.checkBoxes[i].getSelection()) {
                arL.add(new Integer(i));
            }
            ++i;
        }
        this.checkedIndexes = new int[arL.size()];
        int i2 = 0;
        while (i2 < this.checkedIndexes.length) {
            this.checkedIndexes[i2] = (Integer)arL.get(i2);
            ++i2;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createCheckboxArea(composite);
        return composite;
    }

    private void createCheckboxArea(Composite composite) {
        IGridLayoutPane checkBoxPane = PaneFactory.createGridLayoutPane(composite, 1);
        checkBoxPane.addTextLabel(this.getMessage());
        this.checkBoxes = new Button[this.checkBoxTxt.length];
        int i = 0;
        while (i < this.checkBoxTxt.length) {
            this.checkBoxes[i] = checkBoxPane.addCheckBox(this.checkBoxTxt[i], false);
            this.checkBoxes[i].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CheckboxSelectionDialog.this.handleSelectionChanged();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    CheckboxSelectionDialog.this.handleSelectionChanged();
                }
            });
            ++i;
        }
        int i2 = 0;
        while (i2 < this.defaultSelection.length) {
            if (this.defaultSelection[i2] < this.checkBoxes.length) {
                this.checkBoxes[i2].setSelection(true);
            }
            ++i2;
        }
    }
}

