/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui;

import com.tssap.util.UtilPlugin;
import com.tssap.util.ui.ILabel;
import com.tssap.util.ui.lfsupport.EditorWidgetFactoryContainer;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UIPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button[] radioButtons;

    protected Control createContents(Composite parent) {
        Composite ret = null;
        IGridLayoutPane glp = PaneFactory.createGridLayoutPaneEqualCols(parent, 1);
        IGridLayoutData glData = glp.createGridLayoutData(4, 1, true, false);
        IGridLayoutPane widgetFactoryGlp = glp.addGridLayoutPane("Editor Widget Factories", 1, glData);
        IWidgetFactory[] wFactories = EditorWidgetFactoryContainer.getSingleton().getWidgetFactories();
        this.radioButtons = new Button[wFactories.length];
        int i = 0;
        while (i < wFactories.length) {
            IWidgetFactory factory = wFactories[i];
            String fullName = factory.getClass().toString();
            String name = fullName.substring(fullName.lastIndexOf(".") + 1);
            if (factory instanceof ILabel) {
                name = ((ILabel)((Object)factory)).getName();
            }
            this.radioButtons[i] = widgetFactoryGlp.addRadioButton(name);
            this.radioButtons[i].setToolTipText(fullName);
            if (i == EditorWidgetFactoryContainer.getSingleton().getActiveWidgetFactoryIndex()) {
                this.radioButtons[i].setSelection(true);
            } else {
                this.radioButtons[i].setSelection(false);
            }
            ++i;
        }
        ret = glp.getComposite();
        ret.setLayoutData((Object)new GridData(0));
        return ret;
    }

    public void init(IWorkbench workbench) {
        this.refreshUIFromData();
    }

    private void refreshUIFromData() {
        Button radio;
        int activeWidgetFactoryIndex = EditorWidgetFactoryContainer.getSingleton().getActiveWidgetFactoryIndex();
        if (this.radioButtons != null && activeWidgetFactoryIndex < this.radioButtons.length && (radio = this.radioButtons[activeWidgetFactoryIndex]) != null) {
            radio.setSelection(true);
        }
    }

    private void refreshDataFromUI() {
        int i = 0;
        while (i < this.radioButtons.length) {
            Button radio = this.radioButtons[i];
            if (radio.getSelection()) {
                UtilPlugin.getInstance().getPreferenceStore().setValue("editor widget factory index", i);
            }
            ++i;
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        UtilPlugin.getInstance().getPreferenceStore().setToDefault("editor widget factory index");
        this.refreshUIFromData();
    }

    private int calculateSelectedRadioButtonIndex() {
        int i = 0;
        while (i < this.radioButtons.length) {
            Button radio = this.radioButtons[i];
            if (radio.getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean performOk() {
        this.refreshDataFromUI();
        return super.performOk();
    }
}

