/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui;

import com.tssap.util.ui.FocusControlSeachVisitor;
import com.tssap.util.ui.IControlVisitor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class SWTUtil {
    private static Color color_EditableViewerBackground;
    private static Color color_ReadOnlyViewerBackground;

    private SWTUtil() {
    }

    public static void visitControl(Control control, IControlVisitor controlVisitor) {
        boolean continueVisiting = controlVisitor.visit(control);
        if (continueVisiting && control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                Control childControl = children[i];
                SWTUtil.visitControl(childControl, controlVisitor);
                ++i;
            }
        }
    }

    public static Color getEditableViewerBackground() {
        Color c1 = Display.getDefault().getSystemColor(25);
        if (color_EditableViewerBackground != null && c1.getRGB().equals((Object)color_EditableViewerBackground.getRGB())) {
            c1.dispose();
        } else {
            color_EditableViewerBackground = c1;
        }
        return color_EditableViewerBackground;
    }

    public static Color getReadOnlyViewerBackground() {
        Color c1 = Display.getDefault().getSystemColor(22);
        if (color_ReadOnlyViewerBackground != null && c1.getRGB().equals((Object)color_ReadOnlyViewerBackground.getRGB())) {
            c1.dispose();
        } else {
            color_ReadOnlyViewerBackground = c1;
        }
        return color_ReadOnlyViewerBackground;
    }

    public static Control findFocusControl(Control control) {
        FocusControlSeachVisitor fcsv = new FocusControlSeachVisitor();
        SWTUtil.visitControl(control, fcsv);
        return fcsv.getFocusControl();
    }

    public static class BasicControlActions {
        public static void cut(Control control) {
            if (control instanceof Text) {
                Text textControl = (Text)control;
                textControl.cut();
            } else if (control instanceof Combo) {
                Combo comboControl = (Combo)control;
                comboControl.cut();
            } else if (control instanceof StyledText) {
                StyledText styledTextControl = (StyledText)control;
                styledTextControl.cut();
            }
        }

        public static void paste(Control control) {
            if (control instanceof Text) {
                Text textControl = (Text)control;
                textControl.paste();
            } else if (control instanceof Combo) {
                Combo comboControl = (Combo)control;
                comboControl.paste();
            } else if (control instanceof StyledText) {
                StyledText styledTextControl = (StyledText)control;
                styledTextControl.paste();
            }
        }

        public static void copy(Control control) {
            if (control instanceof Text) {
                Text textControl = (Text)control;
                textControl.copy();
            } else if (control instanceof Combo) {
                Combo comboControl = (Combo)control;
                comboControl.copy();
            } else if (control instanceof StyledText) {
                StyledText styledTextControl = (StyledText)control;
                styledTextControl.copy();
            }
        }

        public static void selectAll(Control control) {
            if (control instanceof Text) {
                Text textControl = (Text)control;
                textControl.selectAll();
            } else if (!(control instanceof Combo) && control instanceof StyledText) {
                StyledText styledTextControl = (StyledText)control;
                styledTextControl.selectAll();
            }
        }
    }
}

