/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui;

import com.tssap.util.ui.ILabelProviderContainer;
import com.tssap.util.ui.ITooltipProvider;
import java.util.Vector;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class LabelProviderContainer
extends LabelProvider
implements ILabelProviderContainer,
ITooltipProvider {
    private Vector labelProviderVector;
    private ILabelProviderListener lPListener;
    private String defaultText = "";
    private Image defaultImage = null;

    public LabelProviderContainer() {
    }

    public LabelProviderContainer(String defaultText) {
        this();
        this.setDefaultText(defaultText);
    }

    public LabelProviderContainer(String defaultText, Image defaultImage) {
        this(defaultText);
        this.setDefaultImage(defaultImage);
    }

    public Image getImage(Object element) {
        Image ret = null;
        ILabelProvider[] lps = this.getLabelProviders();
        int i = 0;
        while (ret == null && i < lps.length) {
            ILabelProvider lp = lps[i];
            ret = lp.getImage(element);
            ++i;
        }
        if (ret == null) {
            ret = this.getDefaultImage();
        }
        return ret;
    }

    public String getText(Object element) {
        String ret = null;
        ILabelProvider[] lps = this.getLabelProviders();
        int i = 0;
        while (ret == null && i < lps.length) {
            ILabelProvider lp = lps[i];
            ret = lp.getText(element);
            ++i;
        }
        if (ret == null) {
            ret = this.getDefaultText();
        }
        return ret;
    }

    public String getTooltipText(Object element) {
        String ret = null;
        ILabelProvider[] lps = this.getLabelProviders();
        int i = 0;
        while (ret == null && i < lps.length) {
            ILabelProvider labelProvider = lps[i];
            if (labelProvider instanceof DecoratingLabelProvider) {
                labelProvider = ((DecoratingLabelProvider)labelProvider).getLabelProvider();
            }
            if (labelProvider instanceof ITooltipProvider) {
                ret = ((ITooltipProvider)labelProvider).getTooltipText(element);
            }
            ++i;
        }
        return ret;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    private Vector getLabelProviderVector() {
        if (this.labelProviderVector == null) {
            this.labelProviderVector = new Vector();
        }
        return this.labelProviderVector;
    }

    public boolean addLabelProvider(ILabelProvider lp) {
        if (!this.getLabelProviderVector().contains(lp)) {
            lp.addListener(this.getLabelProviderListener());
        }
        return this.getLabelProviderVector().add(lp);
    }

    public ILabelProvider[] getLabelProviders() {
        ILabelProvider[] ret = new ILabelProvider[]{};
        ret = this.getLabelProviderVector().toArray(ret);
        return ret;
    }

    public void removeAllLabelProviders() {
        ILabelProvider[] labelProviders = this.getLabelProviders();
        int i = 0;
        while (i < labelProviders.length) {
            ILabelProvider lp = labelProviders[i];
            this.removeLabelProvider(lp);
            ++i;
        }
    }

    public boolean removeLabelProvider(ILabelProvider lp) {
        if (this.getLabelProviderVector().contains(lp)) {
            lp.removeListener(this.getLabelProviderListener());
        }
        return this.getLabelProviderVector().remove(lp);
    }

    private ILabelProviderListener getLabelProviderListener() {
        if (this.lPListener == null) {
            this.lPListener = new LabelProviderListner();
        }
        return this.lPListener;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public Image getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(Image defaultImage) {
        this.defaultImage = defaultImage;
    }

    private class LabelProviderListner
    implements ILabelProviderListener {
        private LabelProviderListner() {
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            LabelProviderContainer.super.fireLabelProviderChanged(event);
        }
    }
}

