/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui;

import com.tssap.util.core.IFilter;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class FilteredTreeContentProvider
implements ITreeContentProvider {
    private IFilter filter;
    private ITreeContentProvider tcp;
    private ArrayList reusedList = new ArrayList();

    public FilteredTreeContentProvider(ITreeContentProvider tcp, IFilter filter) {
        this.tcp = tcp;
        this.filter = filter;
    }

    public Object[] getChildren(Object parentElement) {
        return this.getFilteredElements(this.tcp.getChildren(parentElement));
    }

    public Object getParent(Object element) {
        return this.tcp.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getFilteredElements(this.tcp.getElements(inputElement));
    }

    public void dispose() {
        this.tcp.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.tcp.inputChanged(viewer, oldInput, newInput);
    }

    private Object[] getFilteredElements(Object[] elements) {
        this.reusedList.clear();
        int i = 0;
        while (i < elements.length) {
            if (this.filter.accept(elements[i])) {
                this.reusedList.add(elements[i]);
            }
            ++i;
        }
        return this.reusedList.toArray(new Object[this.reusedList.size()]);
    }
}

