/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.ui;

import com.tssap.util.ui.IControlVisitor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;

public class EditableVisitor
implements IControlVisitor {
    public static int COMBO = 1;
    public static int BUTTON_RADIO = 2;
    public static int BUTTON_CHECK = 4;
    public static int BUTTON_PRESS = 8;
    public static int TEXT = 16;
    public static int SLIDER = 32;
    public static int ALL_CONTROLS = -1;
    public static int DEFAULT_CONTROLS = COMBO | BUTTON_CHECK | BUTTON_RADIO | TEXT | SLIDER;
    private boolean editable;
    private int controlTypes;

    public EditableVisitor(boolean editable) {
        this(editable, DEFAULT_CONTROLS);
    }

    public EditableVisitor(boolean editable, int controlTypes) {
        this.editable = editable;
        this.controlTypes = controlTypes;
    }

    public boolean visit(Control control) {
        boolean ret = true;
        if ((this.controlTypes & TEXT) > 0 && control instanceof Text) {
            ((Text)control).setEditable(this.editable);
        } else if (control instanceof Button) {
            Button button = (Button)control;
            int style = button.getStyle();
            if ((this.controlTypes & BUTTON_CHECK) > 0 && (style & 0x20) > 0 || (this.controlTypes & TEXT) > 0 && (style & 0x10) > 0) {
                button.setEnabled(this.editable);
            }
        } else if ((this.controlTypes & SLIDER) > 0 && control instanceof Slider) {
            ((Slider)control).setEnabled(this.editable);
        } else if ((this.controlTypes & COMBO) > 0 && control instanceof Combo) {
            ((Combo)control).setEnabled(this.editable);
        }
        return ret;
    }

    public boolean isEditable() {
        return this.editable;
    }
}

