/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.trace.internal;

import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.trace.internal.EclipseLog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public class PlatformLogListener
implements ILogListener {
    private static boolean isEnabled;
    private static PlatformLogListener instance;

    private PlatformLogListener() {
    }

    public static void activate(boolean activate) {
        if (instance == null) {
            instance = new PlatformLogListener();
        }
        if (activate) {
            Platform.addLogListener((ILogListener)instance);
            PlatformLogListener.setEnabled(true);
        } else {
            Platform.removeLogListener((ILogListener)instance);
            PlatformLogListener.setEnabled(false);
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void setEnabled(boolean enable) {
        isEnabled = enable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logging(IStatus status, String plugin) {
        if (!PlatformLogListener.isEnabled()) {
            return;
        }
        EclipseLog.setActive(false);
        try {
            try {
                this.traceStatus(status, plugin, 0);
            }
            catch (Throwable th) {
                System.err.println(this.getClass().getName() + ".logging(IStatus status, String plugin): Error tracing a platform Status.");
                th.printStackTrace(System.err);
                Object var5_4 = null;
                EclipseLog.setActive(true);
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            EclipseLog.setActive(true);
            throw throwable;
        }
        EclipseLog.setActive(true);
    }

    private void traceStatus(IStatus status, String plugin, int level) {
        int logLevel = status.getSeverity();
        TracerI statusTracer = TracingManager.getTracer(status.getPlugin());
        String message = (level == 0 ? "" : "--" + level + "--") + "STATUSLOG " + "\n  " + "!MESSAGE " + status.getMessage();
        Throwable thrown = status.getException();
        switch (logLevel) {
            case 4: {
                if (!statusTracer.error()) break;
                statusTracer.error(message, thrown);
                break;
            }
            case 2: {
                if (!statusTracer.warning()) break;
                statusTracer.warning(message, thrown);
                break;
            }
            case 1: {
                if (!statusTracer.info()) break;
                statusTracer.info(message);
                break;
            }
            case 0: {
                if (!statusTracer.debug()) break;
                statusTracer.debug(message);
            }
        }
        IStatus[] children = status.getChildren();
        int i = 0;
        while (i < children.length) {
            this.traceStatus(children[i], plugin, level + 1);
            ++i;
        }
    }
}

