/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.trace.internal;

import com.tssap.util.trace.internal.LogStorage;
import java.util.HashMap;
import java.util.Map;

public class MemLogFactory {
    public static final String MEM_LOG_STORAGE = "MemLogStorage";
    public static final String USER_OUT_STORAGE = "UserOutStorage";
    private static Map storageMap = new HashMap(2);
    private static Map storageSizeMap = new HashMap(2);

    public static LogStorage getMemLogImpl(String storageId) {
        MemLogFactory.checkId(storageId);
        Object ret = storageMap.get(storageId);
        if (ret == null) {
            LogStorage storage = new LogStorage((Integer)storageSizeMap.get(storageId));
            storageMap.put(storageId, storage);
            ret = storage;
        }
        return (LogStorage)ret;
    }

    public static void setMemLogSize(String storageId, int newSize) {
        MemLogFactory.checkId(storageId);
        int oldSize = (Integer)storageSizeMap.get(storageId);
        if (oldSize != newSize) {
            storageSizeMap.put(storageId, new Integer(newSize));
            Object storage = storageMap.get(storageId);
            if (storage != null) {
                ((LogStorage)storage).setMemSize(newSize);
            }
        }
    }

    private static void checkId(String storageId) {
        if (storageId == null || !storageMap.containsKey(storageId)) {
            throw new IllegalArgumentException(storageId + " is invalid storageId");
        }
    }

    static {
        storageMap.put(MEM_LOG_STORAGE, null);
        storageMap.put(USER_OUT_STORAGE, null);
        storageSizeMap.put(MEM_LOG_STORAGE, new Integer(500));
        storageSizeMap.put(USER_OUT_STORAGE, new Integer(500));
    }
}

