/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.trace.internal;

import com.sap.tc.logging.LogRecord;
import com.tssap.util.trace.internal.ILogListener;
import java.util.ArrayList;
import java.util.List;

public class LogStorage {
    private LogRecord[] memory;
    private List myLogListener = new ArrayList();
    private int memSize;
    private int memCount;
    private boolean full;

    protected LogStorage() {
        this(500);
    }

    protected LogStorage(int initialSize) {
        if (initialSize < 1) {
            throw new IllegalArgumentException();
        }
        this.memory = new LogRecord[initialSize];
        this.memCount = -1;
        this.full = false;
        this.memSize = initialSize;
    }

    protected synchronized LogRecord write(LogRecord log) {
        if (++this.memCount == this.memSize) {
            this.full = true;
            this.memCount = 0;
        }
        this.memory[this.memCount] = log;
        this.fireLogged(log);
        return log;
    }

    protected synchronized LogRecord[] getInternalMemLogs() {
        int count = this.full ? this.memCount + 1 : 0;
        int num = this.full ? this.memSize : this.memCount + 1;
        LogRecord[] ret = new LogRecord[num];
        int i = 0;
        while (i < num) {
            ret[i] = this.memory[count++];
            if (count == this.memSize) {
                count = 0;
            }
            ++i;
        }
        return ret;
    }

    protected synchronized void clearMemLogs() {
        this.memCount = -1;
        this.full = false;
    }

    protected int getMemSize() {
        return this.memSize;
    }

    protected synchronized void setMemSize(int memSize) {
        if (memSize != this.memSize) {
            LogRecord[] oldLogs = this.getInternalMemLogs();
            this.memory = new LogRecord[memSize];
            this.full = false;
            this.memCount = -1;
            this.memSize = memSize;
            int i = 0;
            while (i < oldLogs.length) {
                this.write(oldLogs[i]);
                ++i;
            }
        }
    }

    protected void addLogListener(ILogListener listener) {
        if (listener == null) {
            throw new IllegalAccessError("listener == null");
        }
        List list = this.myLogListener;
        synchronized (list) {
            if (this.myLogListener.contains(listener)) {
                return;
            }
            this.myLogListener.add(listener);
        }
    }

    protected void removeLogListener(ILogListener listener) {
        if (listener == null) {
            return;
        }
        List list = this.myLogListener;
        synchronized (list) {
            if (!this.myLogListener.contains(listener)) {
                return;
            }
            this.myLogListener.remove(listener);
        }
    }

    protected void fireLogged(LogRecord log) {
        Object[] listeners;
        List list = this.myLogListener;
        synchronized (list) {
            listeners = this.myLogListener.toArray();
        }
        int i = 0;
        while (i < listeners.length) {
            ((ILogListener)listeners[i]).logged(log);
            ++i;
        }
    }
}

