/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.trace.internal;

import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.TraceFormatter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;

public class EclipseFormatter
extends Formatter {
    private static final String SPACE = " ";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String PROPSTR_LEVEL_NONE = "NONE";
    private static final String PROPSTR_LEVEL_FATAL = "FATAL";
    private static final String PROPSTR_LEVEL_ERROR = "ERROR";
    private static final String PROPSTR_LEVEL_WARNING = "WARNING";
    private static final String PROPSTR_LEVEL_INFO = "INFO";
    private static final String PROPSTR_LEVEL_PATH = "PATH";
    private static final String PROPSTR_LEVEL_DEBUG = "DEBUG";
    private static final String PROPSTR_LEVEL_ALL = "ALL";
    public static final int OPTION_DATE = 1;
    public static final int OPTION_SOURCE = 2;
    public static final int OPTION_THREAD = 4;
    public static final int OPTION_SEVERITY = 8;
    public static final int OPTION_STACKS = 16;
    public static final int OPTION_APPEND_OBJECTS = 32;
    public static final int OPTION_DEFAULT = 31;
    private int formatOptions;
    public static final Formatter MSG_FORMATTER = new TraceFormatter("%m");

    public EclipseFormatter() {
        this(31);
    }

    public EclipseFormatter(int formatOptions) {
        this.formatOptions = formatOptions;
    }

    public String format(LogRecord logRec) {
        List argObjList = logRec.getArgObjs();
        Object[] argObj = argObjList.toArray(new Object[argObjList.size()]);
        Date time = logRec.getTime();
        String threadName = logRec.getThreadName();
        String sourceName = logRec.getSourceName();
        int severity = logRec.getSeverity();
        String locationName = logRec.getLocation();
        StringBuffer buf = new StringBuffer();
        if ((this.formatOptions & 1) > 0) {
            buf.append(DateFormat.getDateInstance().format(time));
            buf.append(SPACE);
            buf.append(DateFormat.getTimeInstance().format(time));
            buf.append(SPACE);
        }
        if ((this.formatOptions & 2) > 0) {
            buf.append(sourceName);
            buf.append(SPACE);
        }
        if (!locationName.equals(sourceName) && (this.formatOptions & 2) > 0) {
            buf.append("(");
            buf.append(locationName);
            buf.append(")");
            buf.append(SPACE);
        }
        if ((this.formatOptions & 4) > 0) {
            buf.append("[" + threadName + "]");
            buf.append(SPACE);
        }
        if ((this.formatOptions & 8) > 0) {
            buf.append(this.getTraceLevelName(severity));
            buf.append(": ");
        }
        buf.append(MSG_FORMATTER.format(logRec));
        int i = 0;
        while (i < argObj.length) {
            buf.append(LINE_SEP);
            if (argObj[i] instanceof Throwable && (this.formatOptions & 0x10) > 0) {
                buf.append(this.getStackTrace((Throwable)argObj[i]));
            } else if ((this.formatOptions & 0x20) > 0) {
                buf.append(argObj[i] != null ? argObj[i].toString() : "null");
            }
            ++i;
        }
        buf.append(LINE_SEP);
        return buf.toString();
    }

    private Object getTraceLevelName(int severity) {
        String ret;
        switch (severity) {
            case 701: {
                ret = PROPSTR_LEVEL_NONE;
                break;
            }
            case 600: {
                ret = PROPSTR_LEVEL_FATAL;
                break;
            }
            case 500: {
                ret = PROPSTR_LEVEL_ERROR;
                break;
            }
            case 400: {
                ret = PROPSTR_LEVEL_WARNING;
                break;
            }
            case 300: {
                ret = PROPSTR_LEVEL_INFO;
                break;
            }
            case 200: {
                ret = PROPSTR_LEVEL_PATH;
                break;
            }
            case 100: {
                ret = PROPSTR_LEVEL_DEBUG;
                break;
            }
            case 0: {
                ret = PROPSTR_LEVEL_ALL;
                break;
            }
            default: {
                ret = "";
            }
        }
        return ret;
    }

    private String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(os);
        throwable.printStackTrace(out);
        return new String(os.toByteArray());
    }
}

