/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.trace.internal;

import com.sap.tc.logging.Filter;
import com.sap.tc.logging.LogRecord;
import com.tssap.util.UtilPlugin;
import com.tssap.util.trace.UserOutputCategory;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;

public class DefaultEclipseLogFilter
implements Filter {
    private static final String LOCATION_FILTER_FILENAME = "logFilter.properties";
    private static String[] filteredSources;
    static /* synthetic */ Class class$com$tssap$util$trace$internal$DefaultEclipseLogFilter;

    public DefaultEclipseLogFilter() {
        DefaultEclipseLogFilter.init();
    }

    public boolean beLogged(LogRecord logRec) {
        return !this.isSourceFiltered(logRec.getSourceName());
    }

    private boolean isSourceFiltered(String scrName) {
        int i = 0;
        while (i < filteredSources.length) {
            if (scrName.startsWith(filteredSources[i]) && (scrName.length() == filteredSources[i].length() || scrName.charAt(filteredSources[i].length()) == '.' || scrName.charAt(filteredSources[i].length()) == '/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void init() {
        if (filteredSources == null) {
            long time = System.currentTimeMillis();
            filteredSources = DefaultEclipseLogFilter.initializeSourceNames();
            long l = System.currentTimeMillis() - time;
        }
    }

    private static String[] initializeSourceNames() {
        ArrayList<String> locList = new ArrayList<String>();
        locList.add(UserOutputCategory.getUserOutputCategoryName());
        IPluginDescriptor[] pds = Platform.getPluginRegistry().getPluginDescriptors();
        int i = 0;
        while (i < pds.length) {
            URL pInstUrl = pds[i].getInstallURL();
            try {
                URL fUrl = new URL(pInstUrl, LOCATION_FILTER_FILENAME);
                Properties p = new Properties();
                InputStream fInStream = fUrl.openStream();
                p.load(fInStream);
                Enumeration enumeration = ((Hashtable)p).keys();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    if (!"OFF".equalsIgnoreCase(p.getProperty(key))) continue;
                    locList.add(key);
                }
            }
            catch (MalformedURLException e) {
                UtilPlugin.logErrorMessage((class$com$tssap$util$trace$internal$DefaultEclipseLogFilter == null ? DefaultEclipseLogFilter.class$("com.tssap.util.trace.internal.DefaultEclipseLogFilter") : class$com$tssap$util$trace$internal$DefaultEclipseLogFilter).getName() + ".getFilteredSourceNames() - Problem creating URL to location filter file: " + e.getMessage());
            }
            catch (IOException e) {
                // empty catch block
            }
            ++i;
        }
        return locList.toArray(new String[locList.size()]);
    }

    public static String[] getFilteredSourceNames() {
        DefaultEclipseLogFilter.init();
        String[] ret = new String[filteredSources.length];
        System.arraycopy(filteredSources, 0, ret, 0, filteredSources.length);
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

