/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.trace.internal;

import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.tssap.util.trace.internal.ILogListener;
import com.tssap.util.trace.internal.ILogListenerHandler;
import com.tssap.util.trace.internal.LogStorage;
import com.tssap.util.trace.internal.MemLogFactory;

public class BasicMemLog
extends Log
implements ILogListenerHandler {
    public static final int DEFAULT_SIZE = 500;
    private String encoding;
    private LogStorage myLogStorage;

    protected BasicMemLog(String id) {
        this.myLogStorage = MemLogFactory.getMemLogImpl(id);
    }

    protected synchronized LogRecord forcedWrite(LogRecord log) {
        return this.myLogStorage.write(log);
    }

    public LogRecord write(LogRecord logRec) {
        this.writeInt(logRec);
        return logRec;
    }

    protected synchronized String writeInt(LogRecord log) {
        if (this.beLogged(log.getSeverity()) && this.isFiltersAgreeing(log)) {
            this.myLogStorage.write(log);
        }
        return log.getMsgClear();
    }

    public synchronized void clearMemLogs() {
        this.myLogStorage.clearMemLogs();
    }

    public int getMemSize() {
        return this.myLogStorage.getMemSize();
    }

    public LogRecord[] getMemLogs() {
        return this.myLogStorage.getInternalMemLogs();
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void addLogListener(ILogListener listener) {
        this.myLogStorage.addLogListener(listener);
    }

    public void removeLogListener(ILogListener listener) {
        this.myLogStorage.removeLogListener(listener);
    }
}

