/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.trace;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.tssap.util.trace.Tracer;
import com.tssap.util.trace.UserOutputCategory;

public class TracerEclipseImpl
extends Tracer {
    private static final int[] LEVEL = new int[]{701, 600, 500, 400, 300, 200, 100, 100, 100, 100, 0};
    private Location myLocation;

    protected TracerEclipseImpl(Location location) {
        this.myLocation = location;
    }

    private int checkLevel(int level) {
        if (level >= 0 && level <= 10) {
            return level;
        }
        return 3;
    }

    public void log(int level, String msg, Throwable throwable) {
        int checkedLevel = this.checkLevel(level);
        if (throwable == null) {
            this.myLocation.logT(LEVEL[checkedLevel], msg);
        } else {
            this.myLocation.logT(LEVEL[checkedLevel], msg, new Object[]{throwable});
        }
        if (checkedLevel != level) {
            this.myLocation.errorT("The last message was written with incorrect level: " + level + ". Level was mapped to WARNING");
        }
    }

    public boolean fatal() {
        return this.myLocation.beFatal();
    }

    public boolean error() {
        return this.myLocation.beError();
    }

    public boolean warning() {
        return this.myLocation.beWarning();
    }

    public boolean info() {
        return this.myLocation.beInfo();
    }

    public boolean path() {
        return this.myLocation.bePath();
    }

    public boolean debug() {
        return this.myLocation.beDebug();
    }

    public boolean fine() {
        return this.myLocation.beDebug();
    }

    public boolean finer() {
        return this.myLocation.beDebug();
    }

    public boolean finest() {
        return this.myLocation.beDebug();
    }

    public int getTraceLevel() {
        boolean done = false;
        int ret = 0;
        int i = 1;
        while (i < LEVEL.length && !done) {
            if (this.log(i)) {
                ret = i;
            } else {
                done = true;
            }
            ++i;
        }
        return ret;
    }

    public boolean log(int level) {
        return this.myLocation.beLogged(LEVEL[level]);
    }

    public void userOut(int level, String msg) {
        this.userOut(null, level, msg);
    }

    public void userOut(String subCategory, int level, String msg) {
        Category userOutCat = subCategory != null && subCategory.length() > 0 ? UserOutputCategory.getUserOutputSubCategory(subCategory) : UserOutputCategory.getUserOutputCategory();
        int checkedLevel = this.checkLevel(level);
        userOutCat.logT(LEVEL[checkedLevel], this.myLocation, msg);
    }

    public void userOut(String subCategory, String msg) {
        this.userOut(subCategory, 4, msg);
    }

    public void userOut(String msg) {
        this.userOut(null, 4, msg);
    }
}

