/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.trace;

import com.tssap.util.trace.TracerI;

abstract class Tracer
implements TracerI {
    protected Tracer() {
    }

    public void fatal(String msg) {
        this.log(1, msg);
    }

    public void fatal(String className, String methodName, String msg) {
        this.log(1, className, methodName, msg);
    }

    public void fatal(String methodName, String msg) {
        this.log(1, methodName, msg);
    }

    public void fatal(Class clazz, String methodName, String msg) {
        this.log(1, clazz, methodName, msg);
    }

    public void fatal(String msg, Throwable throwable) {
        this.log(1, msg, throwable);
    }

    public void fatal(String className, String methodName, String msg, Throwable throwable) {
        this.log(1, className, methodName, msg, throwable);
    }

    public void fatal(Class clazz, String methodName, String msg, Throwable throwable) {
        this.log(1, clazz, methodName, msg, throwable);
    }

    public void fatal(String methodName, String msg, Throwable throwable) {
        this.log(1, methodName, msg, throwable);
    }

    public void error(String msg) {
        this.log(2, msg);
    }

    public void error(String className, String methodName, String msg) {
        this.log(2, className, methodName, msg);
    }

    public void error(String methodName, String msg) {
        this.log(2, methodName, msg);
    }

    public void error(Class clazz, String methodName, String msg) {
        this.log(2, clazz, methodName, msg);
    }

    public void error(String msg, Throwable throwable) {
        this.log(2, msg, throwable);
    }

    public void error(String className, String methodName, String msg, Throwable throwable) {
        this.log(2, className, methodName, msg, throwable);
    }

    public void error(Class clazz, String methodName, String msg, Throwable throwable) {
        this.log(2, clazz, methodName, msg, throwable);
    }

    public void error(String methodName, String msg, Throwable throwable) {
        this.log(2, methodName, msg, throwable);
    }

    public void warning(String msg) {
        this.log(3, msg);
    }

    public void warning(String className, String methodName, String msg) {
        this.log(3, className, methodName, msg);
    }

    public void warning(String methodName, String msg) {
        this.log(3, methodName, msg);
    }

    public void warning(Class clazz, String methodName, String msg) {
        this.log(3, clazz, methodName, msg);
    }

    public void warning(String msg, Throwable throwable) {
        this.log(3, msg, throwable);
    }

    public void warning(String className, String methodName, String msg, Throwable throwable) {
        this.log(3, className, methodName, msg, throwable);
    }

    public void warning(Class clazz, String methodName, String msg, Throwable throwable) {
        this.log(3, clazz, methodName, msg, throwable);
    }

    public void warning(String methodName, String msg, Throwable throwable) {
        this.log(3, methodName, msg, throwable);
    }

    public void info(String msg) {
        this.log(4, msg);
    }

    public void info(String methodName, String msg) {
        this.log(4, methodName, msg);
    }

    public void info(String className, String methodName, String msg) {
        this.log(4, className, methodName, msg);
    }

    public void info(Class clazz, String methodName, String msg) {
        this.log(4, clazz, methodName, msg);
    }

    public void path(String msg) {
        this.log(5, msg);
    }

    public void path(String methodName, String msg) {
        this.log(5, methodName, msg);
    }

    public void path(String className, String methodName, String msg) {
        this.log(5, className, methodName, msg);
    }

    public void path(Class clazz, String methodName, String msg) {
        this.log(5, clazz, methodName, msg);
    }

    public void debug(String msg) {
        this.log(6, msg);
    }

    public void debug(String methodName, String msg) {
        this.log(6, methodName, msg);
    }

    public void debug(String className, String methodName, String msg) {
        this.log(6, className, methodName, msg);
    }

    public void debug(Class clazz, String methodName, String msg) {
        this.log(6, clazz, methodName, msg);
    }

    public void fine(String msg) {
        this.log(7, msg);
    }

    public void fine(String methodName, String msg) {
        this.log(7, methodName, msg);
    }

    public void fine(String className, String methodName, String msg) {
        this.log(7, className, methodName, msg);
    }

    public void fine(Class clazz, String methodName, String msg) {
        this.log(7, clazz, methodName, msg);
    }

    public void finer(String msg) {
        this.log(8, msg);
    }

    public void finer(String methodName, String msg) {
        this.log(8, methodName, msg);
    }

    public void finer(String className, String methodName, String msg) {
        this.log(8, className, methodName, msg);
    }

    public void finer(Class clazz, String methodName, String msg) {
        this.log(8, clazz, methodName, msg);
    }

    public void finest(String msg) {
        this.log(9, msg);
    }

    public void finest(String methodName, String msg) {
        this.log(9, methodName, msg);
    }

    public void finest(String className, String methodName, String msg) {
        this.log(9, className, methodName, msg);
    }

    public void finest(Class clazz, String methodName, String msg) {
        this.log(9, clazz, methodName, msg);
    }

    public void log(int level, String msg) {
        this.log(level, msg, (Throwable)null);
    }

    public void log(int level, String methodName, String msg) {
        this.log(level, (String)null, methodName, msg, (Throwable)null);
    }

    public void log(int level, String className, String methodName, String msg) {
        this.log(level, className, methodName, msg, null);
    }

    public void log(int level, Class clazz, String methodName, String msg) {
        this.log(level, clazz.getName(), methodName, msg, null);
    }

    public void log(int level, Class clazz, String methodName, String msg, Throwable throwable) {
        this.log(level, clazz.getName(), methodName, msg, throwable);
    }

    public void log(int level, String methodName, String msg, Throwable throwable) {
        this.log(level, (String)null, methodName, msg, throwable);
    }

    public void log(int level, String className, String methodName, String msg, Throwable throwable) {
        msg = (className != null && className.length() > 0 ? "class: " + className + "  " : "") + (methodName != null && methodName.length() > 0 ? "method: " + methodName : "") + " -> " + msg;
        this.log(level, msg, throwable);
    }

    public abstract void log(int var1, String var2, Throwable var3);

    public abstract boolean fatal();

    public abstract boolean error();

    public abstract boolean warning();

    public abstract boolean info();

    public abstract boolean debug();

    public abstract boolean fine();

    public abstract boolean finer();

    public abstract boolean finest();

    public abstract int getTraceLevel();

    public abstract boolean log(int var1);

    public abstract void userOut(String var1, int var2, String var3);

    public abstract void userOut(String var1, String var2);

    public abstract void userOut(int var1, String var2);

    public abstract void userOut(String var1);

    public abstract boolean path();
}

