/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.projectinfo.internal;

import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import org.eclipse.ui.IMemento;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMMemento
implements IMemento {
    private static final TracerI tracer = TracingManager.getTracer(class$com$tssap$util$projectinfo$internal$DOMMemento == null ? (class$com$tssap$util$projectinfo$internal$DOMMemento = DOMMemento.class$("com.tssap.util.projectinfo.internal.DOMMemento")) : class$com$tssap$util$projectinfo$internal$DOMMemento);
    private Document factory;
    private Element element;
    static /* synthetic */ Class class$com$tssap$util$projectinfo$internal$DOMMemento;

    public DOMMemento(Document document, Element element) {
        this.factory = document;
        this.element = element;
    }

    public IMemento createChild(String type) {
        Element child = this.factory.createElement(type);
        this.element.appendChild(child);
        return new DOMMemento(this.factory, child);
    }

    public IMemento createChild(String type, String id) {
        Element child = this.factory.createElement(type);
        child.setAttribute("IMemento.internal.id", id);
        this.element.appendChild(child);
        return new DOMMemento(this.factory, child);
    }

    public IMemento copyChild(IMemento child) {
        Element childElement = ((DOMMemento)child).element;
        Element newElement = (Element)this.factory.importNode(childElement, true);
        this.element.appendChild(newElement);
        return new DOMMemento(this.factory, newElement);
    }

    public IMemento getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        int nX = 0;
        while (nX < size) {
            Element element;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element = (Element)node).getNodeName().equals(type)) {
                return new DOMMemento(this.factory, element);
            }
            ++nX;
        }
        return null;
    }

    public IMemento[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new IMemento[0];
        }
        ArrayList<Element> list = new ArrayList<Element>(size);
        int nX = 0;
        while (nX < size) {
            Element element;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element = (Element)node).getNodeName().equals(type)) {
                list.add(element);
            }
            ++nX;
        }
        size = list.size();
        IMemento[] results = new IMemento[size];
        int x = 0;
        while (x < size) {
            results[x] = new DOMMemento(this.factory, (Element)list.get(x));
            ++x;
        }
        return results;
    }

    public Float getFloat(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Float(strValue);
        }
        catch (NumberFormatException e) {
            tracer.error("Memento problem - Invalid float for key: " + key + " value: " + strValue);
            return null;
        }
    }

    public String getID() {
        return this.element.getAttribute("IMemento.internal.id");
    }

    public Integer getInteger(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Integer(strValue);
        }
        catch (NumberFormatException e) {
            tracer.error("Memento problem - invalid integer for key: " + key + " value: " + strValue);
            return null;
        }
    }

    public String getString(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public String getTextData() {
        Text textNode = this.getTextNode();
        if (textNode != null) {
            return textNode.getData();
        }
        return null;
    }

    private Text getTextNode() {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        int nX = 0;
        while (nX < size) {
            Node node = nodes.item(nX);
            if (node instanceof Text) {
                return (Text)node;
            }
            ++nX;
        }
        return null;
    }

    private void putElement(Element element) {
        NamedNodeMap nodeMap = element.getAttributes();
        int size = nodeMap.getLength();
        int i = 0;
        while (i < size) {
            Attr attr = (Attr)nodeMap.item(i);
            this.putString(attr.getName(), attr.getValue());
            ++i;
        }
        NodeList nodes = element.getChildNodes();
        size = nodes.getLength();
        int i2 = 0;
        while (i2 < size) {
            Node node = nodes.item(i2);
            if (node instanceof Element) {
                DOMMemento child = (DOMMemento)this.createChild(node.getNodeName());
                child.putElement((Element)node);
            }
            ++i2;
        }
    }

    public void putFloat(String key, float f) {
        this.element.setAttribute(key, String.valueOf(f));
    }

    public void putInteger(String key, int n) {
        this.element.setAttribute(key, String.valueOf(n));
    }

    public void putMemento(IMemento memento) {
        this.putElement(((DOMMemento)memento).element);
    }

    public void putString(String key, String value) {
        if (value == null) {
            return;
        }
        this.element.setAttribute(key, value);
    }

    public void putTextData(String data) {
        Text textNode = this.getTextNode();
        if (textNode == null) {
            textNode = this.factory.createTextNode(data);
            this.element.appendChild(textNode);
        } else {
            textNode.setData(data);
        }
    }

    public Element getElement() {
        return this.element;
    }

    public Document getFactory() {
        return this.factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

